/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.session.Session;
import com.openexchange.tools.encoding.Base64;
import com.openexchange.webdav.WebdavExceptionCode;
import com.openexchange.webdav.xml.CommonParser;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ContactParser
extends CommonParser {
    private static final Logger LOG = LoggerFactory.getLogger(ContactParser.class);

    public ContactParser(Session sessionObj) {
        this.sessionObj = sessionObj;
    }

    public void parse(XmlPullParser parser, Contact contactobject) throws OXException, XmlPullParserException, IOException {
        while (parser.getEventType() != 3 || !parser.getName().equals("prop")) {
            this.parseElementContact(contactobject, parser);
            parser.nextTag();
        }
    }

    protected void parseElementContact(Contact contactobject, XmlPullParser parser) throws XmlPullParserException, IOException, OXException {
        if (!this.hasCorrectNamespace(parser)) {
            LOG.trace("unknown namespace in tag: {}", (Object)parser.getName());
            parser.nextText();
            return;
        }
        if (this.isTag(parser, "last_name")) {
            contactobject.setSurName(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "first_name")) {
            contactobject.setGivenName(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "anniversary")) {
            contactobject.setAnniversary(this.getValueAsDate(parser));
            return;
        }
        if (this.isTag(parser, "assistants_name")) {
            contactobject.setAssistantName(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "birthday")) {
            contactobject.setBirthday(this.getValueAsDate(parser));
            return;
        }
        if (this.isTag(parser, "branches")) {
            contactobject.setBranches(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "business_category")) {
            contactobject.setBusinessCategory(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "categories")) {
            contactobject.setCategories(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "mobile1")) {
            contactobject.setCellularTelephone1(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "mobile2")) {
            contactobject.setCellularTelephone2(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "city")) {
            contactobject.setCityHome(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "business_city")) {
            contactobject.setCityBusiness(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "second_city")) {
            contactobject.setCityOther(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "commercial_register")) {
            contactobject.setCommercialRegister(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "company")) {
            contactobject.setCompany(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "country")) {
            contactobject.setCountryHome(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "business_country")) {
            contactobject.setCountryBusiness(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "second_country")) {
            contactobject.setCountryOther(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "department")) {
            contactobject.setDepartment(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "displayname")) {
            contactobject.setDisplayName(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "email1")) {
            contactobject.setEmail1(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "email2")) {
            contactobject.setEmail2(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "email3")) {
            contactobject.setEmail3(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "employee_type")) {
            contactobject.setEmployeeType(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "fax_business")) {
            contactobject.setFaxBusiness(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "fax_home")) {
            contactobject.setFaxHome(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "fax_other")) {
            contactobject.setFaxOther(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "file_as")) {
            contactobject.setFileAs(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "image1")) {
            String image = this.getValue(parser);
            if (image != null) {
                contactobject.setImage1(Base64.decode(image));
            } else {
                contactobject.setImage1(null);
            }
            return;
        }
        if (this.isTag(parser, "image_content_type")) {
            contactobject.setImageContentType(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "note")) {
            contactobject.setNote(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "more_info")) {
            contactobject.setInfo(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "instant_messenger")) {
            contactobject.setInstantMessenger1(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "instant_messenger2")) {
            contactobject.setInstantMessenger2(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "martital_status")) {
            contactobject.setMaritalStatus(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "managers_name")) {
            contactobject.setManagerName(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "second_name")) {
            contactobject.setMiddleName(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "nickname")) {
            contactobject.setNickname(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "number_of_children")) {
            contactobject.setNumberOfChildren(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "number_of_employee")) {
            contactobject.setNumberOfEmployee(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "position")) {
            contactobject.setPosition(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "postal_code")) {
            contactobject.setPostalCodeHome(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "business_postal_code")) {
            contactobject.setPostalCodeBusiness(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "second_postal_code")) {
            contactobject.setPostalCodeOther(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "profession")) {
            contactobject.setProfession(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "room_number")) {
            contactobject.setRoomNumber(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "sales_volume")) {
            contactobject.setSalesVolume(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "spouse_name")) {
            contactobject.setSpouseName(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "state")) {
            contactobject.setStateHome(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "business_state")) {
            contactobject.setStateBusiness(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "second_state")) {
            contactobject.setStateOther(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "street")) {
            contactobject.setStreetHome(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "business_street")) {
            contactobject.setStreetBusiness(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "second_street")) {
            contactobject.setStreetOther(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "suffix")) {
            contactobject.setSuffix(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "tax_id")) {
            contactobject.setTaxID(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "phone_assistant")) {
            contactobject.setTelephoneAssistant(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "phone_business")) {
            contactobject.setTelephoneBusiness1(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "phone_business2")) {
            contactobject.setTelephoneBusiness2(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "callback")) {
            contactobject.setTelephoneCallback(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "phone_car")) {
            contactobject.setTelephoneCar(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "phone_company")) {
            contactobject.setTelephoneCompany(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "phone_home")) {
            contactobject.setTelephoneHome1(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "phone_home2")) {
            contactobject.setTelephoneHome2(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "ip_phone")) {
            contactobject.setTelephoneIP(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "isdn")) {
            contactobject.setTelephoneISDN(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "phone_other")) {
            contactobject.setTelephoneOther(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "pager")) {
            contactobject.setTelephonePager(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "primary")) {
            contactobject.setTelephonePrimary(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "radio")) {
            contactobject.setTelephoneRadio(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "telex")) {
            contactobject.setTelephoneTelex(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "tty_tdd")) {
            contactobject.setTelephoneTTYTTD(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "url")) {
            contactobject.setURL(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "title")) {
            contactobject.setTitle(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield01")) {
            contactobject.setUserField01(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield02")) {
            contactobject.setUserField02(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield03")) {
            contactobject.setUserField03(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield04")) {
            contactobject.setUserField04(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield05")) {
            contactobject.setUserField05(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield06")) {
            contactobject.setUserField06(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield07")) {
            contactobject.setUserField07(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield08")) {
            contactobject.setUserField08(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield09")) {
            contactobject.setUserField09(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield10")) {
            contactobject.setUserField10(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield11")) {
            contactobject.setUserField11(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield12")) {
            contactobject.setUserField12(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield13")) {
            contactobject.setUserField13(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield14")) {
            contactobject.setUserField14(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield15")) {
            contactobject.setUserField15(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield16")) {
            contactobject.setUserField16(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield17")) {
            contactobject.setUserField17(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield18")) {
            contactobject.setUserField18(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield19")) {
            contactobject.setUserField19(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "userfield20")) {
            contactobject.setUserField20(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "defaultaddress")) {
            contactobject.setDefaultAddress(this.getValueAsInt(parser));
            return;
        }
        if (this.isTag(parser, "distributionlist")) {
            this.parseElementDistributionlists(contactobject, parser);
            return;
        }
        this.parseElementCommon(contactobject, parser);
    }

    protected void parseElementDistributionlists(Contact oxobject, XmlPullParser parser) throws OXException, XmlPullParserException, IOException {
        ArrayList<DistributionListEntryObject> distributionlist = new ArrayList<DistributionListEntryObject>();
        boolean isDistributionList = true;
        while (isDistributionList) {
            parser.nextTag();
            if (ContactParser.isEnd(parser)) {
                throw WebdavExceptionCode.IO_ERROR.create("invalid xml in distributionlist!");
            }
            if (parser.getName().equals("distributionlist") && parser.getEventType() == 3) {
                isDistributionList = false;
                break;
            }
            DistributionListEntryObject entry = new DistributionListEntryObject();
            if (!this.isTag(parser, "email")) {
                throw WebdavExceptionCode.IO_ERROR.create("unknown xml tag in distributionlist!");
            }
            this.parseElementEntry(parser, entry);
            distributionlist.add(entry);
        }
        oxobject.setDistributionList(distributionlist.toArray(new DistributionListEntryObject[distributionlist.size()]));
    }

    protected void parseElementEntry(XmlPullParser parser, DistributionListEntryObject entry) throws OXException, XmlPullParserException, IOException {
        String s = null;
        s = parser.getAttributeValue("http://www.open-xchange.org", "id");
        if (s != null) {
            int contact_id = Integer.parseInt(s);
            entry.setEntryID(contact_id);
        }
        if ((s = parser.getAttributeValue("http://www.open-xchange.org", "folder_id")) != null) {
            int folderId = Integer.parseInt(s);
            entry.setFolderID(folderId);
        }
        entry.setEmailfield(Integer.parseInt(parser.getAttributeValue("http://www.open-xchange.org", "emailfield")));
        entry.setDisplayname(parser.getAttributeValue("http://www.open-xchange.org", "displayname"));
        entry.setEmailaddress(this.getValue(parser));
    }
}

