/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.webdav;

import com.openexchange.ajax.AJAXUtility;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.authentication.Cookie;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.framework.request.DefaultRequestContext;
import com.openexchange.framework.request.RequestContext;
import com.openexchange.framework.request.RequestContextHolder;
import com.openexchange.groupware.notify.hostname.HostData;
import com.openexchange.java.util.UUIDs;
import com.openexchange.log.LogProperties;
import com.openexchange.login.Interface;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.oauth.provider.OAuthResourceService;
import com.openexchange.oauth.provider.OAuthSessionProvider;
import com.openexchange.oauth.provider.exceptions.OAuthInvalidTokenException;
import com.openexchange.oauth.provider.grant.OAuthGrant;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.servlet.http.Authorization;
import com.openexchange.tools.servlet.http.Cookies;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.webdav.AuthorizationHeader;
import com.openexchange.tools.webdav.LoginCustomizer;
import com.openexchange.tools.webdav.WebDAVSessionStore;
import com.openexchange.tools.webdav.WebDavServlet;
import com.openexchange.webdav.WebdavExceptionCode;
import com.openexchange.xml.jdom.JDOMParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OXServlet
extends WebDavServlet {
    private static final long serialVersionUID = 301910346402779362L;
    private static final transient Logger LOG = LoggerFactory.getLogger(OXServlet.class);
    private static final String SESSION = OXServlet.class.getName() + "SESSION";
    private static final String basicRealm = "OX WebDAV";
    protected static final String COOKIE_SESSIONID = "sessionid";
    private static final LoginPerformer loginPerformer = LoginPerformer.getInstance();

    protected OXServlet() {
    }

    protected boolean useHttpAuth() {
        return true;
    }

    protected boolean allowOAuthAccess() {
        return false;
    }

    private OAuthResourceService getOAuthResourceService() {
        return ServerServiceRegistry.getInstance().getService(OAuthResourceService.class);
    }

    private OAuthSessionProvider getOAuthSessionProvider() {
        return ServerServiceRegistry.getInstance().getService(OAuthSessionProvider.class);
    }

    protected boolean useCookies() {
        return true;
    }

    protected abstract Interface getInterface();

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.useCookies()) {
            req.getSession(true);
        }
        if (!"TRACE".equals(req.getMethod()) && this.useHttpAuth() && !this.authenticate(req, resp)) {
            return;
        }
        Session session = OXServlet.getSession(req);
        RequestContextHolder.set((RequestContext)this.buildRequestContext(req, resp, session));
        try {
            if (session != null) {
                LogProperties.putSessionProperties((Session)session);
                LOG.trace("Entering HTTP sub method. Session: {}", (Object)session);
            }
            super.service(req, resp);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            ServletException se = new ServletException(e.getMessage(), (Throwable)e);
            throw se;
        }
        finally {
            RequestContextHolder.reset();
        }
    }

    protected RequestContext buildRequestContext(HttpServletRequest req, HttpServletResponse resp, Session session) {
        int contextId = -1;
        int userId = -1;
        if (session != null) {
            contextId = session.getContextId();
            userId = session.getUserId();
        }
        HostData hostData = Tools.createHostData(req, contextId, userId, false);
        DefaultRequestContext context = new DefaultRequestContext();
        context.setHostData(hostData);
        return context;
    }

    protected LoginCustomizer getLoginCustomizer() {
        return null;
    }

    protected boolean authenticate(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Session session = null;
        if (this.useCookies()) {
            try {
                session = OXServlet.findSessionByCookie(req, resp);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                resp.sendError(500, e.getMessage());
                return false;
            }
        }
        if (null == session) {
            AuthorizationHeader authHeader = AuthorizationHeader.parseSafe(req.getHeader("authorization"));
            if (authHeader == null) {
                this.addUnauthorizedHeader(req, resp);
                resp.sendError(401, "Authorization Required!");
                return false;
            }
            switch (authHeader.getScheme().toLowerCase()) {
                case "basic": {
                    session = this.doBasicAuth(authHeader, req, resp);
                    break;
                }
                case "bearer": {
                    session = this.doOAuth(authHeader, req, resp);
                    break;
                }
                default: {
                    resp.sendError(403);
                }
            }
            if (session == null) {
                return false;
            }
        } else {
            String address = req.getRemoteAddr();
            if (null == address || !address.equals(session.getLocalIp())) {
                LOG.info("Request to server denied for session: {}. in WebDAV XML interface. Client login IP changed from {} to {}{}", new Object[]{session.getSessionID(), session.getLocalIp(), address, Character.valueOf('.')});
                this.addUnauthorizedHeader(req, resp);
                OXServlet.removeSession(session.getSessionID());
                OXServlet.removeCookie(req, resp, COOKIE_SESSIONID);
                resp.sendError(401, "Authorization Required!");
                return false;
            }
        }
        req.setAttribute(SESSION, (Object)session);
        return true;
    }

    private void handleFailedWebDAVLogin(OXException e, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (e.getCategory() == Category.CATEGORY_USER_INPUT) {
            LOG.debug("WebDAV login failed", (Throwable)e);
            this.addUnauthorizedHeader(req, resp);
            resp.sendError(401, "Authorization Required!");
        } else if (LoginExceptionCodes.AUTHENTICATION_DISABLED.equals(e)) {
            LOG.debug("WebDAV login failed", (Throwable)e);
            resp.sendError(403);
        } else {
            LOG.error("WebDAV login failed", (Throwable)e);
            resp.sendError(500, e.getMessage());
        }
    }

    private Session doBasicAuth(AuthorizationHeader authHeader, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            Authorization.Credentials creds = Authorization.decode(authHeader.getRawValue());
            if (!Authorization.checkLogin(creds.getPassword())) {
                resp.sendError(401, "Authorization Required!");
                return null;
            }
            return this.performWebDAVLogin(new LoginRequestImpl(creds.getLogin(), creds.getPassword(), this.getInterface(), req), req, resp);
        }
        catch (OXException e) {
            this.handleFailedWebDAVLogin(e, req, resp);
            return null;
        }
    }

    private Session performWebDAVLogin(LoginRequest loginRequest, HttpServletRequest req, HttpServletResponse resp) throws OXException {
        LoginCustomizer customizer = this.getLoginCustomizer();
        if (customizer != null) {
            loginRequest = customizer.modifyLogin(loginRequest);
        }
        if (!this.useCookies()) {
            return WebDAVSessionStore.getInstance().getSession(loginRequest);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(1);
        Session session = OXServlet.addSession(loginRequest, properties);
        resp.addCookie(new javax.servlet.http.Cookie(COOKIE_SESSIONID, session.getSessionID()));
        return session;
    }

    private Session doOAuth(AuthorizationHeader authHeader, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        OAuthResourceService oAuthResourceService = this.getOAuthResourceService();
        OAuthSessionProvider sessionProvider = this.getOAuthSessionProvider();
        if (oAuthResourceService == null || sessionProvider == null) {
            httpResponse.sendError(403);
            return null;
        }
        try {
            OAuthGrant grant = oAuthResourceService.validate(authHeader.getAuthString());
            httpRequest.setAttribute("com.openexchange.oauth.grant", (Object)grant);
            return sessionProvider.getSession(grant, httpRequest);
        }
        catch (OXException e) {
            if (e instanceof OAuthInvalidTokenException) {
                OAuthInvalidTokenException ex = (OAuthInvalidTokenException)e;
                String errorDescription = ex.getErrorDescription();
                StringBuilder sb = new StringBuilder("Bearer");
                sb.append(",error=\"invalid_token\"");
                if (errorDescription != null) {
                    sb.append(",error_description=\"").append(errorDescription).append("\"");
                }
                Tools.sendEmptyErrorResponse(httpResponse, 401, Collections.singletonMap("WWW-Authenticate", sb.toString()));
            } else {
                this.handleFailedWebDAVLogin(e, httpRequest, httpResponse);
            }
            return null;
        }
    }

    public static boolean doAuth(HttpServletRequest req, HttpServletResponse resp, Interface face) throws IOException {
        return OXServlet.doAuth(req, resp, face, null);
    }

    public static boolean doAuth(HttpServletRequest req, HttpServletResponse resp, Interface face, LoginCustomizer customizer) throws IOException {
        return OXServlet.doAuth(req, resp, face, customizer, true);
    }

    public static boolean doAuth(HttpServletRequest req, HttpServletResponse resp, Interface face, LoginCustomizer customizer, boolean useCookies) throws IOException {
        Session session = null;
        if (useCookies) {
            try {
                session = OXServlet.findSessionByCookie(req, resp);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                resp.sendError(500, e.getMessage());
                return false;
            }
        }
        if (null == session) {
            LoginRequest loginRequest;
            try {
                loginRequest = OXServlet.parseLogin(req, face);
                if (customizer != null) {
                    loginRequest = customizer.modifyLogin(loginRequest);
                }
            }
            catch (OXException e) {
                LOG.debug("", (Throwable)e);
                OXServlet.addBasicAuthenticateHeader(resp);
                resp.sendError(401, "Authorization Required!");
                return false;
            }
            try {
                if (!useCookies) {
                    session = WebDAVSessionStore.getInstance().getSession(loginRequest);
                }
                HashMap<String, Object> properties = new HashMap<String, Object>(1);
                session = OXServlet.addSession(loginRequest, properties);
                resp.addCookie(new javax.servlet.http.Cookie(COOKIE_SESSIONID, session.getSessionID()));
            }
            catch (OXException e) {
                if (e.getCategory() == Category.CATEGORY_USER_INPUT) {
                    OXServlet.addBasicAuthenticateHeader(resp);
                    resp.sendError(401, "Authorization Required!");
                } else if (LoginExceptionCodes.AUTHENTICATION_DISABLED.equals(e)) {
                    resp.sendError(403);
                } else {
                    LOG.error("", (Throwable)e);
                    resp.sendError(500, e.getMessage());
                }
                return false;
            }
        } else {
            String address = req.getRemoteAddr();
            if (null == address || !address.equals(session.getLocalIp())) {
                LOG.info("Request to server denied for session: {}. in WebDAV XML interface. Client login IP changed from {} to {}{}", new Object[]{session.getSessionID(), session.getLocalIp(), address, Character.valueOf('.')});
                OXServlet.addBasicAuthenticateHeader(resp);
                OXServlet.removeSession(session.getSessionID());
                OXServlet.removeCookie(req, resp, COOKIE_SESSIONID);
                resp.sendError(401, "Authorization Required!");
                return false;
            }
        }
        req.setAttribute(SESSION, (Object)session);
        return true;
    }

    private static void removeCookie(HttpServletRequest req, HttpServletResponse resp, String ... cookiesToRemove) {
        Map<String, javax.servlet.http.Cookie> cookies = Cookies.cookieMapFor(req);
        if (cookies == null) {
            return;
        }
        List<String> cookieNames = Arrays.asList(cookiesToRemove);
        for (String name : cookieNames) {
            javax.servlet.http.Cookie cookie = cookies.get(name);
            if (null == cookie) continue;
            javax.servlet.http.Cookie respCookie = new javax.servlet.http.Cookie(name, cookie.getValue());
            respCookie.setPath("/");
            respCookie.setMaxAge(0);
            resp.addCookie(respCookie);
        }
    }

    private static void removeSession(String sessionID) {
        try {
            ServerServiceRegistry.getInstance().getService(SessiondService.class, true).removeSession(sessionID);
        }
        catch (OXException oXException) {
            // empty catch block
        }
    }

    private void addUnauthorizedHeader(HttpServletRequest req, HttpServletResponse resp) {
        if (this.useHttpAuth()) {
            resp.addHeader("WWW-Authenticate", "Basic realm=\"OX WebDAV\", encoding=\"UTF-8\"");
            if (this.allowOAuthAccess()) {
                OAuthResourceService oAuthResourceService = this.getOAuthResourceService();
                OAuthSessionProvider sessionProvider = this.getOAuthSessionProvider();
                if (oAuthResourceService != null && sessionProvider != null) {
                    resp.addHeader("WWW-Authenticate", "Bearer");
                }
            }
        }
    }

    private static void addBasicAuthenticateHeader(HttpServletResponse resp) {
        resp.addHeader("WWW-Authenticate", "Basic realm=\"OX WebDAV\", encoding=\"UTF-8\"");
    }

    private static LoginRequest parseLogin(HttpServletRequest req, Interface face) throws OXException {
        String auth = req.getHeader("authorization");
        if (null == auth) {
            LOG.debug("Authorization header missing.");
            throw WebdavExceptionCode.MISSING_HEADER_FIELD.create("Authorization");
        }
        if (Authorization.checkForBasicAuthorization(auth)) {
            Authorization.Credentials creds = Authorization.decode(auth);
            if (!Authorization.checkLogin(creds.getPassword())) {
                throw WebdavExceptionCode.EMPTY_PASSWORD.create();
            }
            return new LoginRequestImpl(creds.getLogin(), creds.getPassword(), face, req);
        }
        int pos = auth.indexOf(32);
        String mech = pos > 0 ? auth.substring(0, pos) : auth;
        LOG.debug("Unsupported Authentication header.");
        throw WebdavExceptionCode.UNSUPPORTED_AUTH_MECH.create(mech);
    }

    private static Session addSession(LoginRequest request, Map<String, Object> properties) throws OXException {
        return loginPerformer.doLogin(request, properties).getSession();
    }

    public static Session findSessionByCookie(HttpServletRequest req, HttpServletResponse resp) throws OXException {
        javax.servlet.http.Cookie cookie;
        Map<String, javax.servlet.http.Cookie> cookies = Cookies.cookieMapFor(req);
        String sessionId = null;
        if (null != cookies && null != (cookie = cookies.get(COOKIE_SESSIONID))) {
            sessionId = cookie.getValue();
        }
        if (null == sessionId) {
            return null;
        }
        Session session = ServerServiceRegistry.getInstance().getService(SessiondService.class, true).getSession(sessionId);
        if (null == session && resp != null) {
            javax.servlet.http.Cookie cookie2 = new javax.servlet.http.Cookie(COOKIE_SESSIONID, sessionId);
            cookie2.setMaxAge(0);
            resp.addCookie(cookie2);
        }
        return session;
    }

    public static Session getSession(HttpServletRequest req) {
        Session session = (Session)req.getAttribute(SESSION);
        if (null == session) {
            LOG.error("Somebody gets a null session.");
        }
        return session;
    }

    protected Document getJDOMDocument(HttpServletRequest req) throws JDOMException, IOException {
        Document doc = null;
        if (req.getContentLength() > 0) {
            doc = ServerServiceRegistry.getInstance().getService(JDOMParser.class).parse((InputStream)req.getInputStream());
        }
        return doc;
    }

    protected static boolean isTransient(Interface iface) {
        switch (iface) {
            case CALDAV: 
            case CARDDAV: 
            case WEBDAV_INFOSTORE: 
            case WEBDAV_ICAL: 
            case WEBDAV_VCARD: 
            case OUTLOOK_UPDATER: 
            case DRIVE_UPDATER: {
                return true;
            }
        }
        return false;
    }

    private static final class LoginRequestImpl
    implements LoginRequest {
        private final String login;
        private final HttpServletRequest req;
        private final String userAgent;
        private final String pass;
        private final String client;
        private final Interface interfaze;
        private final String version;

        public LoginRequestImpl(String login, String pass, Interface interfaze, HttpServletRequest req) {
            this.client = AJAXUtility.sanitizeParam(req.getParameter("client"));
            this.version = AJAXUtility.sanitizeParam(req.getParameter("version"));
            this.userAgent = AJAXUtility.sanitizeParam(req.getParameter("agent"));
            this.login = login;
            this.req = req;
            this.pass = pass;
            this.interfaze = interfaze;
        }

        @Override
        public String getUserAgent() {
            return null == this.userAgent ? this.req.getHeader("user-agent") : this.userAgent;
        }

        @Override
        public String getPassword() {
            return this.pass;
        }

        @Override
        public String getLogin() {
            return this.login;
        }

        @Override
        public Interface getInterface() {
            return this.interfaze;
        }

        @Override
        public String getClientIP() {
            return this.req.getRemoteAddr();
        }

        @Override
        public String getAuthId() {
            return UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        }

        @Override
        public String getClient() {
            return this.client;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getHash() {
            return null;
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return Tools.copyHeaders(this.req);
        }

        @Override
        public Cookie[] getCookies() {
            return Tools.getCookieFromHeader(this.req);
        }

        @Override
        public boolean isSecure() {
            return Tools.considerSecure(this.req);
        }

        @Override
        public String getServerName() {
            return this.req.getServerName();
        }

        @Override
        public int getServerPort() {
            return this.req.getServerPort();
        }

        @Override
        public String getHttpSessionID() {
            HttpSession session = this.req.getSession(false);
            return null != session ? session.getId() : null;
        }

        @Override
        public String getClientToken() {
            return null;
        }

        @Override
        public boolean isTransient() {
            return OXServlet.isTransient(this.interfaze);
        }

        @Override
        public String getLanguage() {
            return LoginTools.parseLanguage(this.req);
        }

        @Override
        public boolean isStoreLanguage() {
            return LoginTools.parseStoreLanguage(this.req);
        }
    }
}

