/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.encoding;

import com.openexchange.tools.encoding.URLCoder;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Pattern;
import javax.mail.internet.MimeUtility;

public class Helper {
    private static final Pattern PAT_BSLASH = Pattern.compile("\\\\");
    private static final Pattern PAT_QUOTE = Pattern.compile("\"");

    private Helper() {
    }

    public static String escape(String value) {
        return PAT_QUOTE.matcher(PAT_BSLASH.matcher(value).replaceAll("\\\\\\\\")).replaceAll("\\\\\\\"");
    }

    public static String encodeFilename(String orig, String encoding, boolean internetExplorer) throws UnsupportedEncodingException {
        if (orig == null) {
            return null;
        }
        String encoded = orig;
        if (!Helper.isASCII(orig)) {
            if (internetExplorer) {
                try {
                    Charset charset = Charset.forName(encoding);
                    encoded = URLCoder.encode(orig, charset);
                }
                catch (UnsupportedCharsetException uce) {
                    throw new UnsupportedEncodingException(uce.getMessage());
                }
            } else {
                encoded = MimeUtility.encodeText((String)orig, (String)encoding, (String)"B");
            }
        }
        return encoded;
    }

    public static String encodeFilenameForIE(String orig, Charset charset) {
        String retval = Helper.isASCII(orig) ? orig : URLCoder.encode(orig, charset);
        return retval;
    }

    public static String encodeFilename(String orig, String charset) throws UnsupportedEncodingException {
        String retval = Helper.isASCII(orig) ? orig : MimeUtility.encodeText((String)orig, (String)charset, (String)"B");
        return retval;
    }

    private static boolean isASCII(String fileName) {
        boolean retval;
        char c;
        int length;
        int i = length = fileName.length();
        for (retval = true; retval && --i >= 0; retval &= c != '\'') {
            c = fileName.charAt(i);
            retval &= c < '\u007f';
            retval &= c > '!';
            retval &= c != '*';
            retval &= c != '%';
        }
        return retval;
    }
}

