/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi;

import com.openexchange.groupware.update.tools.UpdateTaskMBeanInit;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.management.ManagementService;
import com.openexchange.monitoring.MonitorUtility;
import com.openexchange.osgi.BundleServiceTracker;
import com.openexchange.report.internal.ReportingInit;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.tools.servlet.ratelimit.monitoring.RateLimiterMBeanImpl;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.slf4j.LoggerFactory;

public final class ManagementServiceTracker
extends BundleServiceTracker<ManagementService> {
    private volatile ObjectName gadObjectName;
    private volatile ObjectName rateLimiterObjectName;

    public ManagementServiceTracker(BundleContext context) {
        super(context, ManagementService.class);
    }

    protected void addingServiceInternal(ManagementService managementService) {
        ServerServiceRegistry.getInstance().addService(ManagementService.class, managementService);
        try {
            this.gadObjectName = OXFolderProperties.registerRestorerMBean(managementService);
            managementService.registerMBean(MonitorUtility.getObjectName((String)MailServletInterface.mailInterfaceMonitor.getClass().getName(), (boolean)true), (Object)MailServletInterface.mailInterfaceMonitor);
            ObjectName rateLimiterObjectName = MonitorUtility.getObjectName((String)"RateLimiterMonitor", (boolean)true);
            managementService.registerMBean(rateLimiterObjectName, (Object)new RateLimiterMBeanImpl());
            this.rateLimiterObjectName = rateLimiterObjectName;
        }
        catch (MalformedObjectNameException e) {
            LoggerFactory.getLogger(ManagementServiceTracker.class).error("", (Throwable)e);
        }
        catch (NullPointerException e) {
            LoggerFactory.getLogger(ManagementServiceTracker.class).error("", (Throwable)e);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ManagementServiceTracker.class).error("", (Throwable)e);
        }
        new ReportingInit(managementService).start();
        new UpdateTaskMBeanInit(managementService).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removedServiceInternal(ManagementService managementService) {
        new UpdateTaskMBeanInit(managementService).stop();
        new ReportingInit(managementService).stop();
        try {
            ObjectName rateLimiterObjectName;
            managementService.unregisterMBean(MonitorUtility.getObjectName((String)MailServletInterface.mailInterfaceMonitor.getClass().getName(), (boolean)true));
            ObjectName gadObjectName = this.gadObjectName;
            if (null != gadObjectName) {
                OXFolderProperties.unregisterRestorerMBean(gadObjectName, managementService);
            }
            if (null != (rateLimiterObjectName = this.rateLimiterObjectName)) {
                managementService.unregisterMBean(rateLimiterObjectName);
            }
        }
        catch (MalformedObjectNameException e) {
            LoggerFactory.getLogger(ManagementServiceTracker.class).error("", (Throwable)e);
        }
        catch (NullPointerException e) {
            LoggerFactory.getLogger(ManagementServiceTracker.class).error("", (Throwable)e);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ManagementServiceTracker.class).error("", (Throwable)e);
        }
        finally {
            this.gadObjectName = null;
            this.rateLimiterObjectName = null;
        }
    }
}

