/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.report.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.Autoboxing;
import com.openexchange.report.internal.ReportContext;
import com.openexchange.report.internal.Tools;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.RuntimeOperationsException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportingMBean
implements DynamicMBean {
    private static final String COM_OPENEXCHANGE_MAIL_ADMIN_MAIL_LOGIN_ENABLED = "com.openexchange.mail.adminMailLoginEnabled";
    private static final Logger LOG = LoggerFactory.getLogger(ReportingMBean.class);
    private final String[] totalNames = new String[]{"contexts", "users", "guests", "links"};
    private CompositeType totalRow;
    private TabularType totalType;
    private final String[] macsNames = new String[]{"mac", "count", "nradmin", "nrdisabled"};
    private CompositeType macsRow;
    private TabularType macsType;
    private final String[] configurationNames = new String[]{"key", "value"};
    private CompositeType configurationRow;
    private TabularType configurationType;
    private final String[] moduleAccessCombinationNames = new String[]{"module access combination", "users", "inactive"};
    private final String[] detailNames = new String[]{"identifier", "admin permission", "users", "age", "created", "module access combinations"};
    private CompositeType detailRow;
    private TabularType moduleAccessCombinationsType;
    private TabularType detailType;
    private final MBeanInfo mbeanInfo = this.buildMBeanInfo();
    private CompositeType moduleAccessPermission;

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException {
        ConfigurationService configurationService;
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot call getAttributeInfo with null attribute name");
        }
        try {
            configurationService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class, true);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        if ("Total".equals(attribute)) {
            return this.generateTotalTabular();
        }
        if ("Macs".equals(attribute)) {
            return this.generateMacsTabular();
        }
        if ("Detail".equals(attribute)) {
            return this.generateDetailTabular();
        }
        if ("Configuration".equals(attribute)) {
            return this.generateConfigurationTabular(configurationService);
        }
        throw new AttributeNotFoundException("Cannot find " + attribute + " attribute ");
    }

    private TabularData generateConfigurationTabular(ConfigurationService configurationService) throws MBeanException {
        TabularDataSupport configuration = new TabularDataSupport(this.configurationType);
        try {
            boolean adminMailLoginEnabled = configurationService.getBoolProperty(COM_OPENEXCHANGE_MAIL_ADMIN_MAIL_LOGIN_ENABLED, false);
            CompositeDataSupport value = new CompositeDataSupport(this.configurationRow, this.configurationNames, new Object[]{COM_OPENEXCHANGE_MAIL_ADMIN_MAIL_LOGIN_ENABLED, Autoboxing.B((boolean)adminMailLoginEnabled)});
            configuration.put(value);
        }
        catch (OpenDataException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe);
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe);
        }
        catch (Throwable t) {
            LOG.error("", t);
            Exception wrapMe = new Exception(t.getMessage());
            throw new MBeanException(wrapMe);
        }
        return configuration;
    }

    private final Map<Integer, ReportContext> loadContextData() throws MBeanException {
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        try {
            Map<String, Integer> schemaMap = Tools.getAllSchemata(LOG);
            HashMap<Integer, ReportContext> allctx = new HashMap<Integer, ReportContext>();
            for (String schema : schemaMap.keySet()) {
                Connection connection;
                int readPool = schemaMap.get(schema);
                try {
                    connection = dbService.get(readPool, schema);
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                    throw new MBeanException((Exception)((Object)e), "Couldn't get connection to schema " + schema + " in pool " + readPool + ".");
                }
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    ReportContext rc;
                    stmt = connection.prepareStatement("SELECT c.cid,c.creating_date,a.user,u.permissions FROM prg_contacts c JOIN user_setting_admin a ON c.cid=a.cid AND c.userid=a.user JOIN user_configuration u ON c.cid=u.cid AND u.user=a.user");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        rc = new ReportContext();
                        rc.setId(Autoboxing.I((int)rs.getInt(1)));
                        rc.setAge(Autoboxing.L((long)((System.currentTimeMillis() - rs.getLong(2)) / 86400000L)));
                        rc.setCreated(new Date(rs.getLong(2)));
                        rc.setAdminId(Autoboxing.I((int)rs.getInt(3)));
                        rc.setAdminPermission(Autoboxing.I((int)rs.getInt(4)));
                        allctx.put(Autoboxing.I((int)rc.getId()), rc);
                    }
                    rs.close();
                    stmt.close();
                    stmt = connection.prepareStatement("SELECT c.cid,COUNT(c.permissions),c.permissions,COUNT(IF(u.mailEnabled=0,1,null)) FROM user_configuration AS c JOIN user AS u ON u.cid=c.cid AND u.id=c.user WHERE u.guestCreatedBy=0 GROUP BY permissions,cid ORDER BY cid;");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        rc = (ReportContext)allctx.get(Autoboxing.I((int)rs.getInt(1)));
                        int numusr = rs.getInt(2);
                        int perm = rs.getInt(3);
                        int inaccnt = rs.getInt(4);
                        if (null == rc) continue;
                        Map<Integer, Integer> accCombs = rc.getAccessCombinations();
                        Map<Integer, Integer> inactive = rc.getInactiveByCombination();
                        if (null == accCombs) {
                            accCombs = new HashMap<Integer, Integer>();
                        }
                        if (null == inactive) {
                            inactive = new HashMap<Integer, Integer>();
                        }
                        accCombs.put(Autoboxing.I((int)perm), Autoboxing.I((int)numusr));
                        inactive.put(Autoboxing.I((int)perm), Autoboxing.I((int)inaccnt));
                        Integer nusr = rc.getNumUsers();
                        if (null != nusr) {
                            rc.setNumUsers(Autoboxing.I((int)(nusr + numusr)));
                        } else {
                            rc.setNumUsers(Autoboxing.I((int)numusr));
                        }
                        rc.setInactiveByCombination(inactive);
                        rc.setAccessCombinations(accCombs);
                    }
                }
                catch (SQLException e) {
                    try {
                        LOG.error("", (Throwable)e);
                        throw new MBeanException(e, e.getMessage());
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeSQLStuff(rs, stmt);
                        dbService.back(readPool, connection);
                        throw throwable;
                    }
                }
                DBUtils.closeSQLStuff(rs, stmt);
                dbService.back(readPool, connection);
            }
            return allctx;
        }
        catch (MBeanException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
    }

    private TabularDataSupport generateTotalTabular() throws MBeanException {
        TabularDataSupport total = new TabularDataSupport(this.totalType);
        try {
            int nrctx = 0;
            int nruser = 0;
            int nrguests = 0;
            int nrlinks = 0;
            int userCount = 0;
            int guestCount = 0;
            int linkCount = 0;
            List<Integer> allContextIds = Tools.getAllContextIds();
            for (Integer contextId : allContextIds) {
                User[] users;
                for (User user : users = Tools.getUser(contextId)) {
                    if (!user.isGuest()) {
                        ++userCount;
                        continue;
                    }
                    if (user.getMail().isEmpty()) {
                        ++linkCount;
                        continue;
                    }
                    ++guestCount;
                }
            }
            nrctx = allContextIds.size();
            nruser = userCount;
            nrguests = guestCount;
            nrlinks = linkCount;
            CompositeDataSupport value = new CompositeDataSupport(this.totalRow, this.totalNames, new Object[]{Autoboxing.I((int)nrctx), Autoboxing.I((int)nruser), Autoboxing.I((int)nrguests), Autoboxing.I((int)nrlinks)});
            total.put(value);
            return total;
        }
        catch (OpenDataException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
    }

    private TabularDataSupport generateMacsTabular() throws MBeanException {
        TabularDataSupport total = new TabularDataSupport(this.macsType);
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        try {
            Map<String, Integer> schemaMap = Tools.getAllSchemata(LOG);
            HashMap<Integer, Integer> macMap = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> admMap = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> disabledMap = new HashMap<Integer, Integer>();
            for (String schema : schemaMap.keySet()) {
                Connection connection;
                int readPool = schemaMap.get(schema);
                try {
                    connection = dbService.get(readPool, schema);
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                    throw new MBeanException((Exception)((Object)e), "Couldn't get connection to schema " + schema + " in pool " + readPool + ".");
                }
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = connection.prepareStatement("SELECT c.permissions,COUNT(c.permissions) AS count,COUNT(IF(c.user=2,1,null)) AS nradm,COUNT(IF(u.mailEnabled=0,1,null)) AS nrdisabled FROM user_configuration AS c JOIN user AS u ON u.cid=c.cid AND u.id=c.user WHERE u.guestCreatedBy=0 GROUP BY c.permissions");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        Integer mac = rs.getInt(1);
                        Integer count = rs.getInt(2);
                        Integer nradm = rs.getInt(3);
                        Integer nrdisabled = rs.getInt(4);
                        if (macMap.containsKey(mac)) {
                            macMap.put(mac, (Integer)macMap.get(mac) + count);
                        } else {
                            macMap.put(mac, count);
                        }
                        if (admMap.containsKey(mac)) {
                            admMap.put(mac, (Integer)admMap.get(mac) + nradm);
                        } else {
                            admMap.put(mac, nradm);
                        }
                        if (disabledMap.containsKey(mac)) {
                            disabledMap.put(mac, (Integer)disabledMap.get(mac) + nrdisabled);
                            continue;
                        }
                        disabledMap.put(mac, nrdisabled);
                    }
                    rs.close();
                    stmt.close();
                }
                catch (SQLException e) {
                    try {
                        LOG.error("", (Throwable)e);
                        throw new MBeanException(e, e.getMessage());
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeSQLStuff(rs, stmt);
                        dbService.back(readPool, connection);
                        throw throwable;
                    }
                }
                DBUtils.closeSQLStuff(rs, stmt);
                dbService.back(readPool, connection);
            }
            for (Integer key : macMap.keySet()) {
                CompositeDataSupport value = new CompositeDataSupport(this.macsRow, this.macsNames, new Object[]{key, macMap.get(key), admMap.get(key), disabledMap.get(key)});
                total.put(value);
            }
            return total;
        }
        catch (MBeanException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        catch (OpenDataException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
    }

    private TabularDataSupport generateDetailTabular() throws MBeanException {
        TabularDataSupport detail = new TabularDataSupport(this.detailType);
        try {
            Map<Integer, ReportContext> ret = this.loadContextData();
            for (ReportContext c : ret.values().toArray(new ReportContext[ret.size()])) {
                TabularDataSupport moduleAccessCombinations = new TabularDataSupport(this.moduleAccessCombinationsType);
                Map<Integer, Integer> accessCombinations = c.getAccessCombinations();
                Map<Integer, Integer> inacByCombi = c.getInactiveByCombination();
                if (null != accessCombinations) {
                    for (Map.Entry<Integer, Integer> e : accessCombinations.entrySet()) {
                        int inac = 0;
                        if (null != inacByCombi) {
                            Integer inAc = inacByCombi.get(e.getKey());
                            inac = inAc == null ? 0 : inAc;
                        }
                        moduleAccessCombinations.put(new CompositeDataSupport(this.moduleAccessPermission, this.moduleAccessCombinationNames, new Object[]{e.getKey(), e.getValue(), Autoboxing.I((int)inac)}));
                    }
                }
                CompositeDataSupport value = new CompositeDataSupport(this.detailRow, this.detailNames, new Object[]{c.getId(), c.getAdminPermission(), c.getNumUsers(), c.getAge(), c.getCreated(), moduleAccessCombinations});
                detail.put(value);
            }
        }
        catch (OpenDataException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe);
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe);
        }
        catch (Throwable t) {
            LOG.error("", t);
            Exception wrapMe = new Exception(t.getMessage());
            throw new MBeanException(wrapMe);
        }
        return detail;
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributes can not be null"), "Cannot call getAttributes with null attribute names");
        }
        AttributeList resultList = new AttributeList();
        if (attributes.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributes.length; ++i) {
            try {
                Object value = this.getAttribute(attributes[i]);
                resultList.add(new Attribute(attributes[i], value));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) {
        throw new RuntimeOperationsException(new UnsupportedOperationException("invoke is not supported"), "The method invoke is not supported.");
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException {
        throw new AttributeNotFoundException("No attribute can be set in this MBean");
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    private final MBeanInfo buildMBeanInfo() {
        try {
            String[] totalDescriptions = new String[]{"Number of contexts", "Number of users", "Number of guests", "Number of links"};
            OpenType[] totalTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER};
            this.totalRow = new CompositeType("Total row", "A total row", this.totalNames, totalDescriptions, totalTypes);
            this.totalType = new TabularType("Total", "Total view", this.totalRow, this.totalNames);
            String[] macsDescriptions = new String[]{"Access combination", "Count", "Admins", "Disabled"};
            OpenType[] macsTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER};
            this.macsRow = new CompositeType("Macs row", "A macs row", this.macsNames, macsDescriptions, macsTypes);
            this.macsType = new TabularType("Macs", "Macs view", this.macsRow, this.macsNames);
            String[] moduleAccessCombinationDescriptions = new String[]{"Integer value of the module access combination", "number of users configured with this module access combination", "inactive subset of useres configured with this module access combination"};
            OpenType[] moduleAccessCombinationTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER};
            this.moduleAccessPermission = new CompositeType("Module access permission", "A module access combination and the number of users having it", this.moduleAccessCombinationNames, moduleAccessCombinationDescriptions, moduleAccessCombinationTypes);
            this.moduleAccessCombinationsType = new TabularType("Module access permission combinations", "The different access combinations used in this context", this.moduleAccessPermission, new String[]{"module access combination"});
            String[] detailDescriptions = new String[]{"Context identifier", "Context admin permission", "Number of users", "Context age in days", "Date and time of context creation", "Module access permission combinations"};
            OpenType[] detailTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.DATE, this.moduleAccessCombinationsType};
            this.detailRow = new CompositeType("Detail row", "A detail row", this.detailNames, detailDescriptions, detailTypes);
            this.detailType = new TabularType("Detail", "Detail view", this.detailRow, new String[]{"identifier"});
            String[] configurationDescriptions = new String[]{"Property key", "Property value"};
            OpenType[] configurationTypes = new OpenType[]{SimpleType.STRING, SimpleType.BOOLEAN};
            this.configurationRow = new CompositeType("Configuration row", "A configuration row", this.configurationNames, configurationDescriptions, configurationTypes);
            this.configurationType = new TabularType("Configuration", "Configuration view", this.configurationRow, this.configurationNames);
            OpenMBeanAttributeInfoSupport totalAttribute = new OpenMBeanAttributeInfoSupport("Total", "Total contexts and users.", this.totalType, true, false, false);
            OpenMBeanAttributeInfoSupport macsAttribute = new OpenMBeanAttributeInfoSupport("Macs", "List of macs and their count.", this.macsType, true, false, false);
            OpenMBeanAttributeInfoSupport detailAttribute = new OpenMBeanAttributeInfoSupport("Detail", "Detailed report about contexts and users", this.detailType, true, false, false);
            OpenMBeanAttributeInfoSupport configurationAttribute = new OpenMBeanAttributeInfoSupport("Configuration", "Configuration report", this.detailType, true, false, false);
            return new OpenMBeanInfoSupport(this.getClass().getName(), "Context, user and server reporting.", new OpenMBeanAttributeInfo[]{totalAttribute, macsAttribute, detailAttribute, configurationAttribute}, null, null, null);
        }
        catch (OpenDataException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }
}

