/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.utils;

import com.openexchange.ajax.AJAXUtility;
import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Charsets;
import com.openexchange.java.ExceptionAwarePipedInputStream;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.config.MailReloadable;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.HeaderName;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.mime.PlainTextAddress;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.DataHandlerWrapper;
import com.openexchange.mail.mime.converters.FileBackedMimeBodyPart;
import com.openexchange.mail.mime.converters.FileBackedMimeMessage;
import com.openexchange.mail.mime.dataobjects.MimeMailMessage;
import com.openexchange.mail.mime.dataobjects.MimeMailPart;
import com.openexchange.mail.mime.datasource.FileDataSource;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.mime.utils.ImageMatcher;
import com.openexchange.mail.utils.CP932EmojiMapping;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.behavior.AbortBehavior;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.sun.mail.imap.protocol.BODYSTRUCTURE;
import com.sun.mail.util.MessageRemovedIOException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.apache.james.mime4j.io.LineReaderInputStreamAdaptor;
import org.apache.james.mime4j.stream.DefaultFieldBuilder;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MimeMessageUtility {
    static final Logger LOG = LoggerFactory.getLogger(MimeMessageUtility.class);
    private static final Set<HeaderName> ENCODINGS;
    private static final MailDateFormat MAIL_DATE_FORMAT;
    private static final ConcurrentMap<String, Future<MailDateFormat>> MDF_MAP;
    private static final Pattern PATTERN_EMBD_IMG;
    private static final Pattern PATTERN_EMBD_IMG_ALT;
    private static final Pattern PATTERN_CODE_POINT;
    public static final Pattern PATTERN_SRC;
    private static final String IMAGE_ALIAS_APPENDIX = "image";
    private static final String FILE_ALIAS_APPENDIX = "file";
    private static final String PARAM_NAME = "name";
    private static final String MULTI_SUBTYPE_ALTERNATIVE = "ALTERNATIVE";
    private static final String MULTI_SUBTYPE_RELATED = "RELATED";
    private static final Pattern ENC_PATTERN;
    private static final Pattern SPLITS;
    private static volatile Boolean checkReplaceWithComma;
    private static final Pattern PATTERN_REPLACE;
    private static final String RFC822 = "()<>@,;:\\\".[]";
    private static final Pattern P_REPL1;
    private static final Pattern P_REPL2;
    private static final int USED_CT = 14;
    private static final int USED_CD = 21;
    private static final Pattern PATTERN_UNFOLD;
    private static final Pattern PAT_ENC_WORDS;
    private static final int BUFSIZE = 8192;
    private static final String X_ORIGINAL_HEADERS = "x-original-headers";
    private static final String HDR_CONTENT_TYPE;
    private static final String PRIMARY_TEXT = "text/";
    public static final InternetAddress POISON_ADDRESS;

    private MimeMessageUtility() {
    }

    public static boolean shouldRetry(OXException e) {
        if (null == e) {
            return false;
        }
        if (MailExceptionCode.MAIL_NOT_FOUND.equals(e) || MimeMailExceptionCode.FOLDER_CLOSED.equals(e)) {
            return true;
        }
        if (MailExceptionCode.IO_ERROR.equals(e)) {
            Throwable cause = e.getCause();
            return cause instanceof IOException && "no content".equals(Strings.asciiLowerCase((String)cause.getMessage()));
        }
        if (MimeMailExceptionCode.MESSAGING_ERROR.equals(e)) {
            Throwable cause = e.getCause();
            return cause instanceof MessagingException && "failed to fetch headers".equals(Strings.asciiLowerCase((String)cause.getMessage()));
        }
        return false;
    }

    public static MailDateFormat getDefaultMailDateFormat() {
        return MAIL_DATE_FORMAT;
    }

    public static MailDateFormat getMailDateFormat(Session session) throws OXException {
        User user = session instanceof ServerSession ? ((ServerSession)session).getUser() : UserStorage.getInstance().getUser(session.getUserId(), session.getContextId());
        return MimeMessageUtility.getMailDateFormat(user.getTimeZone());
    }

    public static MailDateFormat getMailDateFormat(final String timeZoneId) throws OXException {
        FutureTask<MailDateFormat> ft;
        FutureTask<MailDateFormat> future = (FutureTask<MailDateFormat>)MDF_MAP.get(timeZoneId);
        if (null == future && null == (future = (Future)MDF_MAP.putIfAbsent(timeZoneId, ft = new FutureTask<MailDateFormat>(new Callable<MailDateFormat>(){

            @Override
            public MailDateFormat call() throws Exception {
                MailDateFormat mdf = new MailDateFormat();
                mdf.setTimeZone(TimeZoneUtils.getTimeZone(timeZoneId));
                return mdf;
            }
        })))) {
            future = ft;
            ft.run();
        }
        try {
            return (MailDateFormat)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw MailExceptionCode.UNEXPECTED_ERROR.create(cause, cause.getMessage());
        }
    }

    public static boolean isEmptyHeader(String[] headers) {
        if (null == headers || 0 == headers.length) {
            return true;
        }
        boolean isEmpty = true;
        for (int i = 0; isEmpty && i < headers.length; ++i) {
            isEmpty = MimeMessageUtility.isEmpty(headers[i]);
        }
        return isEmpty;
    }

    private static boolean isEmpty(String string) {
        return Strings.isEmpty((String)string);
    }

    public static boolean hasEmbeddedImages(CharSequence htmlContent) {
        return PATTERN_EMBD_IMG.matcher(htmlContent).find() || PATTERN_EMBD_IMG_ALT.matcher(htmlContent).find();
    }

    public static List<String> getContentIDs(CharSequence htmlContent) {
        LinkedList<String> retval = new LinkedList<String>();
        Matcher m = PATTERN_EMBD_IMG.matcher(htmlContent);
        while (m.find()) {
            retval.add(m.group(2));
        }
        m = PATTERN_EMBD_IMG_ALT.matcher(htmlContent);
        while (m.find()) {
            retval.add(m.group(2));
        }
        return retval;
    }

    public static boolean containsContentId(String contentId, Collection<String> contentIds) {
        boolean contains = false;
        Iterator<String> iterator = contentIds.iterator();
        while (!contains && iterator.hasNext()) {
            contains = MimeMessageUtility.equalsCID(contentId, iterator.next());
        }
        return contains;
    }

    public static String getPlainContentId(String contentId) {
        int mlen;
        if (null == contentId || 0 >= contentId.length()) {
            return contentId;
        }
        String ret = contentId;
        if ('<' == ret.charAt(0)) {
            ret = ret.substring(1);
        }
        if ((mlen = ret.length() - 1) > 0 && '>' == ret.charAt(mlen)) {
            ret = ret.substring(0, mlen);
        }
        return ret;
    }

    public static boolean equalsCID(String contentId1, String contentId2) {
        return MimeMessageUtility.equalsCID(contentId1, contentId2, null);
    }

    public static boolean equalsCID(String contentId1, String contentId2, String ignorableSuffix) {
        String cid1 = MimeMessageUtility.trimContentId(contentId1, ignorableSuffix);
        String cid2 = MimeMessageUtility.trimContentId(contentId2, ignorableSuffix);
        return !(null == cid1 ? null != cid2 : null == cid2 || !cid1.equalsIgnoreCase(cid2));
    }

    public static String trimContentId(String contentId) {
        return MimeMessageUtility.trimContentId(contentId, null);
    }

    private static String trimContentId(String contentId, String ignorableSuffix) {
        if (null == contentId) {
            return null;
        }
        String ret = contentId.trim();
        if (ret.startsWith("<") && (ret = ret.substring(1)).endsWith(">")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        if (null != ignorableSuffix && ret.endsWith(ignorableSuffix)) {
            ret = ret.substring(0, ret.lastIndexOf(ignorableSuffix));
        }
        return ret;
    }

    public static String urlDecode(String s) {
        try {
            return AJAXUtility.decodeUrl(MimeMessageUtility.replaceURLCodePoints(s), "ISO-8859-1");
        }
        catch (RuntimeException e) {
            return s;
        }
    }

    private static String replaceURLCodePoints(String s) {
        Matcher m = PATTERN_CODE_POINT.matcher(s);
        StringBuffer buffer = new StringBuffer(s.length());
        while (m.find()) {
            char[] chars = Character.toChars(Integer.parseInt(m.group(1), 16));
            m.appendReplacement(buffer, Strings.quoteReplacement((String)new String(chars)));
        }
        m.appendTail(buffer);
        return buffer.toString();
    }

    public static String blankSrc(String imageTag) {
        if (MimeMessageUtility.isEmpty(imageTag)) {
            return imageTag;
        }
        Matcher srcMatcher = PATTERN_SRC.matcher(imageTag);
        if (!srcMatcher.find()) {
            return imageTag;
        }
        StringBuffer sb = new StringBuffer(imageTag.length());
        int st = srcMatcher.start(1);
        int end = srcMatcher.end(1);
        srcMatcher.appendReplacement(sb, Matcher.quoteReplacement(imageTag.substring(0, st) + imageTag.substring(end)));
        srcMatcher.appendTail(sb);
        return sb.toString();
    }

    public static boolean isValidImageUri(String imageTag) {
        if (MimeMessageUtility.isEmpty(imageTag)) {
            return false;
        }
        String tmp = Strings.asciiLowerCase((String)imageTag);
        String srcStart = "src=\"";
        int pos = tmp.indexOf("src=\"");
        int fromIndex = pos + "src=\"".length();
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        return tmp.indexOf("/image", fromIndex) >= 0 || tmp.indexOf("/file", fromIndex) >= 0;
    }

    public static boolean hasReferencedLocalImages(CharSequence htmlContent) {
        ImageMatcher m = ImageMatcher.matcher(htmlContent);
        if (m.find()) {
            ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            do {
                String mid;
                if (null == (mid = m.getManagedFileId())) continue;
                mfm.contains(mid);
            } while (m.find());
            return true;
        }
        return false;
    }

    public static String getRealFilename(MailPart part) {
        if (part.getFileName() != null) {
            return part.getFileName();
        }
        String hdr = part.getFirstHeader(MessageHeaders.HDR_CONTENT_DISPOSITION);
        if (hdr == null) {
            return MimeMessageUtility.getContentTypeFilename(part);
        }
        try {
            String retval = new ContentDisposition(hdr).getFilenameParameter();
            if (retval == null) {
                return MimeMessageUtility.getContentTypeFilename(part);
            }
            return retval;
        }
        catch (OXException e) {
            return MimeMessageUtility.getContentTypeFilename(part);
        }
    }

    private static String getContentTypeFilename(MailPart part) {
        if (part.containsContentType()) {
            return part.getContentType().getParameter(PARAM_NAME);
        }
        String hdr = part.getFirstHeader(MessageHeaders.HDR_CONTENT_TYPE);
        if (hdr == null || hdr.length() == 0) {
            return null;
        }
        try {
            return new ContentType(hdr).getParameter(PARAM_NAME);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    public static boolean hasAttachments(MailPart mp, String subtype) throws MessagingException, OXException, IOException {
        if (null == mp) {
            return false;
        }
        if (MULTI_SUBTYPE_ALTERNATIVE.equalsIgnoreCase(subtype)) {
            int count = mp.getEnclosedCount();
            if (count > 2) {
                return true;
            }
            return MimeMessageUtility.hasAttachments0(mp, count);
        }
        if (MULTI_SUBTYPE_RELATED.equalsIgnoreCase(subtype)) {
            return MimeMessageUtility.hasAttachments0(mp, mp.getEnclosedCount());
        }
        int count = mp.getEnclosedCount();
        if (count > 1) {
            return true;
        }
        return MimeMessageUtility.hasAttachments0(mp, count);
    }

    private static boolean hasAttachments0(MailPart mp, int count) throws MessagingException, OXException, IOException {
        boolean found = false;
        ContentType ct = new ContentType();
        int i = count;
        while (!found && i-- > 0) {
            MailPart part = mp.getEnclosedMailPart(i);
            String[] tmp = part.getHeader(MessageHeaders.HDR_CONTENT_TYPE);
            if (tmp == null || tmp.length <= 0) continue;
            ct.setContentType(MimeMessageUtility.unfold(tmp[0]));
            if (!ct.startsWith("multipart/")) continue;
            found |= MimeMessageUtility.hasAttachments(part, ct.getSubType());
        }
        return found;
    }

    public static boolean hasAttachments(Multipart mp, String subtype) throws MessagingException, OXException, IOException {
        if (null == mp) {
            return false;
        }
        if (MULTI_SUBTYPE_ALTERNATIVE.equalsIgnoreCase(subtype)) {
            int count = mp.getCount();
            if (count > 2) {
                return true;
            }
            return MimeMessageUtility.hasAttachments0(mp, count);
        }
        if (MULTI_SUBTYPE_RELATED.equalsIgnoreCase(subtype)) {
            return MimeMessageUtility.hasAttachments0(mp, mp.getCount());
        }
        int count = mp.getCount();
        if (count > 1) {
            return true;
        }
        return MimeMessageUtility.hasAttachments0(mp, count);
    }

    private static boolean hasAttachments0(Multipart mp, int count) throws MessagingException, OXException, IOException {
        boolean found = false;
        ContentType ct = new ContentType();
        int i = count;
        while (!found && i-- > 0) {
            BodyPart part = mp.getBodyPart(i);
            String[] tmp = part.getHeader(MessageHeaders.HDR_CONTENT_TYPE);
            if (tmp == null || tmp.length <= 0) continue;
            ct.setContentType(MimeMessageUtility.unfold(tmp[0]));
            if (!ct.isMimeType("multipart/*")) continue;
            found |= MimeMessageUtility.hasAttachments((Multipart)part.getContent(), ct.getSubType());
        }
        return found;
    }

    public static boolean hasAttachments(BODYSTRUCTURE bodystructure) {
        if (bodystructure.isMulti()) {
            if (MULTI_SUBTYPE_ALTERNATIVE.equalsIgnoreCase(bodystructure.subtype)) {
                if (bodystructure.bodies.length > 2) {
                    return true;
                }
                return MimeMessageUtility.hasAttachments0(bodystructure);
            }
            if (MULTI_SUBTYPE_RELATED.equalsIgnoreCase(bodystructure.subtype)) {
                return MimeMessageUtility.hasAttachments0(bodystructure);
            }
            if (bodystructure.bodies.length > 1) {
                return true;
            }
            return MimeMessageUtility.hasAttachments0(bodystructure);
        }
        return false;
    }

    private static boolean hasAttachments0(BODYSTRUCTURE bodystructure) {
        boolean found;
        BODYSTRUCTURE[] bodies = bodystructure.bodies;
        if (null != bodies) {
            int i = bodies.length;
            for (found = false; !found && i-- > 0; found |= MimeMessageUtility.hasAttachments(bodies[i])) {
            }
        }
        return found;
    }

    public static String decodeEnvelopeSubject(String subject) {
        if (null == subject) {
            return "";
        }
        String s = MimeMessageUtility.checkNonAscii(subject);
        int length = s.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if ('\t' == c || ' ' == c) {
                while (i + 1 < length && ' ' == s.charAt(i + 1)) {
                    ++i;
                }
                sb.append(' ');
                continue;
            }
            if ('\r' == c || '\n' == c) continue;
            sb.append(c);
        }
        return MimeMessageUtility.decodeEnvelopeHeader0(sb.toString());
    }

    public static String decodeEnvelopeHeader(String value) {
        return MimeMessageUtility.decodeEnvelopeHeader0(MimeMessageUtility.checkNonAscii(value));
    }

    private static String decodeEnvelopeHeader0(String value) {
        int length = value.length();
        if (value.indexOf(13) < 0 && value.indexOf(10) < 0) {
            return MimeMessageUtility.decodeMultiEncodedHeader0(MimeMessageUtility.removeWhitespacesBetweenEncodedWords(value), false);
        }
        return MimeMessageUtility.decodeMultiEncodedHeader0(value, true);
    }

    private static String removeWhitespacesBetweenEncodedWords(String value) {
        int i;
        StringBuilder sb = new StringBuilder(value);
        String pattern = "?= =?";
        while ((i = sb.indexOf(pattern)) >= 0) {
            sb.deleteCharAt(i + 2);
        }
        return sb.toString();
    }

    public static String decodeMultiEncodedHeader(String headerValue) {
        if (null == headerValue || headerValue.indexOf("=?") < 0) {
            return MimeMessageUtility.unfold(headerValue);
        }
        return MimeMessageUtility.decodeMultiEncodedHeader0(MimeMessageUtility.checkNonAscii(headerValue), true);
    }

    private static String decodeMultiEncodedHeader0(String headerValue, boolean unfold) {
        String hdrVal;
        if (headerValue == null) {
            return null;
        }
        String string = hdrVal = unfold ? MimeMessageUtility.unfold(headerValue) : headerValue;
        if (hdrVal.indexOf("=?") < 0) {
            return hdrVal;
        }
        Matcher m = ENC_PATTERN.matcher(hdrVal);
        if (m.find()) {
            StringBuilder sb = new StringBuilder(hdrVal.length());
            int lastMatch = 0;
            do {
                try {
                    String decodeWord;
                    String encodedWord;
                    sb.append(hdrVal.substring(lastMatch, m.start()));
                    String charset = m.group(1);
                    if (MessageUtility.isBig5(charset)) {
                        encodedWord = m.group();
                        decodeWord = MimeUtility.decodeWord((String)encodedWord);
                        if (decodeWord.indexOf(65533) >= 0) {
                            decodeWord = MimeUtility.decodeWord((String)encodedWord.replaceFirst(Pattern.quote(charset), "Big5-HKSCS"));
                        }
                        sb.append(decodeWord);
                    } else if (MessageUtility.isGB2312(charset)) {
                        encodedWord = m.group();
                        decodeWord = MimeUtility.decodeWord((String)encodedWord);
                        if (decodeWord.indexOf(65533) >= 0) {
                            decodeWord = MimeUtility.decodeWord((String)encodedWord.replaceFirst(Pattern.quote(charset), "GB18030"));
                        }
                        sb.append(decodeWord);
                    } else if (MessageUtility.isShiftJis(charset)) {
                        encodedWord = m.group();
                        if ("cp932".equalsIgnoreCase(charset)) {
                            encodedWord = new StringBuilder(encodedWord.length()).append("=?MS932?").append(m.group(2)).append('?').append(m.group(3)).append("?=").toString();
                        }
                        if ((decodeWord = MimeUtility.decodeWord((String)encodedWord)).indexOf(65533) >= 0) {
                            decodeWord = CP932EmojiMapping.getInstance().replaceIn(MimeUtility.decodeWord((String)encodedWord.replaceFirst(Pattern.quote(charset), "MS932")));
                        }
                        sb.append(decodeWord);
                    } else {
                        sb.append(MimeUtility.decodeWord((String)m.group()));
                    }
                    lastMatch = m.end();
                }
                catch (UnsupportedEncodingException e) {
                    LOG.debug("Unsupported character-encoding in encoded-word: {}", (Object)m.group(), (Object)e);
                    sb.append(MimeMessageUtility.handleUnsupportedEncoding(m));
                    lastMatch = m.end();
                }
                catch (ParseException e) {
                    return MimeMessageUtility.decodeMultiEncodedHeaderSafe(headerValue);
                }
            } while (m.find());
            sb.append(hdrVal.substring(lastMatch));
            return sb.toString();
        }
        if (!hdrVal.startsWith("=?")) {
            return hdrVal;
        }
        int start = 2;
        int pos = hdrVal.indexOf(63, start);
        if (pos == -1) {
            return hdrVal;
        }
        start = pos + 1;
        if ((pos = hdrVal.indexOf(63, start)) == -1) {
            return hdrVal;
        }
        start = pos + 1;
        if ((pos = hdrVal.indexOf("?=", start)) == -1) {
            return hdrVal.substring(start);
        }
        return hdrVal;
    }

    private static String handleUnsupportedEncoding(Matcher m) {
        byte[] rawBytes;
        String asciiText = m.group(3);
        String transferEncoding = m.group(2);
        if ("Q".equalsIgnoreCase(transferEncoding)) {
            try {
                rawBytes = QuotedPrintableCodec.decodeQuotedPrintable((byte[])Charsets.toAsciiBytes((String)asciiText));
            }
            catch (DecoderException e) {
                LOG.warn("Cannot decode quoted-printable", (Throwable)e);
                return asciiText;
            }
        } else if ("B".equalsIgnoreCase(transferEncoding)) {
            rawBytes = Base64.decodeBase64((byte[])Charsets.toAsciiBytes((String)asciiText));
        } else {
            LOG.warn("Unknown transfer-encoding: {}", (Object)transferEncoding);
            return asciiText;
        }
        String detectedCharset = CharsetDetector.detectCharset((ByteArrayInputStream)new UnsynchronizedByteArrayInputStream(rawBytes));
        try {
            return new String(rawBytes, Charsets.forName((String)detectedCharset));
        }
        catch (UnsupportedCharsetException e) {
            LOG.warn("Unknown character-encoding: {}", (Object)detectedCharset);
            return asciiText;
        }
    }

    public static String checkNonAscii(String rawHeader) {
        if (null == rawHeader || MimeMessageUtility.isAscii(rawHeader)) {
            return rawHeader;
        }
        return MimeMessageUtility.convertNonAscii(rawHeader);
    }

    private static String convertNonAscii(String rawHeader) {
        int length = rawHeader.length();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)rawHeader.charAt(i);
        }
        try {
            String detectCharset = CharsetDetector.detectCharset((ByteArrayInputStream)new UnsynchronizedByteArrayInputStream(bytes));
            return MessageUtility.readStream((InputStream)new UnsynchronizedByteArrayInputStream(bytes), detectCharset);
        }
        catch (IOException e) {
            return rawHeader;
        }
    }

    private static boolean isAscii(String s) {
        int length = s.length();
        boolean isAscci = true;
        for (int i = 0; i < length && isAscci; isAscci &= s.charAt(i) < '\u0080', ++i) {
        }
        return isAscci;
    }

    private static String decodeMultiEncodedHeaderSafe(String headerValue) {
        if (headerValue == null) {
            return null;
        }
        String hdrVal = MimeMessageUtility.unfold(headerValue);
        Matcher m = ENC_PATTERN.matcher(hdrVal);
        if (m.find()) {
            StringBuilder sb = new StringBuilder(hdrVal.length());
            StringBuilder tmp = null;
            int lastMatch = 0;
            do {
                try {
                    sb.append(hdrVal.substring(lastMatch, m.start()));
                    if ("Q".equalsIgnoreCase(m.group(2))) {
                        String charset = m.group(1);
                        String preparedEWord = MimeMessageUtility.prepareQEncodedValue(m.group(3), charset);
                        if (null == tmp) {
                            tmp = new StringBuilder(preparedEWord.length() + 16);
                        } else {
                            tmp.setLength(0);
                        }
                        tmp.append("=?").append(charset).append('?').append('Q').append('?').append(preparedEWord).append("?=");
                        sb.append(MimeUtility.decodeWord((String)tmp.toString()));
                    } else if ("B".equalsIgnoreCase(m.group(2))) {
                        try {
                            sb.append(MimeUtility.decodeWord((String)m.group()));
                        }
                        catch (ParseException e) {
                            sb.append(new String(Base64.decodeBase64((byte[])Charsets.toAsciiBytes((String)m.group(3))), Charsets.forName((String)m.group(1))));
                        }
                    } else {
                        sb.append(MimeUtility.decodeWord((String)m.group()));
                    }
                    lastMatch = m.end();
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn("Unsupported character-encoding in encoded-word: {}", (Object)m.group(), (Object)e);
                    sb.append(m.group());
                    lastMatch = m.end();
                }
                catch (ParseException e) {
                    LOG.warn("String is not an encoded-word as per RFC 2047: {}", (Object)m.group(), (Object)e);
                    sb.append(m.group());
                    lastMatch = m.end();
                }
            } while (m.find());
            sb.append(hdrVal.substring(lastMatch));
            return sb.toString();
        }
        return hdrVal;
    }

    private static String prepareQEncodedValue(String eword, String charset) {
        int len = eword.length();
        int pos = eword.indexOf(61);
        if (pos == -1) {
            return eword;
        }
        StringBuilder sb = new StringBuilder(len);
        int prev = 0;
        do {
            int pos1 = pos + 1;
            int pos2 = pos + 2;
            if (pos2 < len) {
                int nextPos;
                char c1 = eword.charAt(pos1);
                char c2 = eword.charAt(pos2);
                if (MimeMessageUtility.isHex(c1) && MimeMessageUtility.isHex(c2)) {
                    int pos3 = pos + 3;
                    nextPos = pos3 > len ? len : pos3;
                    sb.append(eword.substring(prev, nextPos));
                } else {
                    nextPos = pos1;
                    if (ENCODINGS.contains(HeaderName.valueOf(charset))) {
                        sb.append(eword.substring(prev, pos)).append("=3D");
                    } else {
                        sb.append(eword.substring(prev, pos)).append(MimeMessageUtility.qencode('=', charset));
                    }
                }
                prev = nextPos;
                pos = nextPos < len ? eword.indexOf(61, nextPos) : -1;
                continue;
            }
            if (prev < len) {
                sb.append(eword.substring(prev));
                prev = len;
            }
            pos = -1;
        } while (pos != -1);
        if (prev < len) {
            sb.append(eword.substring(prev));
        }
        return sb.toString();
    }

    private static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
    }

    private static String qencode(char toEncode, String charset) {
        if (!Charset.isSupported(charset)) {
            return String.valueOf(toEncode);
        }
        StringBuilder retval = new StringBuilder(4);
        try {
            byte[] bytes;
            for (byte b : bytes = String.valueOf(toEncode).getBytes(charset)) {
                retval.append('=').append(Integer.toHexString(b & 0xFF).toUpperCase(Locale.ENGLISH));
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("", (Throwable)e);
        }
        return retval.toString();
    }

    public static String getFileName(MailPart mailPart) {
        String fileName = mailPart.getContentDisposition().getFilenameParameter();
        if (MimeMessageUtility.isEmpty(fileName)) {
            fileName = mailPart.getContentType().getNameParameter();
        }
        return MimeMessageUtility.decodeMultiEncodedHeader(fileName);
    }

    public static InternetAddress[] parseAddressList(String addresslist, boolean strict) {
        try {
            return MimeMessageUtility.parseAddressList(addresslist, strict, false);
        }
        catch (AddressException e) {
            throw new IllegalStateException("Unexpected exception.", e);
        }
    }

    public static List<String> splitAddrs(String addrs) {
        if (MimeMessageUtility.isEmpty(addrs)) {
            return Collections.emptyList();
        }
        String[] sa = SPLITS.split(addrs, 0);
        ArrayList<String> ret = new ArrayList<String>(sa.length);
        StringBuilder tmp = new StringBuilder(24);
        for (String string : sa) {
            String trim = string.trim();
            if (trim.charAt(0) == '\"') {
                tmp.setLength(0);
                tmp.append(trim).append(", ");
                continue;
            }
            if (trim.indexOf("\" <") >= 0) {
                tmp.append(trim);
                ret.add(tmp.toString());
                tmp.setLength(0);
                continue;
            }
            if (tmp.length() > 0) {
                tmp.append(string).append(", ");
                continue;
            }
            ret.add(string);
        }
        if (tmp.length() > 0) {
            String str = tmp.toString();
            ret.add(str.endsWith(", ") ? str.substring(0, str.length() - 2) : str);
        }
        return ret;
    }

    public static InternetAddress[] parseAddressList(String addresslist, boolean strict, boolean failOnError) throws AddressException {
        if (null == addresslist) {
            return new InternetAddress[0];
        }
        String al = MimeMessageUtility.replaceWithComma(MimeMessageUtility.unfold(addresslist));
        InternetAddress[] addrs = null;
        try {
            addrs = QuotedInternetAddress.parse(al, strict);
        }
        catch (AddressException e) {
            List<String> sAddrs = MimeMessageUtility.splitAddrs(al);
            if (null == sAddrs || sAddrs.isEmpty()) {
                return new InternetAddress[0];
            }
            try {
                ArrayList<QuotedInternetAddress> addrList = new ArrayList<QuotedInternetAddress>(sAddrs.size());
                for (String sAddr : sAddrs) {
                    QuotedInternetAddress tmp = new QuotedInternetAddress(sAddr, strict);
                    LOG.trace(tmp.toString());
                    addrList.add(tmp);
                }
                return addrList.toArray(new InternetAddress[0]);
            }
            catch (AddressException e1) {
                if (failOnError) {
                    for (String sAddr : sAddrs) {
                        QuotedInternetAddress tmp = new QuotedInternetAddress(sAddr, strict);
                        LOG.trace(tmp.toString());
                    }
                    throw e;
                }
                LOG.debug("Internet addresses could not be properly parsed, using plain addresses' string representation instead.", (Throwable)e);
                addrs = PlainTextAddress.getAddresses(MimeMessageUtility.splitAddrs(al).toArray(new String[0]));
            }
        }
        try {
            for (InternetAddress addr : addrs) {
                if (null == addr) continue;
                addr.setPersonal(addr.getPersonal(), MailProperties.getInstance().getDefaultMimeCharset());
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("", (Throwable)e);
        }
        return addrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkReplaceWithComma() {
        Boolean b = checkReplaceWithComma;
        if (null != b) return b;
        Class<MimeMessageUtility> clazz = MimeMessageUtility.class;
        synchronized (MimeMessageUtility.class) {
            b = checkReplaceWithComma;
            if (null != b) return b;
            boolean fallback = false;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            checkReplaceWithComma = b = Boolean.valueOf(service.getBoolProperty("com.openexchange.mail.replaceWithComma", false));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return b;
        }
    }

    public static String replaceWithComma(String addressList) {
        if (null == addressList) {
            return null;
        }
        if (!MimeMessageUtility.checkReplaceWithComma()) {
            return addressList;
        }
        Matcher m = PATTERN_REPLACE.matcher(addressList);
        if (!m.find()) {
            return addressList;
        }
        StringBuilder sb = new StringBuilder(addressList.length());
        int lastMatch = 0;
        do {
            sb.append(addressList.substring(lastMatch, m.start()));
            sb.append(m.group(1)).append(m.group(2)).append(',').append(m.group(3));
            lastMatch = m.end();
        } while (m.find());
        sb.append(addressList.substring(lastMatch));
        return sb.toString();
    }

    public static String quoteReplacement(String s) {
        if (MimeMessageUtility.isEmpty(s) || s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        int length = s.length();
        StringBuilder sb = new StringBuilder(length << 1);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String quotePersonal(String personal) {
        return MimeMessageUtility.quotePhrase(personal, true);
    }

    public static String quotePhrase(String phrase, boolean encode) {
        return MimeMessageUtility.quotePhrase(phrase, encode, true);
    }

    public static String quotePhrase(String phrase, boolean encode, boolean allowNonAscii) {
        if (null == phrase) {
            return phrase;
        }
        int len = phrase.length();
        if (len == 0) {
            return phrase;
        }
        if ('\"' == phrase.charAt(0) && '\"' == phrase.charAt(len - 1)) {
            return phrase;
        }
        boolean needQuoting = false;
        for (int i = 0; !needQuoting && i < len; ++i) {
            char c = phrase.charAt(i);
            needQuoting = c == '\"' || c == '\\' || c < ' ' && c != '\r' && c != '\n' && c != '\t' || !allowNonAscii && c >= '\u007f' || RFC822.indexOf(c) >= 0;
        }
        try {
            if (!needQuoting) {
                return encode ? MimeUtility.encodeWord((String)phrase) : phrase;
            }
            String replaced = P_REPL2.matcher(P_REPL1.matcher(phrase).replaceAll("\\\\\\\\")).replaceAll("\\\\\\\"");
            return new StringBuilder(len + 2).append('\"').append(encode ? MimeUtility.encodeWord((String)replaced) : replaced).append('\"').toString();
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unsupported encoding in a message detected and monitored", (Throwable)e);
            MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(e.getMessage());
            return phrase;
        }
    }

    public static String foldContentType(String contentType) {
        return MimeMessageUtility.fold(14, contentType);
    }

    public static String foldContentDisposition(String contentDisposition) {
        return MimeMessageUtility.fold(21, contentDisposition);
    }

    public static void setFoldedHeader(String headerName, String headerValue, MimeMessage mimeMessage) throws MessagingException {
        if (null != headerName && null != headerValue && null != mimeMessage) {
            mimeMessage.setHeader(headerName, MimeMessageUtility.fold(headerName.length() + 1, headerValue));
        }
    }

    public static String fold(int used, String foldMe) {
        char c;
        int end;
        for (end = foldMe.length() - 1; end >= 0 && ((c = foldMe.charAt(end)) == ' ' || c == '\t' || c == '\r' || c == '\n'); --end) {
        }
        String s = end != foldMe.length() - 1 ? foldMe.substring(0, end + 1) : foldMe;
        if (used + s.length() <= 76) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 4);
        char lastc = '\u0000';
        int usedChars = used;
        while (usedChars + s.length() > 76) {
            int lastspace = -1;
            for (int i = 0; i < s.length() && (lastspace == -1 || usedChars + i <= 76); ++i) {
                c = s.charAt(i);
                if ((c == ' ' || c == '\t') && lastc != ' ' && lastc != '\t') {
                    lastspace = i;
                }
                lastc = c;
            }
            if (lastspace == -1) {
                sb.append(s);
                s = "";
                usedChars = 0;
                break;
            }
            sb.append(s.substring(0, lastspace));
            sb.append("\r\n");
            lastc = s.charAt(lastspace);
            sb.append(lastc);
            s = s.substring(lastspace + 1);
            usedChars = 1;
        }
        sb.append(s);
        return sb.toString();
    }

    public static String unfold(String headerLine) {
        if (null == headerLine) {
            return null;
        }
        String s = PATTERN_UNFOLD.matcher(headerLine).replaceAll("$1$3");
        int i = headerLine.indexOf(13);
        if (i < 0 && (i = headerLine.indexOf(10)) < 0) {
            return s;
        }
        if (headerLine.indexOf("=?") < 0) {
            s = headerLine;
        } else {
            s = MimeMessageUtility.unfoldEncodedWords(headerLine);
            i = s.indexOf(13);
            if (i < 0 && (i = s.indexOf(10)) < 0) {
                return s;
            }
        }
        StringBuilder sb = null;
        do {
            int start = i++;
            int len = s.length();
            if (i < len && s.charAt(i - 1) == '\r' && s.charAt(i) == '\n') {
                ++i;
            }
            if (start == 0 || s.charAt(start - 1) != '\\') {
                char c;
                if (i < len && ((c = s.charAt(i)) == ' ' || c == '\t')) {
                    ++i;
                    while (i < len && ((c = s.charAt(i)) == ' ' || c == '\t')) {
                        ++i;
                    }
                    if (sb == null) {
                        sb = new StringBuilder(s.length());
                    }
                    if (start != 0) {
                        sb.append(s.substring(0, start));
                        sb.append(' ');
                    }
                    s = s.substring(i);
                    continue;
                }
                if (sb == null) {
                    sb = new StringBuilder(s.length());
                }
                sb.append(s.substring(0, i));
                s = s.substring(i);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(s.length());
            }
            sb.append(s.substring(0, start - 1));
            sb.append(s.substring(start, i));
            s = s.substring(i);
        } while ((i = s.indexOf(13)) >= 0 || (i = s.indexOf(10)) >= 0);
        sb.append(s);
        return sb.toString();
    }

    private static String unfoldEncodedWords(String encodedWords) {
        return PAT_ENC_WORDS.matcher(encodedWords).replaceAll("$1$2");
    }

    public static String extractHeader(String headerName, InputStream inputStream, boolean closeStream) throws IOException {
        boolean close = closeStream;
        try {
            UnsynchronizedByteArrayOutputStream buffer = new UnsynchronizedByteArrayOutputStream(8192);
            int start = 0;
            int i = -1;
            boolean firstColonFound = false;
            boolean found = false;
            while ((i = inputStream.read()) != -1) {
                int count = 0;
                while (i == 13 || i == 10) {
                    if (!found) {
                        buffer.write(i);
                    }
                    if (i == 10) {
                        if (found) {
                            i = inputStream.read();
                            if (i != 32 && i != 9) {
                                String string = Charsets.toAsciiString((byte[])buffer.toByteArray());
                                return string;
                            }
                            buffer.write(13);
                            buffer.write(10);
                            buffer.write(i);
                        }
                        if (++count >= 2) {
                            String string = null;
                            return string;
                        }
                        i = inputStream.read();
                        if (i != 32 && i != 9) {
                            start = buffer.size();
                            firstColonFound = false;
                        }
                        buffer.write(i);
                    }
                    i = inputStream.read();
                }
                buffer.write(i);
                if (firstColonFound || i != 58) continue;
                firstColonFound = true;
                if (!Charsets.toAsciiString((byte[])buffer.toByteArray(start, buffer.size() - start - 1)).equalsIgnoreCase(headerName)) continue;
                buffer.reset();
                found = true;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            close = true;
            throw e;
        }
        finally {
            if (close) {
                Streams.close((Closeable)inputStream);
            }
        }
    }

    public static void writeHeaders(MailPart p, OutputStream os) throws OXException {
        if (p instanceof MimeMailMessage) {
            MimeMessageUtility.writeHeaders((MimePart)((MimeMailMessage)p).getMimeMessage(), os);
            return;
        }
        if (p instanceof MimeMailPart) {
            MimeMessageUtility.writeHeaders(((MimeMailPart)p).getPart(), os);
            return;
        }
        try {
            LineOutputStream los = os instanceof LineOutputStream ? (LineOutputStream)os : new LineOutputStream(os);
            StringBuilder sb = new StringBuilder(256);
            Iterator<Map.Entry<String, String>> it = p.getHeadersIterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                sb.setLength(0);
                sb.append(entry.getKey()).append(": ");
                sb.append(MimeMessageUtility.fold(sb.length(), entry.getValue()));
                los.writeln(sb);
            }
            los.writeln();
            os.flush();
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static void writeHeaders(Part p, OutputStream os) throws OXException {
        if (p instanceof MimePart) {
            MimeMessageUtility.writeHeaders((MimePart)p, os);
            return;
        }
        try {
            LineOutputStream los = os instanceof LineOutputStream ? (LineOutputStream)os : new LineOutputStream(os);
            Enumeration headers = p.getAllHeaders();
            StringBuilder sb = new StringBuilder(256);
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                sb.setLength(0);
                sb.append(header.getName()).append(": ");
                sb.append(MimeMessageUtility.fold(sb.length(), header.getValue()));
                los.writeln(sb);
            }
            los.writeln();
            os.flush();
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static void writeHeaders(MimePart p, OutputStream os) throws OXException {
        try {
            LineOutputStream los = os instanceof LineOutputStream ? (LineOutputStream)os : new LineOutputStream(os);
            Enumeration hdrLines = p.getNonMatchingHeaderLines(null);
            while (hdrLines.hasMoreElements()) {
                los.writeln((CharSequence)hdrLines.nextElement());
            }
            los.writeln();
            os.flush();
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static String getHeader(String name, String defaultValue, Part part) throws MessagingException {
        if (null == name || null == part) {
            return defaultValue;
        }
        String[] header = part.getHeader(name);
        if (null == header || 0 == header.length) {
            return defaultValue;
        }
        return MimeMessageUtility.isEmpty(header[0]) ? defaultValue : header[0];
    }

    public static boolean isInline(Part part) throws MessagingException {
        if (null == part) {
            return false;
        }
        String disposition = Strings.asciiLowerCase((String)MimeMessageUtility.getHeader("Content-Disposition", null, part));
        if (null != disposition) {
            return disposition.startsWith("inline") || disposition.indexOf("filename=") < 0;
        }
        String type = Strings.asciiLowerCase((String)MimeMessageUtility.getHeader("Content-Type", "", part));
        return type.indexOf("name=") < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File dropInvalidHeaders(File file, File newTempFile) {
        File file2;
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int read;
            in = new BufferedInputStream(new FileInputStream(file), 65536);
            out = new BufferedOutputStream(new FileOutputStream(newTempFile), 65536);
            LineReaderInputStreamAdaptor instream = new LineReaderInputStreamAdaptor((InputStream)in, -1);
            int lineCount = 0;
            ByteArrayBuffer linebuf = new ByteArrayBuffer(64);
            DefaultFieldBuilder fieldBuilder = new DefaultFieldBuilder(-1);
            boolean endOfHeader = false;
            while (!endOfHeader) {
                RawField rawfield;
                byte ch;
                fieldBuilder.reset();
                do {
                    int len;
                    if ((len = linebuf.length()) > 0) {
                        fieldBuilder.append(linebuf);
                    }
                    linebuf.clear();
                    if (instream.readLine(linebuf) == -1) {
                        endOfHeader = true;
                    } else {
                        len = linebuf.length();
                        if (len > 0 && linebuf.byteAt(len - 1) == 10) {
                            --len;
                        }
                        if (len > 0 && linebuf.byteAt(len - 1) == 13) {
                            --len;
                        }
                        if (len != 0) continue;
                        endOfHeader = true;
                    }
                    break;
                } while (++lineCount <= 1 || (ch = linebuf.byteAt(0)) == 32 || ch == 9);
                if ((rawfield = fieldBuilder.build()) == null || X_ORIGINAL_HEADERS.equalsIgnoreCase(rawfield.getName())) continue;
                ByteArrayBuffer buffer = fieldBuilder.getRaw();
                out.write(buffer.buffer(), 0, buffer.length());
            }
            int l = 2048;
            byte[] buf = new byte[2048];
            while ((read = ((InputStream)in).read(buf, 0, 2048)) > 0) {
                out.write(buf, 0, read);
            }
            out.flush();
            file2 = newTempFile;
        }
        catch (Exception e) {
            File file3;
            try {
                file3 = file;
            }
            catch (Throwable throwable) {
                Streams.close((Closeable[])new Closeable[]{in, out});
                throw throwable;
            }
            Streams.close((Closeable[])new Closeable[]{in, out});
            return file3;
        }
        Streams.close((Closeable[])new Closeable[]{in, out});
        return file2;
    }

    public static String getCharset(MailPart mailPart, ContentType contentType) throws OXException {
        String charset;
        if (null == mailPart) {
            return null;
        }
        if (mailPart.containsHeader(HDR_CONTENT_TYPE)) {
            String cs = contentType.getCharsetParameter();
            if (!CharsetDetector.isValid((String)cs)) {
                if (null != cs) {
                    MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(cs);
                }
                if (contentType.startsWith(PRIMARY_TEXT)) {
                    cs = CharsetDetector.detectCharset((InputStream)mailPart.getInputStream());
                    if ("US-ASCII".equalsIgnoreCase(cs)) {
                        cs = "ISO-8859-1";
                    }
                } else {
                    cs = MailProperties.getInstance().getDefaultMimeCharset();
                }
            }
            charset = cs;
        } else {
            InputStream inputStream;
            charset = contentType.startsWith(PRIMARY_TEXT) ? (null == (inputStream = mailPart.getInputStream()) ? MailProperties.getInstance().getDefaultMimeCharset() : CharsetDetector.detectCharset((InputStream)inputStream)) : MailProperties.getInstance().getDefaultMimeCharset();
        }
        return charset;
    }

    public static String readContent(MailPart mailPart, ContentType contentType) throws OXException, IOException {
        return MimeMessageUtility.readContent(mailPart, contentType, false);
    }

    public static String readContent(MailPart mailPart, ContentType contentType, boolean errorOnNoContent) throws OXException, IOException {
        return MimeMessageUtility.readContent(mailPart, contentType, errorOnNoContent, MailProperties.getInstance().getBodyDisplaySize());
    }

    public static String readContent(MailPart mailPart, ContentType contentType, boolean errorOnNoContent, long maxSize) throws OXException, IOException {
        if (null == mailPart) {
            return null;
        }
        String charset = MimeMessageUtility.getCharset(mailPart, contentType);
        try {
            if (contentType.startsWith("text/htm")) {
                String html = MessageUtility.readMailPart(mailPart, charset, errorOnNoContent, maxSize);
                return MessageUtility.simpleHtmlDuplicateRemoval(html);
            }
            return MessageUtility.readMailPart(mailPart, charset, errorOnNoContent, maxSize);
        }
        catch (CharConversionException e) {
            String fallback = "ISO-8859-1";
            LOG.warn("Character conversion exception while reading content with charset \"{}\". Using fallback charset \"{}\" instead.", new Object[]{charset, "ISO-8859-1", e});
            return MessageUtility.readMailPart(mailPart, "ISO-8859-1", errorOnNoContent, maxSize);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                LOG.warn("Mail part removed in the meantime.", (Throwable)e);
                return null;
            }
            throw e;
        }
    }

    public static MimeMessage parseMimeMessageFrom(InputStream is, Date optReceivedDate) throws OXException {
        return MimeMessageUtility.newMimeMessage(is, optReceivedDate);
    }

    public static MimeMessage newMimeMessage(InputStream is, final Date optReceivedDate) throws OXException {
        InputStream msgSrc = is;
        ThresholdFileHolder sink = new ThresholdFileHolder();
        boolean closeSink = true;
        try {
            sink.write(msgSrc);
            msgSrc = null;
            File tempFile = sink.getTempFile();
            Object tmp = null == tempFile ? new MimeMessage(MimeDefaultSession.getDefaultSession(), sink.getStream()){

                public Date getReceivedDate() throws MessagingException {
                    return null == optReceivedDate ? super.getReceivedDate() : optReceivedDate;
                }
            } : new FileBackedMimeMessage(MimeDefaultSession.getDefaultSession(), tempFile, optReceivedDate);
            closeSink = false;
            MimeMessage mimeMessage = tmp;
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (closeSink) {
                sink.close();
            }
        }
    }

    public static MimeBodyPart newMimeBodyPart(InputStream is) throws OXException {
        InputStream msgSrc = is;
        ThresholdFileHolder sink = new ThresholdFileHolder();
        boolean closeSink = true;
        try {
            sink.write(msgSrc);
            msgSrc = null;
            File tempFile = sink.getTempFile();
            FileBackedMimeBodyPart tmp = null == tempFile ? new MimeBodyPart(sink.getStream()) : new FileBackedMimeBodyPart(tempFile);
            closeSink = false;
            FileBackedMimeBodyPart fileBackedMimeBodyPart = tmp;
            return fileBackedMimeBodyPart;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (closeSink) {
                sink.close();
            }
        }
    }

    public static DataSource newDataSource(InputStream is, String contentType) throws OXException {
        InputStream msgSrc = is;
        ThresholdFileHolder sink = new ThresholdFileHolder();
        boolean closeSink = true;
        try {
            sink.write(msgSrc);
            msgSrc = null;
            File tempFile = sink.getTempFile();
            FileDataSource tmp = null == tempFile ? new ByteArrayDataSource(sink.getBuffer().toByteArray(), contentType) : new FileDataSource(tempFile, contentType);
            closeSink = false;
            FileDataSource fileDataSource = tmp;
            return fileDataSource;
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (closeSink) {
                sink.close();
            }
        }
    }

    public static MimeMessage cloneMessage(MimeMessage original, final Date optReceivedDate) throws OXException {
        ThresholdFileHolder sink = new ThresholdFileHolder();
        boolean closeSink = true;
        try {
            original.writeTo(sink.asOutputStream());
            File tempFile = sink.getTempFile();
            Object tmp = null == tempFile ? new MimeMessage(MimeDefaultSession.getDefaultSession(), sink.getStream()){

                public Date getReceivedDate() throws MessagingException {
                    return null == optReceivedDate ? super.getReceivedDate() : optReceivedDate;
                }
            } : new FileBackedMimeMessage(MimeDefaultSession.getDefaultSession(), tempFile, optReceivedDate);
            closeSink = false;
            MimeMessage mimeMessage = tmp;
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (closeSink) {
                sink.close();
            }
        }
    }

    public static MimeBodyPart clonePart(Part part) throws OXException {
        ThresholdFileHolder sink = new ThresholdFileHolder();
        boolean closeSink = true;
        try {
            part.writeTo(sink.asOutputStream());
            File tempFile = sink.getTempFile();
            FileBackedMimeBodyPart tmp = null == tempFile ? new MimeBodyPart(sink.getStream()) : new FileBackedMimeBodyPart(tempFile);
            closeSink = false;
            FileBackedMimeBodyPart fileBackedMimeBodyPart = tmp;
            return fileBackedMimeBodyPart;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (closeSink) {
                sink.close();
            }
        }
    }

    public static InputStream getStreamFromPart(final Part part) throws IOException {
        if (null == part) {
            return null;
        }
        final PipedOutputStream pos = new PipedOutputStream();
        final ExceptionAwarePipedInputStream pin = new ExceptionAwarePipedInputStream(pos, 65536);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    part.writeTo((OutputStream)pos);
                }
                catch (Exception e) {
                    pin.setException(e);
                }
                finally {
                    Streams.close((Closeable)pos);
                }
            }
        };
        ThreadPoolService threadPool = ThreadPools.getThreadPool();
        if (null == threadPool) {
            new Thread(r, "MimeMessageUtility.getStreamFromPart").start();
        } else {
            threadPool.submit(ThreadPools.task((Runnable)r), AbortBehavior.getInstance());
        }
        return pin;
    }

    public static InputStream getStreamFromMailPart(final MailPart part) throws OXException {
        if (null == part) {
            return null;
        }
        try {
            final PipedOutputStream pos = new PipedOutputStream();
            final ExceptionAwarePipedInputStream pin = new ExceptionAwarePipedInputStream(pos, 65536);
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        part.writeTo(pos);
                    }
                    catch (Exception e) {
                        pin.setException(e);
                    }
                    finally {
                        Streams.close((Closeable)pos);
                    }
                }
            };
            ThreadPoolService threadPool = ThreadPools.getThreadPool();
            if (null == threadPool) {
                new Thread(r, "MimeMessageUtility.getStreamFromMailPart").start();
            } else {
                threadPool.submit(ThreadPools.task((Runnable)r), AbortBehavior.getInstance());
            }
            return pin;
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static Multipart getMultipartContentFrom(Part part) throws MessagingException, IOException {
        if (null == part) {
            return null;
        }
        String contentType = MimeMessageUtility.getHeader("Content-Type", null, part);
        if (null == contentType || !Strings.asciiLowerCase((String)contentType).startsWith("multipart/")) {
            return null;
        }
        return MimeMessageUtility.getMultipartContentFrom(part, contentType);
    }

    public static Multipart getMultipartContentFrom(Part part, String contentType) throws MessagingException, IOException {
        if (null == part) {
            return null;
        }
        if (null == contentType || !Strings.asciiLowerCase((String)contentType).startsWith("multipart/")) {
            return null;
        }
        return MimeMessageUtility.multipartFrom(part, contentType);
    }

    public static Multipart multipartFrom(Part part) throws MessagingException, IOException {
        return MimeMessageUtility.multipartFrom(part, null);
    }

    private static Multipart multipartFrom(Part part, String contentType) throws MessagingException, IOException {
        try {
            Object content = part.getContent();
            if (content instanceof Multipart) {
                return (Multipart)content;
            }
            if (content instanceof InputStream) {
                return new MimeMultipart((DataSource)new MessageDataSource((InputStream)content, null == contentType ? MimeMessageUtility.getHeader("Content-Type", null, part) : contentType));
            }
            if (content instanceof Message) {
                return MimeMessageUtility.getMultipartContentFrom((Part)((Message)content));
            }
            if (content instanceof String) {
                return new MimeMultipart((DataSource)new MessageDataSource((InputStream)Streams.newByteArrayInputStream((byte[])((String)content).getBytes(Charsets.ISO_8859_1)), null == contentType ? MimeMessageUtility.getHeader("Content-Type", null, part) : contentType));
            }
            LOG.warn("Unable to retrieve multipart content fromt part with Content-Type={}. Content signals to be {}.", (Object)(null == contentType ? MimeMessageUtility.getHeader("Content-Type", null, part) : contentType), (Object)(null == content ? "null" : content.getClass().getName()));
            return null;
        }
        catch (MessageRemovedIOException e) {
            String message = e.getMessage();
            throw new MessageRemovedException(null == message ? "Message has been removed in the meantime" : message, (Exception)((Object)e));
        }
    }

    public static String detectPartCharset(Part p) throws MessagingException {
        if (null == p) {
            return null;
        }
        try {
            return CharsetDetector.detectCharset((InputStream)p.getInputStream());
        }
        catch (IOException e) {
            InputStream rawIn;
            if (p instanceof MimeBodyPart) {
                rawIn = ((MimeBodyPart)p).getRawInputStream();
            } else if (p instanceof MimeMessage) {
                rawIn = ((MimeMessage)p).getRawInputStream();
            } else {
                LOG.error("", (Throwable)e);
                return CharsetDetector.getFallback();
            }
            return CharsetDetector.detectCharset((InputStream)rawIn);
        }
    }

    public static MimeMessage mimeMessageFrom(final Message msg) throws MessagingException, IOException {
        ThresholdFileHolder sink = null;
        boolean closeSink = true;
        try {
            MimeMessage tmp;
            sink = new ThresholdFileHolder();
            msg.writeTo(sink.asOutputStream());
            File tempFile = sink.getTempFile();
            if (null == tempFile) {
                tmp = new MimeMessage(MimeDefaultSession.getDefaultSession(), sink.getStream()){

                    public Date getReceivedDate() throws MessagingException {
                        return msg.getReceivedDate();
                    }
                };
            } else {
                FileBackedMimeMessage fbm = new FileBackedMimeMessage(MimeDefaultSession.getDefaultSession(), tempFile, msg.getReceivedDate());
                tmp = fbm;
            }
            closeSink = false;
            MimeMessage mimeMessage = tmp;
            return mimeMessage;
        }
        catch (OXException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
        catch (MessageRemovedIOException e) {
            throw new MessageRemovedException(e.getMessage());
        }
        catch (IOException e) {
            if (e.getCause() instanceof MessageRemovedException) {
                throw (MessageRemovedException)e.getCause();
            }
            throw e;
        }
        finally {
            if (closeSink && null != sink) {
                sink.close();
            }
        }
    }

    public static void saveChanges(MimeMessage mimeMessage, String hostName, boolean keepMessageIdIfPresent) throws OXException {
        try {
            String messageId;
            String name = "Message-ID";
            String prevMessageId = keepMessageIdIfPresent ? mimeMessage.getHeader(name, null) : null;
            MimeMessageUtility.saveChanges(mimeMessage);
            if (null != prevMessageId) {
                mimeMessage.setHeader(name, prevMessageId);
            } else if (null != hostName && null != (messageId = mimeMessage.getHeader(name, null))) {
                int pos = messageId.indexOf(64);
                if (pos > 0) {
                    StringBuilder mid = new StringBuilder(messageId.substring(0, pos + 1)).append(hostName);
                    if (messageId.charAt(0) == '<') {
                        mid.append('>');
                    }
                    mimeMessage.setHeader(name, mid.toString());
                } else {
                    mimeMessage.setHeader(name, messageId + hostName);
                }
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public static void saveChanges(MimeMessage mimeMessage) throws OXException {
        MimeMessageUtility.saveChanges(mimeMessage, true);
    }

    private static void saveChanges(MimeMessage mimeMessage, boolean trySanitizeMultipart) throws OXException {
        block8: {
            if (null == mimeMessage) {
                return;
            }
            try {
                try {
                    mimeMessage.saveChanges();
                }
                catch (ParseException e) {
                    MimeMessageUtility.sanitizeContentTypeHeaders((Part)mimeMessage, new ContentType());
                    mimeMessage.saveChanges();
                }
                catch (MessagingException e) {
                    if (!trySanitizeMultipart) {
                        throw MimeMailException.handleMessagingException(e);
                    }
                    String msg = Strings.asciiLowerCase((String)e.getMessage());
                    if (null != msg && msg.startsWith("mime part of type \"multipart/")) {
                        MimeMessageUtility.sanitizeMultipartContent((MimePart)mimeMessage);
                        MimeMessageUtility.saveChanges(mimeMessage, false);
                        break block8;
                    }
                    throw MimeMailException.handleMessagingException(e);
                }
            }
            catch (MessagingException e) {
                throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
            }
        }
    }

    private static boolean sanitizeMultipartContent(MimePart part) throws OXException {
        try {
            String sContentType = Strings.asciiLowerCase((String)part.getHeader("Content-Type", null));
            if (null != sContentType && sContentType.startsWith("multipart/")) {
                Object o = part.getContent();
                if (o instanceof MimeMultipart) {
                    MimeMultipart multipart = (MimeMultipart)o;
                    int count = multipart.getCount();
                    for (int i = 0; i < count; ++i) {
                        if (MimeMessageUtility.sanitizeMultipartContent((MimePart)multipart.getBodyPart(i))) continue;
                        return false;
                    }
                    return true;
                }
                if (o instanceof InputStream) {
                    MimeMultipart multipart = new MimeMultipart((DataSource)new MessageDataSource((InputStream)o, sContentType));
                    part.setContent((Multipart)multipart);
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private static void sanitizeContentTypeHeaders(Part part, ContentType sanitizer) throws OXException {
        DataHandler dh;
        try {
            dh = part.getDataHandler();
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        if (dh == null) {
            return;
        }
        try {
            Object o;
            String type = dh.getContentType();
            sanitizer.setContentType(type);
            try {
                new javax.mail.internet.ContentType(type);
            }
            catch (ParseException e) {
                String cts = sanitizer.toString(true);
                try {
                    new javax.mail.internet.ContentType(cts);
                }
                catch (ParseException pe) {
                    throw MailExceptionCode.INVALID_CONTENT_TYPE.create(e, type);
                }
                part.setDataHandler((DataHandler)new DataHandlerWrapper(dh, cts));
                part.setHeader("Content-Type", cts);
            }
            if (sanitizer.startsWith("multipart/") && (o = dh.getContent()) instanceof MimeMultipart) {
                MimeMultipart mm = (MimeMultipart)o;
                int count = mm.getCount();
                for (int i = 0; i < count; ++i) {
                    MimeMessageUtility.sanitizeContentTypeHeaders((Part)mm.getBodyPart(i), sanitizer);
                }
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    static {
        HashSet<HeaderName> tmp = new HashSet<HeaderName>(4);
        tmp.add(HeaderName.valueOf("iso-8859-1"));
        tmp.add(HeaderName.valueOf("windows-1258"));
        tmp.add(HeaderName.valueOf("UTF-8"));
        tmp.add(HeaderName.valueOf("us-ascii"));
        ENCODINGS = Collections.unmodifiableSet(tmp);
        MailDateFormat mdf = new MailDateFormat();
        mdf.setTimeZone(TimeZoneUtils.getTimeZone("UTC"));
        MAIL_DATE_FORMAT = mdf;
        MDF_MAP = new ConcurrentHashMap<String, Future<MailDateFormat>>();
        PATTERN_EMBD_IMG = Pattern.compile("(<img[^>]+src=\"cid:)([^\"]+)(\"[^>]*/?>)", 34);
        PATTERN_EMBD_IMG_ALT = Pattern.compile("(<img[^>]+src=\")([0-9a-z&&[^.\\s>\"]]+\\.[0-9a-z&&[^.\\s>\"]]+)(\"[^>]*/?>)", 34);
        PATTERN_CODE_POINT = Pattern.compile("%u00([a-fA-F0-9]{2})");
        PATTERN_SRC = Pattern.compile("<img[^>]*?src=\"([^\"]+)\"[^>]*/?>", 2);
        ENC_PATTERN = Pattern.compile("=\\?(\\S+?)\\?(\\S+?)\\?(.+?)\\?=");
        SPLITS = Pattern.compile(" *, *");
        MailReloadable.getInstance().addReloadable(new Reloadable(){

            public void reloadConfiguration(ConfigurationService configService) {
                checkReplaceWithComma = null;
            }

            public Map<String, String[]> getConfigFileNames() {
                return null;
            }
        });
        PATTERN_REPLACE = Pattern.compile("(\\.\\w+>?)(\\s*);(\\s*)");
        P_REPL1 = Pattern.compile("\\\\");
        P_REPL2 = Pattern.compile("\"");
        PATTERN_UNFOLD = Pattern.compile("(\\?=)(\\s*)(=\\?)");
        String regex = "(\\?=)(?:\r?\n(?:\t| +))(=\\?)";
        PAT_ENC_WORDS = Pattern.compile("(\\?=)(?:\r?\n(?:\t| +))(=\\?)");
        HDR_CONTENT_TYPE = MessageHeaders.HDR_CONTENT_TYPE;
        POISON_ADDRESS = new InternetAddress(){
            private static final long serialVersionUID = -6860515616722560896L;
            {
                this.address = "poison@unknown-domain.invalid";
                this.personal = "Poison";
                this.encodedPersonal = "Poison";
            }

            public String toString() {
                return "poison";
            }

            public String getType() {
                return "rfc822";
            }

            public boolean equals(Object address) {
                return this == address;
            }
        };
    }

    private static final class LineOutputStream
    extends FilterOutputStream {
        private static final byte[] newline = new byte[]{13, 10};

        protected LineOutputStream(OutputStream out) {
            super(out);
        }

        protected void writeln(CharSequence s) throws IOException {
            this.out.write(LineOutputStream.getBytes(s));
            this.out.write(newline);
        }

        protected void writeln() throws IOException {
            this.out.write(newline);
        }

        private static byte[] getBytes(CharSequence s) {
            if (null == s) {
                return new byte[0];
            }
            int len = s.length();
            byte[] bytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                bytes[i] = (byte)s.charAt(i);
            }
            return bytes;
        }
    }
}

