/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.writer;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.log.LogProperties;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.Delegatized;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeFilter;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.FileBackedMimeMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.JsonMessageHandler;
import com.openexchange.mail.parser.handlers.RawJSONMessageHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.TimeZone;
import javax.mail.internet.InternetAddress;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public final class MessageWriter {
    private static final EnumMap<MailListField, MailFieldWriter> WRITERS;
    private static final MailFieldWriter UNKNOWN;
    private static final JSONArray EMPTY_JSON_ARR;
    private static final String DUMMY_DOMAIN = "@unspecified-domain";

    private MessageWriter() {
    }

    public static JSONObject writeStructure(int accountId, MailMessage mail, long maxSize) throws OXException {
        LogProperties.putProperty((LogProperties.Name)LogProperties.Name.MAIL_ACCOUNT_ID, (Object)Integer.toString(accountId));
        if (null != mail.getFolder()) {
            LogProperties.putProperty((LogProperties.Name)LogProperties.Name.MAIL_FULL_NAME, (Object)mail.getFolder());
        }
        if (null != mail.getMailId()) {
            LogProperties.putProperty((LogProperties.Name)LogProperties.Name.MAIL_MAIL_ID, (Object)mail.getMailId());
        }
        MIMEStructureHandler handler = new MIMEStructureHandler(maxSize);
        mail.setAccountId(accountId);
        new StructureMailMessageParser().setParseTNEFParts(true).parseMailMessage(mail, handler);
        return handler.getJSONMailObject();
    }

    public static JSONObject writeMailMessage(int accountId, MailMessage mail, DisplayMode displayMode, boolean embedded, Session session, UserSettingMail settings) throws OXException {
        return MessageWriter.writeMailMessage(accountId, mail, displayMode, embedded, session, settings, null, false, -1);
    }

    public static JSONObject writeMailMessage(int accountId, MailMessage mail, DisplayMode displayMode, boolean embedded, Session session, UserSettingMail settings, Collection<OXException> warnings, boolean token, int tokenTimeout) throws OXException {
        return MessageWriter.writeMailMessage(accountId, mail, displayMode, embedded, session, settings, warnings, token, tokenTimeout, null);
    }

    public static JSONObject writeMailMessage(int accountId, MailMessage mail, DisplayMode displayMode, boolean embedded, Session session, UserSettingMail settings, Collection<OXException> warnings, boolean token, int tokenTimeout, MimeFilter mimeFilter) throws OXException {
        return MessageWriter.writeMailMessage(accountId, mail, displayMode, embedded, session, settings, warnings, token, tokenTimeout, mimeFilter, null, false, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject writeMailMessage(int accountId, MailMessage mail, DisplayMode displayMode, boolean embedded, Session session, UserSettingMail settings, Collection<OXException> warnings, boolean token, int tokenTimeout, MimeFilter mimeFilter, TimeZone optTimeZone, boolean exactLength, int maxContentSize, int maxNestedMessageLevels) throws OXException {
        String fullName = mail.getFolder();
        String mailId = mail.getMailId();
        MailPath mailPath = fullName != null && mailId != null ? new MailPath(MessageWriter.getAccountIdFor(accountId, mail), fullName, mailId) : (mail.getMsgref() != null ? mail.getMsgref() : MailPath.NULL);
        UserSettingMail usm = null == settings ? UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), session.getContextId()) : settings;
        LogProperties.putProperty((LogProperties.Name)LogProperties.Name.MAIL_ACCOUNT_ID, (Object)Integer.toString(accountId));
        if (null != fullName) {
            LogProperties.putProperty((LogProperties.Name)LogProperties.Name.MAIL_FULL_NAME, (Object)fullName);
        }
        if (null != mailId) {
            LogProperties.putProperty((LogProperties.Name)LogProperties.Name.MAIL_MAIL_ID, (Object)mailId);
        }
        try {
            int undelegatedAccountId;
            List<OXException> list;
            JsonMessageHandler handler = new JsonMessageHandler(accountId, mailPath, mail, displayMode, embedded, session, usm, token, tokenTimeout, maxContentSize, maxNestedMessageLevels);
            handler.setExactLength(exactLength);
            if (null != optTimeZone) {
                handler.setTimeZone(optTimeZone);
            }
            MailMessageParser parser = new MailMessageParser().addMimeFilter(mimeFilter);
            ThresholdFileHolder backup = null;
            try {
                parser.parseMailMessage(mail, handler);
            }
            catch (OXException e) {
                if (!MailExceptionCode.NO_CONTENT.equals(e)) {
                    throw e;
                }
                try {
                    backup = new ThresholdFileHolder();
                    mail.writeTo(backup.asOutputStream());
                    FileBackedMimeMessage mimeMessage = new FileBackedMimeMessage(MimeDefaultSession.getDefaultSession(), backup.getSharedStream());
                    parser.parseMailMessage(MimeMessageConverter.convertMessage(mimeMessage, true), handler);
                    backup = null;
                }
                catch (Exception x) {
                    throw e;
                }
            }
            finally {
                if (null != backup) {
                    backup.close();
                }
            }
            if (null != warnings && !(list = parser.getWarnings()).isEmpty()) {
                warnings.addAll(list);
            }
            JSONObject jsonObject = handler.getJSONObject();
            if (mail instanceof Delegatized && (undelegatedAccountId = ((Delegatized)((Object)mail)).getUndelegatedAccountId()) >= 0) {
                try {
                    jsonObject.put("folder_id", (Object)MailFolderUtility.prepareFullname(undelegatedAccountId, fullName));
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
            if (!mail.isDraft()) {
                return jsonObject;
            }
            String key = MailJSONField.MSGREF.getKey();
            if (!jsonObject.has(key) && null != mailPath) {
                try {
                    jsonObject.put(key, (Object)mailPath.toString());
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
            return jsonObject;
        }
        catch (OXException e) {
            Throwable cause = e.getCause();
            if (null != cause && cause.getClass().getName().startsWith("MessageRemoved")) {
                throw MailExceptionCode.MAIL_NOT_FOUND.create(cause, mailId, mail.getFolder());
            }
            throw e;
        }
    }

    private static int getAccountIdFor(int accountId, MailMessage mail) {
        if (!(mail instanceof Delegatized)) {
            return accountId;
        }
        int accId = ((Delegatized)((Object)mail)).getUndelegatedAccountId();
        if (accId < 0) {
            return accountId;
        }
        return accId;
    }

    public static JSONObject writeRawMailMessage(int accountId, MailMessage mail) throws OXException {
        MailPath mailPath = mail.getFolder() != null && mail.getMailId() != null ? new MailPath(accountId, mail.getFolder(), mail.getMailId()) : (mail.getMsgref() != null ? mail.getMsgref() : MailPath.NULL);
        RawJSONMessageHandler handler = new RawJSONMessageHandler(accountId, mailPath, mail);
        new MailMessageParser().parseMailMessage(mail, handler);
        return handler.getJSONObject();
    }

    public static MailFieldWriter[] getMailFieldWriters(MailListField[] fields) {
        MailFieldWriter[] retval = new MailFieldWriter[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            MailFieldWriter mfw = WRITERS.get((Object)fields[i]);
            retval[i] = mfw == null ? UNKNOWN : mfw;
        }
        return retval;
    }

    public static MailFieldWriter getMailFieldWriter(MailListField field) {
        MailFieldWriter mfw = WRITERS.get((Object)field);
        return null == mfw ? UNKNOWN : mfw;
    }

    public static MailFieldWriter[] getHeaderFieldWriters(String[] headers) {
        if (null == headers) {
            return new MailFieldWriter[0];
        }
        MailFieldWriter[] retval = new MailFieldWriter[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            retval[i] = new HeaderFieldWriter(headers[i]);
        }
        return retval;
    }

    public static MailFieldWriter getHeaderFieldWriter(String header) {
        return null == header ? null : new HeaderFieldWriter(header);
    }

    public static long addUserTimezone(long time, TimeZone timeZone) {
        return time + (long)timeZone.getOffset(time);
    }

    public static JSONArray getAddressesAsArray(InternetAddress[] addrs) {
        if (addrs == null || addrs.length == 0) {
            return EMPTY_JSON_ARR;
        }
        JSONArray jsonArr = new JSONArray(addrs.length);
        for (InternetAddress address : addrs) {
            jsonArr.put((Object)MessageWriter.getAddressAsArray(address));
        }
        return jsonArr;
    }

    private static JSONArray getAddressAsArray(InternetAddress addr) {
        JSONArray retval = new JSONArray(2);
        String personal = addr.getPersonal();
        retval.put(personal == null || personal.length() == 0 ? JSONObject.NULL : MessageWriter.preparePersonal(personal));
        String address = addr.getAddress();
        retval.put(address == null || address.length() == 0 ? JSONObject.NULL : MessageWriter.prepareAddress(address));
        return retval;
    }

    private static String preparePersonal(String personal) {
        return MimeMessageUtility.quotePhrase(personal, false);
    }

    private static String prepareAddress(String address) {
        String decoded = QuotedInternetAddress.toIDN(MimeMessageUtility.decodeMultiEncodedHeader(address));
        int pos = decoded.indexOf(64);
        if (pos < 0 && (pos = decoded.indexOf(47)) > 0) {
            decoded = decoded.substring(0, pos);
        }
        if ((pos = decoded.indexOf(DUMMY_DOMAIN)) >= 0) {
            return decoded.substring(0, pos);
        }
        return decoded;
    }

    static {
        EnumMap<MailListField, MailFieldWriter> writers = new EnumMap<MailListField, MailFieldWriter>(MailListField.class);
        writers.put(MailListField.ID, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put("id", (Object)mail.getMailId());
                    } else {
                        jsonContainer.toArray().put((Object)mail.getMailId());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.FOLDER_ID, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    int undelegatedAccountId;
                    int accId = accountId;
                    if (mail instanceof Delegatized && (undelegatedAccountId = ((Delegatized)((Object)mail)).getUndelegatedAccountId()) >= 0) {
                        accId = undelegatedAccountId;
                    }
                    if (withKey) {
                        jsonContainer.toObject().put("folder_id", (Object)MailFolderUtility.prepareFullname(accId, mail.getFolder()));
                    } else {
                        jsonContainer.toArray().put((Object)MailFolderUtility.prepareFullname(accId, mail.getFolder()));
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.ORIGINAL_ID, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    Object originalId;
                    if (mail.containsOriginalId() && null != mail.getOriginalId()) {
                        originalId = mail.getOriginalId();
                    } else {
                        String id = mail.getMailId();
                        Object object = originalId = null == id ? JSONObject.NULL : id;
                    }
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.ORIGINAL_ID.getKey(), originalId);
                    } else {
                        jsonContainer.toArray().put(originalId);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.ORIGINAL_FOLDER_ID, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    Object originalFolder;
                    int undelegatedAccountId;
                    int accId = accountId;
                    if (mail instanceof Delegatized && (undelegatedAccountId = ((Delegatized)((Object)mail)).getUndelegatedAccountId()) >= 0) {
                        accId = undelegatedAccountId;
                    }
                    if (mail.containsOriginalFolder() && null != mail.getOriginalFolder()) {
                        originalFolder = MailFolderUtility.prepareFullname(accId, mail.getOriginalFolder());
                    } else {
                        String folder = mail.getFolder();
                        Object object = originalFolder = null == folder ? JSONObject.NULL : MailFolderUtility.prepareFullname(accId, folder);
                    }
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.ORIGINAL_FOLDER_ID.getKey(), originalFolder);
                    } else {
                        jsonContainer.toArray().put(originalFolder);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.ATTACHMENT, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.HAS_ATTACHMENTS.getKey(), mail.hasAttachment());
                    } else {
                        jsonContainer.toArray().put(mail.hasAttachment());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.MIME_TYPE, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.CONTENT_TYPE.getKey(), (Object)mail.getContentType().toLowerCaseString());
                    } else {
                        jsonContainer.toArray().put((Object)mail.getContentType().toLowerCaseString());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.FROM, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.FROM.getKey(), (Object)MessageWriter.getAddressesAsArray(mail.getFrom()));
                    } else {
                        jsonContainer.toArray().put((Object)MessageWriter.getAddressesAsArray(mail.getFrom()));
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.TO, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.RECIPIENT_TO.getKey(), (Object)MessageWriter.getAddressesAsArray(mail.getTo()));
                    } else {
                        jsonContainer.toArray().put((Object)MessageWriter.getAddressesAsArray(mail.getTo()));
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.CC, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.RECIPIENT_CC.getKey(), (Object)MessageWriter.getAddressesAsArray(mail.getCc()));
                    } else {
                        jsonContainer.toArray().put((Object)MessageWriter.getAddressesAsArray(mail.getCc()));
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.BCC, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.RECIPIENT_BCC.getKey(), (Object)MessageWriter.getAddressesAsArray(mail.getBcc()));
                    } else {
                        jsonContainer.toArray().put((Object)MessageWriter.getAddressesAsArray(mail.getBcc()));
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.SUBJECT, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    String subject = mail.getSubject();
                    if (withKey) {
                        if (subject != null) {
                            subject = MimeMessageUtility.decodeMultiEncodedHeader(subject);
                            jsonContainer.toObject().put(MailJSONField.SUBJECT.getKey(), (Object)subject.trim());
                        }
                    } else if (subject == null) {
                        jsonContainer.toArray().put(JSONObject.NULL);
                    } else {
                        subject = MimeMessageUtility.decodeMultiEncodedHeader(subject);
                        jsonContainer.toArray().put((Object)subject.trim());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.SIZE, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.SIZE.getKey(), mail.getSize());
                    } else {
                        jsonContainer.toArray().put(mail.getSize());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.SENT_DATE, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    TimeZone timeZone = optTimeZone;
                    if (null == timeZone) {
                        timeZone = TimeZoneUtils.getTimeZone(UserStorage.getInstance().getUser(user, cid).getTimeZone());
                    }
                    if (withKey) {
                        if (mail.containsSentDate() && mail.getSentDate() != null) {
                            jsonContainer.toObject().put(MailJSONField.SENT_DATE.getKey(), MessageWriter.addUserTimezone(mail.getSentDate().getTime(), timeZone));
                        }
                    } else if (mail.containsSentDate() && mail.getSentDate() != null) {
                        jsonContainer.toArray().put(MessageWriter.addUserTimezone(mail.getSentDate().getTime(), timeZone));
                    } else {
                        jsonContainer.toArray().put(JSONObject.NULL);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.RECEIVED_DATE, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    TimeZone timeZone = optTimeZone;
                    if (null == timeZone) {
                        timeZone = TimeZoneUtils.getTimeZone(UserStorage.getInstance().getUser(user, cid).getTimeZone());
                    }
                    if (withKey) {
                        if (mail.containsReceivedDate() && mail.getReceivedDate() != null) {
                            jsonContainer.toObject().put(MailJSONField.RECEIVED_DATE.getKey(), MessageWriter.addUserTimezone(mail.getReceivedDate().getTime(), timeZone));
                        }
                    } else if (mail.containsReceivedDate() && mail.getReceivedDate() != null) {
                        jsonContainer.toArray().put(MessageWriter.addUserTimezone(mail.getReceivedDate().getTime(), timeZone));
                    } else {
                        jsonContainer.toArray().put(JSONObject.NULL);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.FLAGS, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.FLAGS.getKey(), mail.getFlags());
                    } else {
                        jsonContainer.toArray().put(mail.getFlags());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.THREAD_LEVEL, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.THREAD_LEVEL.getKey(), mail.getThreadLevel());
                    } else {
                        jsonContainer.toArray().put(mail.getThreadLevel());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.DISPOSITION_NOTIFICATION_TO, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    Object value;
                    if (mail.containsPrevSeen() ? mail.isPrevSeen() : mail.isSeen()) {
                        value = JSONObject.NULL;
                    } else {
                        Object object = value = mail.getDispositionNotification() == null ? JSONObject.NULL : mail.getDispositionNotification().toUnicodeString();
                    }
                    if (withKey) {
                        if (!JSONObject.NULL.equals(value)) {
                            jsonContainer.toObject().put(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey(), value);
                        }
                    } else {
                        jsonContainer.toArray().put(value);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.PRIORITY, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.PRIORITY.getKey(), mail.getPriority());
                    } else {
                        jsonContainer.toArray().put(mail.getPriority());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.MSG_REF, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        if (mail.containsMsgref()) {
                            jsonContainer.toObject().put(MailJSONField.MSGREF.getKey(), (Object)mail.getMsgref());
                        }
                    } else {
                        jsonContainer.toArray().put(mail.containsMsgref() ? mail.getMsgref() : JSONObject.NULL);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.COLOR_LABEL, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    int colorLabel = MailProperties.getInstance().isUserFlagsEnabled() && mail.containsColorLabel() ? mail.getColorLabel() : 0;
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.COLOR_LABEL.getKey(), colorLabel);
                    } else {
                        jsonContainer.toArray().put(colorLabel);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.TOTAL, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.TOTAL.getKey(), JSONObject.NULL);
                    } else {
                        jsonContainer.toArray().put(JSONObject.NULL);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.NEW, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.NEW.getKey(), JSONObject.NULL);
                    } else {
                        jsonContainer.toArray().put(JSONObject.NULL);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.UNREAD, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.UNREAD.getKey(), mail.getUnreadMessages());
                    } else {
                        jsonContainer.toArray().put(mail.getUnreadMessages());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.DELETED, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put(MailJSONField.DELETED.getKey(), JSONObject.NULL);
                    } else {
                        jsonContainer.toArray().put(JSONObject.NULL);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.ACCOUNT_NAME, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        JSONObject jsonObject = (JSONObject)jsonContainer;
                        jsonObject.put(MailJSONField.ACCOUNT_NAME.getKey(), (Object)mail.getAccountName());
                        jsonObject.put(MailJSONField.ACCOUNT_ID.getKey(), mail.getAccountId());
                    } else {
                        jsonContainer.toArray().put((Object)mail.getAccountName());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        writers.put(MailListField.ACCOUNT_ID, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        JSONObject jsonObject = (JSONObject)jsonContainer;
                        jsonObject.put(MailJSONField.ACCOUNT_NAME.getKey(), (Object)mail.getAccountName());
                        jsonObject.put(MailJSONField.ACCOUNT_ID.getKey(), mail.getAccountId());
                    } else {
                        jsonContainer.toArray().put(mail.getAccountId());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS = writers;
        UNKNOWN = new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
                try {
                    if (withKey) {
                        jsonContainer.toObject().put("Unknown column", JSONObject.NULL);
                    } else {
                        jsonContainer.toArray().put(JSONObject.NULL);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        };
        EMPTY_JSON_ARR = new JSONArray(0);
    }

    private static final class HeaderFieldWriter
    implements MailFieldWriter {
        private final String headerName;

        HeaderFieldWriter(String headerName) {
            this.headerName = headerName;
        }

        @Override
        public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid, TimeZone optTimeZone) throws OXException {
            Object value = this.getHeaderValue(mail);
            if (withKey) {
                if (null != value) {
                    try {
                        jsonContainer.toObject().put(this.headerName, value);
                    }
                    catch (JSONException e) {
                        throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                    }
                }
            } else {
                jsonContainer.toArray().put(null == value ? JSONObject.NULL : value);
            }
        }

        private Object getHeaderValue(MailMessage mail) {
            String[] headerValues = mail.getHeader(this.headerName);
            if (null == headerValues || 0 == headerValues.length) {
                return null;
            }
            int length = headerValues.length;
            if (1 == length) {
                return headerValues[0];
            }
            JSONArray ja = new JSONArray(length);
            for (String headerValue : headerValues) {
                ja.put((Object)headerValue);
            }
            return ja;
        }
    }

    public static interface MailFieldWriter {
        public void writeField(JSONValue var1, MailMessage var2, int var3, boolean var4, int var5, int var6, int var7, TimeZone var8) throws OXException;
    }
}

