/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.tasks.AbstractUserAliasTableUpdateTask;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import java.util.UUID;

public class MigrateAliasUpdateTask
extends AbstractUserAliasTableUpdateTask {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int ctxId = params.getContextId();
        Connection conn = Database.getNoTimeout(ctxId, true);
        try {
            Set<AbstractUserAliasTableUpdateTask.Alias> aliases;
            conn.setAutoCommit(false);
            if (!Tools.tableExists(conn, "user_alias")) {
                this.createTable(conn);
            }
            if ((aliases = this.getAllAliasesInUserAttributes(conn)) != null && !aliases.isEmpty()) {
                this.insertAliases(conn, aliases);
            }
            conn.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(conn);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(conn);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(conn);
            Database.backNoTimeout(ctxId, true, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(Connection conn) throws SQLException {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute("CREATE TABLE `user_alias` ( `cid` INT4 UNSIGNED NOT NULL, `user` INT4 UNSIGNED NOT NULL, `alias` VARCHAR(255) NOT NULL, `uuid` BINARY(16) DEFAULT NULL,PRIMARY KEY (`cid`, `user`, `alias`, `uuid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;");
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertAliases(Connection conn, Set<AbstractUserAliasTableUpdateTask.Alias> aliases) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("REPLACE INTO user_alias (cid, user, alias, uuid) VALUES(?, ?, ?, ?)");
            for (AbstractUserAliasTableUpdateTask.Alias alias : aliases) {
                int index = 0;
                stmt.setInt(++index, alias.getCid());
                stmt.setInt(++index, alias.getUserId());
                stmt.setString(++index, alias.getAlias());
                stmt.setBytes(++index, UUIDs.toByteArray((UUID)alias.getUuid()));
                stmt.addBatch();
            }
            int[] updateCounts = stmt.executeBatch();
            int updated = 0;
            for (int updateCount : updateCounts) {
                updated += updateCount;
            }
            int n = updated;
            return n;
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING);
    }
}

