/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.groupware.update.internal.DependenciesResolvedChecker;
import com.openexchange.groupware.update.internal.DependencyChecker;
import com.openexchange.java.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UpdateTaskSorter {
    private static final DependencyChecker[] CHECKERS = new DependencyChecker[]{new DependenciesResolvedChecker()};

    public List<UpdateTaskV2> sort(String[] executed, List<UpdateTaskV2> toExecute) throws OXException {
        ArrayList<UpdateTaskV2> retval = new ArrayList<UpdateTaskV2>(toExecute.size());
        boolean found = true;
        while (!toExecute.isEmpty() && found) {
            found = false;
            Iterator<UpdateTaskV2> iter = toExecute.iterator();
            while (iter.hasNext() && !found) {
                UpdateTaskV2 task = iter.next();
                UpdateTaskV2[] retvalA = retval.toArray(new UpdateTaskV2[retval.size()]);
                UpdateTaskV2[] toExecuteA = toExecute.toArray(new UpdateTaskV2[toExecute.size()]);
                for (int i = 0; i < CHECKERS.length && !found; ++i) {
                    found = CHECKERS[i].check(task, executed, retvalA, toExecuteA);
                }
                if (!found) continue;
                retval.add(task);
                iter.remove();
            }
        }
        if (!toExecute.isEmpty()) {
            throw UpdateExceptionCodes.UNRESOLVABLE_DEPENDENCIES.create(Strings.join((Object[])executed, (String)","), Strings.join(retval, (String)","), Strings.join(toExecute, (String)","));
        }
        return retval;
    }
}

