/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.modules;

import com.openexchange.groupware.userconfiguration.Permission;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.HashMap;
import java.util.Map;

public enum Module {
    TASK("tasks", 1, Permission.TASKS),
    CALENDAR("calendar", 2, Permission.CALENDAR),
    CONTACTS("contacts", 3, Permission.CONTACTS),
    UNBOUND("unbound", 4, null),
    MAIL("mail", 7, Permission.WEBMAIL),
    INFOSTORE("infostore", 8, Permission.INFOSTORE),
    FILES("files", 8, Permission.INFOSTORE),
    SYSTEM("system", 5, null);

    private final String name;
    private final int folderConstant;
    private final Permission permission;
    private static final TIntObjectMap<Module> folderConstant2Module;
    private static final TObjectIntMap<String> string2FolderConstant;
    private static final Map<String, Module> name2Module;

    private Module(String name, int folderConstant, Permission permission) {
        this.name = name;
        this.folderConstant = folderConstant;
        this.permission = permission;
    }

    public static Module getForFolderConstant(int constant) {
        return (Module)((Object)folderConstant2Module.get(constant));
    }

    public static Module getForName(String name) {
        return name2Module.get(name);
    }

    public String getName() {
        return this.name;
    }

    public int getFolderConstant() {
        return this.folderConstant;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public static final String getModuleString(int module, int folderId) {
        String moduleStr = null;
        switch (module) {
            case 1: {
                moduleStr = TASK.getName();
                break;
            }
            case 3: {
                moduleStr = CONTACTS.getName();
                break;
            }
            case 2: {
                moduleStr = CALENDAR.getName();
                break;
            }
            case 4: {
                moduleStr = UNBOUND.getName();
                break;
            }
            case 7: {
                moduleStr = MAIL.getName();
                break;
            }
            case 8: {
                moduleStr = INFOSTORE.getName();
                break;
            }
            case 5: {
                if (folderId == 9) {
                    moduleStr = INFOSTORE.getName();
                    break;
                }
                moduleStr = SYSTEM.getName();
                break;
            }
            default: {
                moduleStr = "";
            }
        }
        return moduleStr;
    }

    public static final int getModuleInteger(String moduleStr) {
        return null == moduleStr ? -1 : string2FolderConstant.get((Object)moduleStr);
    }

    static {
        Module[] values = Module.values();
        TIntObjectHashMap map1 = new TIntObjectHashMap(values.length);
        TObjectIntHashMap map2 = new TObjectIntHashMap(values.length, 0.5f, -1);
        HashMap<String, Module> map3 = new HashMap<String, Module>();
        for (Module module : values) {
            map1.put(module.folderConstant, (Object)module);
            map2.put((Object)module.name, module.folderConstant);
            map3.put(module.name, module);
        }
        folderConstant2Module = map1;
        string2FolderConstant = map2;
        name2Module = map3;
    }
}

