/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.validation;

import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.validation.DocumentMetadataValidation;
import com.openexchange.groupware.infostore.validation.InfostoreValidator;
import com.openexchange.tools.session.ServerSession;

public class FilenamesMayNotContainSlashesValidator
implements InfostoreValidator {
    private static final String NAME = FilenamesMayNotContainSlashesValidator.class.getSimpleName();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public DocumentMetadataValidation validate(ServerSession session, DocumentMetadata metadata) {
        String filename = metadata.getFileName();
        DocumentMetadataValidation validation = new DocumentMetadataValidation();
        if (filename != null && filename.indexOf(47) >= 0) {
            validation.setError(Metadata.FILENAME_LITERAL, "Filenames may not contain slashes.");
        }
        validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_SLASH.create());
        return validation;
    }
}

