/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.search.impl;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.database.Databases;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurityImpl;
import com.openexchange.groupware.infostore.search.SearchTerm;
import com.openexchange.groupware.infostore.search.impl.ToMySqlQueryVisitor;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.AsciiReader;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.iterator.SearchIteratorExceptionCodes;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.sql.SearchStrings;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.net.SocketTimeoutException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchEngineImpl
extends DBService {
    private static final Logger LOG = LoggerFactory.getLogger(SearchEngineImpl.class);
    private final InfostoreSecurityImpl security = new InfostoreSecurityImpl();
    private static final String[] SEARCH_FIELDS = new String[]{"infostore_document.title", "infostore_document.url", "infostore_document.description", "infostore_document.categories", "infostore_document.filename", "infostore_document.file_version_comment"};

    public SearchEngineImpl() {
        super(null);
    }

    public SearchEngineImpl(DBProvider provider) {
        super(provider);
        this.security.setProvider(provider);
    }

    @Override
    public void setProvider(DBProvider provider) {
        super.setProvider(provider);
        if (this.security != null) {
            this.security.setProvider(provider);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearchIterator<DocumentMetadata> search(ServerSession session, SearchTerm<?> searchTerm, List<Integer> all, List<Integer> own, Metadata[] cols, Metadata sortedBy, int dir, int start, int end) throws OXException {
        InfostoreSearchIterator infostoreSearchIterator;
        Connection con;
        PreparedStatement stmt;
        block7: {
            ToMySqlQueryVisitor visitor = new ToMySqlQueryVisitor(session, all, own, this.getResultFieldsSelect(cols), sortedBy, dir, start, end);
            searchTerm.visit(visitor);
            String sqlQuery = visitor.getMySqlQuery();
            boolean successful = false;
            stmt = null;
            con = null;
            InfostoreSearchIterator iter = null;
            try {
                con = this.getReadConnection(session.getContext());
                stmt = con.prepareStatement(sqlQuery);
                iter = new InfostoreSearchIterator(stmt.executeQuery(), this, cols, session.getContext(), con, stmt);
                successful = true;
                infostoreSearchIterator = iter;
                if (successful) return infostoreSearchIterator;
                if (iter == null) break block7;
            }
            catch (SQLException e) {
                try {
                    if (e.getCause() instanceof SocketTimeoutException) {
                        throw InfostoreExceptionCodes.SEARCH_TOOK_TOO_LONG.create(e, session.getUserId(), session.getContextId(), sqlQuery);
                    }
                    LOG.error("", (Throwable)e);
                    throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, sqlQuery);
                    catch (OXException e2) {
                        LOG.error("", (Throwable)e2);
                        throw InfostoreExceptionCodes.PREFETCH_FAILED.create(e2, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (successful) throw throwable;
                    if (iter != null) {
                        SearchIterators.close(iter);
                        throw throwable;
                    }
                    if (con == null) throw throwable;
                    this.releaseReadConnection(session.getContext(), con);
                    DBUtils.closeSQLStuff(stmt);
                    throw throwable;
                }
            }
            SearchIterators.close((SearchIterator)iter);
            return infostoreSearchIterator;
        }
        if (con == null) return infostoreSearchIterator;
        this.releaseReadConnection(session.getContext(), con);
        DBUtils.closeSQLStuff(stmt);
        return infostoreSearchIterator;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearchIterator<DocumentMetadata> search(ServerSession session, String query, List<Integer> all, List<Integer> own, Metadata[] cols, Metadata sortedBy, int dir, int start, int end) throws OXException {
        InfostoreSearchIterator i2222222;
        PreparedStatement stmt;
        Connection con;
        block15: {
            int maxResults;
            if ((Strings.isEmpty((String)query) || "*".equals(query)) && -11 != (maxResults = -11 != start && -11 != end && end >= start ? end + 1 - start : (-11 != start ? 200 : (-11 != end ? end + 1 : -11))) && own.size() + all.size() > maxResults) {
                if (null == sortedBy) return this.get(session, all, own, cols, sortedBy, dir, start, end);
                if (InfostoreQueryCatalog.Table.INFOSTORE.getFieldSet().contains(sortedBy)) {
                    return this.get(session, all, own, cols, sortedBy, dir, start, end);
                }
            }
            StringBuilder SQL_QUERY = new StringBuilder(512);
            SQL_QUERY.append(this.getResultFieldsSelect(cols));
            SQL_QUERY.append(" FROM infostore JOIN infostore_document ON infostore_document.cid = infostore.cid AND infostore_document.infostore_id = infostore.id AND infostore_document.version_number = infostore.version WHERE infostore.cid = ").append(session.getContextId());
            SearchEngineImpl.appendFolders(SQL_QUERY, session.getContextId(), session.getUserId(), all, own);
            boolean addQuery = false;
            String q = query;
            if (q.length() > 0 && !"*".equals(q)) {
                SearchEngineImpl.checkPatternLength(q);
                boolean containsWildcard = q.indexOf(42) >= 0 || 0 <= q.indexOf(63);
                addQuery = true;
                q = q.replaceAll("\\\\", "\\\\\\\\");
                q = q.replaceAll("%", "\\\\%");
                q = q.replace('*', '%');
                q = q.replace('?', '_');
                q = q.replaceAll("'", "\\\\'");
                if (!containsWildcard) {
                    q = "%" + q + "%";
                }
                StringBuffer SQL_QUERY_OBJECTS = new StringBuffer();
                for (String currentField : SEARCH_FIELDS) {
                    if (SQL_QUERY_OBJECTS.length() > 0) {
                        SQL_QUERY_OBJECTS.append(" OR ");
                    }
                    SQL_QUERY_OBJECTS.append(currentField);
                    SQL_QUERY_OBJECTS.append(" LIKE (?)");
                }
                if (SQL_QUERY_OBJECTS.length() > 0) {
                    SQL_QUERY.append(" AND (");
                    SQL_QUERY.append(SQL_QUERY_OBJECTS);
                    SQL_QUERY.append(") ");
                }
            }
            SearchEngineImpl.appendOrderBy(SQL_QUERY, sortedBy, dir);
            SearchEngineImpl.appendLimit(SQL_QUERY, start, end);
            con = this.getReadConnection(session.getContext());
            boolean successful = false;
            stmt = null;
            InfostoreSearchIterator iter = null;
            try {
                stmt = con.prepareStatement(SQL_QUERY.toString());
                if (addQuery) {
                    for (int i2222222 = 0; i2222222 < SEARCH_FIELDS.length; ++i2222222) {
                        stmt.setString(i2222222 + 1, q);
                    }
                }
                iter = new InfostoreSearchIterator(stmt.executeQuery(), this, cols, session.getContext(), con, stmt);
                successful = true;
                i2222222 = iter;
                if (successful) return i2222222;
                if (iter == null) break block15;
            }
            catch (SQLException e) {
                try {
                    LOG.error("", (Throwable)e);
                    throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, SQL_QUERY.toString());
                    catch (OXException e2) {
                        LOG.error("", (Throwable)e2);
                        throw InfostoreExceptionCodes.PREFETCH_FAILED.create(e2, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (successful) throw throwable;
                    if (iter != null) {
                        SearchIterators.close(iter);
                        throw throwable;
                    }
                    if (con == null) throw throwable;
                    this.releaseReadConnection(session.getContext(), con);
                    DBUtils.closeSQLStuff(stmt);
                    throw throwable;
                }
            }
            SearchIterators.close((SearchIterator)iter);
            return i2222222;
        }
        if (con == null) return i2222222;
        this.releaseReadConnection(session.getContext(), con);
        DBUtils.closeSQLStuff(stmt);
        return i2222222;
    }

    protected static void appendFoldersAsUnion(ServerSession session, StringBuilder sqlQuery, String filter, List<Integer> readAllFolders, List<Integer> readOwnFolders) {
        if (readAllFolders.isEmpty() && readOwnFolders.isEmpty()) {
            if (null != filter) {
                sqlQuery.append(" WHERE ").append(filter);
            }
            return;
        }
        int contextID = session.getContextId();
        int userID = session.getUserId();
        String prefix = sqlQuery.toString();
        boolean appendUnion = false;
        if (!readAllFolders.isEmpty()) {
            Integer sharedFilesFolderID = Autoboxing.I((int)10);
            if (readAllFolders.contains(sharedFilesFolderID)) {
                readAllFolders = new ArrayList<Integer>(readAllFolders);
                readAllFolders.remove(sharedFilesFolderID);
                sqlQuery.append(" WHERE infostore.cid = ").append(contextID).append(" AND ");
                sqlQuery.append("(infostore.id in (SELECT object_id FROM object_permission WHERE object_permission.module=");
                sqlQuery.append(8).append(" AND object_permission.cid=").append(contextID);
                sqlQuery.append(" AND ((group_flag<>1 AND permission_id=").append(userID).append(')');
                int[] groups = session.getUser().getGroups();
                if (null == groups || 0 == groups.length) {
                    sqlQuery.append(')');
                } else {
                    sqlQuery.append(" OR (group_flag=1 AND permission_id IN (").append(Strings.join((int[])groups, (String)",")).append(")))");
                }
                sqlQuery.append("))");
                if (null != filter) {
                    sqlQuery.append(" AND ").append(filter);
                }
                appendUnion = true;
            }
            if (!readAllFolders.isEmpty()) {
                if (appendUnion) {
                    sqlQuery.append(" UNION ").append(prefix);
                }
                Iterator<Integer> iter = readAllFolders.iterator();
                sqlQuery.append(" INNER JOIN (SELECT ").append(iter.next()).append(" AS fid");
                while (iter.hasNext()) {
                    sqlQuery.append(" UNION ALL SELECT ").append(iter.next());
                }
                sqlQuery.append(") AS x ON infostore.folder_id = x.fid");
                sqlQuery.append(" WHERE infostore.cid = ").append(contextID);
                if (null != filter) {
                    sqlQuery.append(" AND ").append(filter);
                }
                appendUnion = true;
            }
        }
        if (!readOwnFolders.isEmpty()) {
            if (appendUnion) {
                sqlQuery.append(" UNION ").append(prefix);
            }
            Iterator<Integer> iter = readOwnFolders.iterator();
            sqlQuery.append(" INNER JOIN (SELECT ").append(iter.next()).append(" AS fid");
            while (iter.hasNext()) {
                sqlQuery.append(" UNION ALL SELECT ").append(iter.next());
            }
            sqlQuery.append(") AS x ON infostore.folder_id = x.fid");
            sqlQuery.append(" WHERE infostore.cid = ").append(contextID);
            sqlQuery.append(" AND infostore.created_by=").append(userID);
            if (null != filter) {
                sqlQuery.append(" AND ").append(filter);
            }
        }
    }

    protected static void appendFolders(StringBuilder sqlQuery, int contextID, int userID, List<Integer> readAllFolders, List<Integer> readOwnFolders) {
        if (0 == readAllFolders.size() && 0 == readOwnFolders.size()) {
            return;
        }
        boolean appendOr = false;
        sqlQuery.append(" AND (");
        if (0 < readAllFolders.size()) {
            Integer sharedFilesFolderID = Autoboxing.I((int)10);
            if (readAllFolders.contains(sharedFilesFolderID)) {
                readAllFolders = new ArrayList<Integer>(readAllFolders);
                readAllFolders.remove(sharedFilesFolderID);
                sqlQuery.append("(infostore.id in (SELECT object_id FROM object_permission WHERE object_permission.module=").append(8).append(" AND object_permission.cid=").append(contextID).append(" AND permission_id=").append(userID).append("))");
                appendOr = true;
            }
            if (0 < readAllFolders.size()) {
                if (appendOr) {
                    sqlQuery.append(" OR ");
                }
                if (1 == readAllFolders.size()) {
                    sqlQuery.append("infostore.folder_id=").append(readAllFolders.get(0));
                } else {
                    sqlQuery.append("(infostore.folder_id IN (");
                    Strings.join(readAllFolders, (String)",", (StringBuilder)sqlQuery);
                    sqlQuery.append("))");
                }
                appendOr = true;
            }
        }
        if (0 < readOwnFolders.size()) {
            if (appendOr) {
                sqlQuery.append(" OR ");
            }
            sqlQuery.append("(infostore.created_by=").append(userID);
            if (1 == readOwnFolders.size()) {
                sqlQuery.append(" AND infostore.folder_id=").append(readOwnFolders.get(0)).append(')');
            } else {
                sqlQuery.append(" AND infostore.folder_id in (");
                Strings.join(readOwnFolders, (String)",", (StringBuilder)sqlQuery);
                sqlQuery.append("))");
            }
        }
        sqlQuery.append(')');
    }

    protected static void appendLimit(StringBuilder sqlQuery, int start, int end) {
        if (start != -11 && end != -11) {
            if (end >= start) {
                sqlQuery.append(" LIMIT ");
                sqlQuery.append(start);
                sqlQuery.append(", ");
                sqlQuery.append(end + 1 - start);
            }
        } else {
            if (start != -11) {
                sqlQuery.append(" LIMIT ");
                sqlQuery.append(start);
                sqlQuery.append(",200");
            }
            if (end != -11) {
                sqlQuery.append(" LIMIT ");
                sqlQuery.append(end + 1);
            }
        }
    }

    protected static void appendOrderBy(StringBuilder sqlQuery, Metadata sortedBy, int dir) {
        String[] orderColumn;
        if (sortedBy != null && dir != -11 && (orderColumn = SearchEngineImpl.switchMetadata2DBColumns(new Metadata[]{sortedBy})) != null && orderColumn[0] != null) {
            if (dir == -1) {
                sqlQuery.append(" ORDER BY ");
                sqlQuery.append(orderColumn[0]);
                sqlQuery.append(" DESC");
            } else if (dir == 1) {
                sqlQuery.append(" ORDER BY ");
                sqlQuery.append(orderColumn[0]);
                sqlQuery.append(" ASC");
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SearchIterator<DocumentMetadata> get(ServerSession session, List<Integer> readAllFolders, List<Integer> readOwnFolders, Metadata[] cols, Metadata sortedBy, int dir, int start, int end) throws OXException {
        InfostoreSearchIterator infostoreSearchIterator;
        PreparedStatement stmt;
        Connection connection;
        block12: {
            StringBuilder sqlQuery = new StringBuilder();
            sqlQuery.append("SELECT infostore.id FROM infostore WHERE infostore.cid=").append(session.getContextId());
            SearchEngineImpl.appendFolders(sqlQuery, session.getContextId(), session.getUserId(), readAllFolders, readOwnFolders);
            SearchEngineImpl.appendOrderBy(sqlQuery, sortedBy, dir);
            SearchEngineImpl.appendLimit(sqlQuery, start, end);
            connection = this.getReadConnection(session.getContext());
            ArrayList<Integer> objectIDs = new ArrayList<Integer>();
            PreparedStatement statement = null;
            ResultSet results = null;
            try {
                statement = connection.prepareStatement(sqlQuery.toString());
                results = statement.executeQuery();
                while (results.next()) {
                    objectIDs.add(results.getInt(1));
                }
            }
            catch (SQLException e) {
                try {
                    LOG.error("", (Throwable)e);
                    throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, sqlQuery.toString());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(results, statement);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(results, statement);
            if (0 == objectIDs.size()) {
                return SearchIteratorAdapter.emptyIterator();
            }
            sqlQuery = new StringBuilder();
            sqlQuery.append(this.getResultFieldsSelect(cols));
            sqlQuery.append(" FROM infostore JOIN infostore_document ON infostore_document.cid = infostore.cid AND infostore_document.infostore_id = infostore.id AND infostore_document.version_number = infostore.version WHERE infostore.cid = ").append(session.getContextId()).append(" AND infostore.id IN (").append(this.join(objectIDs)).append(")");
            SearchEngineImpl.appendOrderBy(sqlQuery, sortedBy, dir);
            boolean successful = false;
            stmt = null;
            InfostoreSearchIterator iter = null;
            try {
                stmt = connection.prepareStatement(sqlQuery.toString());
                iter = new InfostoreSearchIterator(stmt.executeQuery(), this, cols, session.getContext(), connection, stmt);
                successful = true;
                infostoreSearchIterator = iter;
                if (successful) return infostoreSearchIterator;
                if (iter == null) break block12;
            }
            catch (SQLException e) {
                try {
                    LOG.error("", (Throwable)e);
                    throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, sqlQuery.toString());
                    catch (OXException e2) {
                        LOG.error("", (Throwable)e2);
                        throw InfostoreExceptionCodes.PREFETCH_FAILED.create(e2, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (successful) throw throwable;
                    if (iter != null) {
                        SearchIterators.close(iter);
                        throw throwable;
                    }
                    if (connection == null) throw throwable;
                    this.releaseReadConnection(session.getContext(), connection);
                    DBUtils.closeSQLStuff(stmt);
                    throw throwable;
                }
            }
            SearchIterators.close((SearchIterator)iter);
            return infostoreSearchIterator;
        }
        if (connection == null) return infostoreSearchIterator;
        this.releaseReadConnection(session.getContext(), connection);
        DBUtils.closeSQLStuff(stmt);
        return infostoreSearchIterator;
    }

    public static void checkPatternLength(String pattern) throws OXException {
        int minimumSearchCharacters = ServerConfig.getInt(ServerConfig.Property.MINIMUM_SEARCH_CHARACTERS);
        if (0 == minimumSearchCharacters) {
            return;
        }
        if (null != pattern && SearchStrings.lengthWithoutWildcards(pattern) < minimumSearchCharacters) {
            throw InfostoreExceptionCodes.PATTERN_NEEDS_MORE_CHARACTERS.create(Autoboxing.I((int)minimumSearchCharacters));
        }
    }

    private String join(List<Integer> all) {
        StringBuffer joined = new StringBuffer();
        for (Integer i : all) {
            joined.append(i.toString());
            joined.append(',');
        }
        joined.setLength(joined.length() - 1);
        return joined.toString();
    }

    public void index(DocumentMetadata document, Context ctx, User user, UserPermissionBits userPermissions) {
    }

    public void unIndex0r(int id, Context ctx, User user, UserPermissionBits userPermissions) {
    }

    private static String[] switchMetadata2DBColumns(Metadata[] columns) {
        ArrayList<String> retval = new ArrayList<String>(columns.length);
        block24: for (Metadata current : columns) {
            switch (current.getId()) {
                default: {
                    continue block24;
                }
                case 5: {
                    retval.add("infostore.last_modified");
                    continue block24;
                }
                case 6: {
                    retval.add("infostore.last_modified");
                    continue block24;
                }
                case 4: {
                    retval.add("infostore.creating_date");
                    continue block24;
                }
                case 3: {
                    retval.add("infostore.changed_by");
                    continue block24;
                }
                case 20: {
                    retval.add("infostore.folder_id");
                    continue block24;
                }
                case 700: {
                    retval.add("infostore_document.title");
                    continue block24;
                }
                case 705: {
                    retval.add("infostore.version");
                    continue block24;
                }
                case 750: {
                    retval.add("infostore_document.description");
                    continue block24;
                }
                case 702: {
                    retval.add("infostore_document.filename");
                    continue block24;
                }
                case 751: {
                    retval.add("infostore.id");
                    continue block24;
                }
                case 1: {
                    retval.add("infostore.id");
                    continue block24;
                }
                case 704: {
                    retval.add("infostore_document.file_size");
                    continue block24;
                }
                case 703: {
                    retval.add("infostore_document.file_mimetype");
                    continue block24;
                }
                case 706: {
                    retval.add("infostore_document.description");
                    continue block24;
                }
                case 707: {
                    retval.add("infostore.locked_until");
                    continue block24;
                }
                case 701: {
                    retval.add("infostore_document.url");
                    continue block24;
                }
                case 2: {
                    retval.add("infostore.created_by");
                    continue block24;
                }
                case 100: {
                    retval.add("infostore_document.categories");
                    continue block24;
                }
                case 708: {
                    retval.add("infostore_document.file_md5sum");
                    continue block24;
                }
                case 709: {
                    retval.add("infostore_document.file_version_comment");
                    continue block24;
                }
                case 102: {
                    retval.add("infostore.color_label");
                    continue block24;
                }
                case 23: {
                    retval.add("infostore_document.meta");
                }
            }
        }
        return retval.toArray(new String[0]);
    }

    private String getResultFieldsSelect(Metadata[] RESULT_FIELDS) {
        String[] DB_RESULT_FIELDS = SearchEngineImpl.switchMetadata2DBColumns(RESULT_FIELDS);
        StringBuilder selectFields = new StringBuilder();
        boolean id = false;
        for (String currentField : DB_RESULT_FIELDS) {
            if (currentField.equals("infostore.id")) {
                currentField = "infostore.id";
                id = true;
            }
            selectFields.append(currentField);
            selectFields.append(", ");
        }
        if (!id) {
            selectFields.append("infostore.id,");
        }
        String retval = "";
        if (selectFields.length() > 0) {
            retval = "SELECT DISTINCT " + selectFields.toString();
            retval = retval.substring(0, retval.lastIndexOf(", "));
        }
        return retval;
    }

    public static class InfostoreSearchIterator
    implements SearchIterator<DocumentMetadata> {
        private Statement stmt;
        private Connection readCon;
        private ResultSet rs;
        private DocumentMetadata next;
        private final Metadata[] columns;
        private final SearchEngineImpl s;
        private final Context ctx;
        private final List<OXException> warnings = new ArrayList<OXException>(2);
        private final SearchIterator<DocumentMetadata> delegate;

        public InfostoreSearchIterator(ResultSet rs, SearchEngineImpl s, Metadata[] columns, Context ctx, Connection readCon, Statement stmt) throws OXException {
            this.rs = rs;
            this.s = s;
            this.columns = columns;
            this.ctx = ctx;
            this.readCon = readCon;
            this.stmt = stmt;
            SearchIteratorAdapter delegate = null;
            try {
                if (rs.next()) {
                    LinkedList<DocumentMetadataImpl> list = new LinkedList<DocumentMetadataImpl>();
                    boolean goahead = true;
                    DocumentMetadataImpl current = null;
                    while (goahead) {
                        current = this.fillDocumentMetadata(new DocumentMetadataImpl(), columns, rs);
                        while (current == null && rs.next()) {
                            current = this.fillDocumentMetadata(new DocumentMetadataImpl(), columns, rs);
                        }
                        if (current == null) {
                            goahead = false;
                        } else {
                            list.add(current);
                            current = null;
                            goahead = rs.next();
                        }
                        if (goahead) continue;
                        this.close();
                    }
                    delegate = new SearchIteratorAdapter(list.iterator(), list.size());
                } else {
                    this.close();
                }
            }
            catch (Exception e) {
                throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{EnumComponent.INFOSTORE});
            }
            this.delegate = delegate;
        }

        public boolean hasNext() throws OXException {
            return null == this.delegate ? this.next != null : this.delegate.hasNext();
        }

        public DocumentMetadata next() throws OXException {
            if (null != this.delegate) {
                return (DocumentMetadata)this.delegate.next();
            }
            try {
                DocumentMetadata retval = null;
                retval = this.next;
                if (this.rs.next()) {
                    this.next = this.fillDocumentMetadata(new DocumentMetadataImpl(), this.columns, this.rs);
                    while (this.next == null && this.rs.next()) {
                        this.next = this.fillDocumentMetadata(new DocumentMetadataImpl(), this.columns, this.rs);
                    }
                    if (this.next == null) {
                        this.close();
                    }
                } else {
                    this.close();
                }
                return retval;
            }
            catch (Exception exc) {
                throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)exc, new Object[]{EnumComponent.INFOSTORE});
            }
        }

        public void close() {
            this.next = null;
            Databases.closeSQLStuff((ResultSet)this.rs, (Statement)this.stmt);
            this.stmt = null;
            this.rs = null;
            if (null != this.readCon) {
                this.s.releaseReadConnection(this.ctx, this.readCon);
                this.readCon = null;
            }
        }

        public int size() {
            if (null != this.delegate) {
                return this.delegate.size();
            }
            return -1;
        }

        public boolean hasSize() {
            return false;
        }

        public void addWarning(OXException warning) {
            if (null == this.delegate) {
                this.warnings.add(warning);
            } else {
                this.delegate.addWarning(warning);
            }
        }

        public OXException[] getWarnings() {
            if (null != this.delegate) {
                return this.delegate.getWarnings();
            }
            return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
        }

        public boolean hasWarnings() {
            if (null != this.delegate) {
                return this.delegate.hasWarnings();
            }
            return !this.warnings.isEmpty();
        }

        private DocumentMetadataImpl fillDocumentMetadata(DocumentMetadataImpl retval, Metadata[] columns, ResultSet result) throws SQLException, OXException {
            int columnIndex = 0;
            block27: for (Metadata metadata : columns) {
                switch (metadata.getId()) {
                    case 5: 
                    case 6: {
                        long lastModified = result.getLong(++columnIndex);
                        retval.setLastModified(this.rs.wasNull() ? null : new Date(lastModified));
                        continue block27;
                    }
                    case 4: {
                        long creationDate = result.getLong(++columnIndex);
                        retval.setCreationDate(this.rs.wasNull() ? null : new Date(creationDate));
                        continue block27;
                    }
                    case 3: {
                        retval.setModifiedBy(result.getInt(++columnIndex));
                        continue block27;
                    }
                    case 20: {
                        retval.setFolderId(result.getInt(++columnIndex));
                        continue block27;
                    }
                    case 700: {
                        retval.setTitle(result.getString(++columnIndex));
                        continue block27;
                    }
                    case 705: {
                        retval.setVersion(result.getInt(++columnIndex));
                        continue block27;
                    }
                    case 702: {
                        retval.setFileName(result.getString(++columnIndex));
                        continue block27;
                    }
                    case 751: {
                        retval.setSequenceNumber(result.getLong(++columnIndex));
                        continue block27;
                    }
                    case 1: {
                        retval.setId(result.getInt(++columnIndex));
                        continue block27;
                    }
                    case 704: {
                        retval.setFileSize(result.getLong(++columnIndex));
                        continue block27;
                    }
                    case 703: {
                        retval.setFileMIMEType(result.getString(++columnIndex));
                        continue block27;
                    }
                    case 706: {
                        retval.setDescription(result.getString(++columnIndex));
                        continue block27;
                    }
                    case 707: {
                        long lockedUntil = result.getLong(++columnIndex);
                        retval.setLockedUntil(this.rs.wasNull() ? null : new Date(lockedUntil));
                        continue block27;
                    }
                    case 701: {
                        retval.setURL(result.getString(++columnIndex));
                        continue block27;
                    }
                    case 2: {
                        retval.setCreatedBy(result.getInt(++columnIndex));
                        continue block27;
                    }
                    case 100: {
                        retval.setCategories(result.getString(++columnIndex));
                        continue block27;
                    }
                    case 708: {
                        retval.setFileMD5Sum(result.getString(++columnIndex));
                        continue block27;
                    }
                    case 709: {
                        retval.setVersionComment(result.getString(++columnIndex));
                        continue block27;
                    }
                    case 102: {
                        retval.setColorLabel(result.getInt(++columnIndex));
                        continue block27;
                    }
                    case 23: {
                        InputStream jsonBlobStream = this.rs.getBinaryStream(++columnIndex);
                        if (this.rs.wasNull() || null == jsonBlobStream) continue block27;
                        try {
                            retval.setMeta(new JSONObject((Reader)new AsciiReader(jsonBlobStream)).asMap());
                            continue block27;
                        }
                        catch (JSONException e) {
                            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                        }
                        finally {
                            Streams.close((Closeable)jsonBlobStream);
                        }
                    }
                }
            }
            retval.setIsCurrentVersion(true);
            return retval;
        }
    }
}

