/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.delete.contextgroup;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.delete.contextgroup.DeleteContextGroupEvent;
import com.openexchange.groupware.delete.contextgroup.DeleteContextGroupListener;
import java.sql.Connection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DeleteContextGroupRegistry {
    private static volatile DeleteContextGroupRegistry INSTANCE;
    private ConcurrentMap<Class<? extends DeleteContextGroupListener>, DeleteContextGroupListener> listeners = new ConcurrentHashMap<Class<? extends DeleteContextGroupListener>, DeleteContextGroupListener>();

    public static DeleteContextGroupRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DeleteContextGroupRegistry();
        }
        return INSTANCE;
    }

    static void releaseInstance() {
        INSTANCE.cleanup();
        INSTANCE = null;
    }

    private DeleteContextGroupRegistry() {
    }

    public boolean registerDeleteContextGroupListener(DeleteContextGroupListener listener) {
        return this.listeners.putIfAbsent(listener.getClass(), listener) != null;
    }

    public boolean unregisterDeleteContextGroupListener(DeleteContextGroupListener listener) {
        return this.listeners.remove(listener.getClass()) != null;
    }

    public void fireDeleteContextGroupEvent(DeleteContextGroupEvent event, Connection readConnection, Connection writeConnection) throws OXException {
        for (Class listener : this.listeners.keySet()) {
            ((DeleteContextGroupListener)this.listeners.get(listener)).deletePerformed(event, readConnection, writeConnection);
        }
    }

    private void cleanup() {
        this.listeners.clear();
    }
}

