/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.internal;

import com.openexchange.i18n.I18nService;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class GroupI18nNamesService {
    private static final GroupI18nNamesService INSTANCE = new GroupI18nNamesService();
    private final Map<String, String> i18nNames;
    private final Map<Locale, I18nService> services = new ConcurrentHashMap<Locale, I18nService>();
    private final Set<String> identifiers = new HashSet<String>(4);

    public static GroupI18nNamesService getInstance() {
        return INSTANCE;
    }

    private GroupI18nNamesService() {
        this.i18nNames = new ConcurrentHashMap<String, String>(24, 0.9f, 1);
        this.initIdentifiers();
    }

    private void initIdentifiers() {
        this.identifiers.add("All users");
        this.identifiers.add("Standard group");
    }

    public void addService(I18nService service) {
        this.services.put(service.getLocale(), service);
        this.i18nNames.clear();
    }

    public void removeService(I18nService service) {
        this.services.remove(service.getLocale());
        this.i18nNames.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getI18nNames() {
        if (this.i18nNames.isEmpty()) {
            Map<Locale, I18nService> map = this.services;
            synchronized (map) {
                if (this.i18nNames.isEmpty()) {
                    for (String identifier : this.identifiers) {
                        this.i18nNames.put(identifier, identifier);
                    }
                    for (I18nService service : this.services.values()) {
                        for (String identifier : this.identifiers) {
                            String translated = service.getLocalized(identifier);
                            this.i18nNames.put(translated, translated);
                        }
                    }
                }
            }
        }
        return Collections.unmodifiableSet(this.i18nNames.keySet());
    }
}

