/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.virtual.sql;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.internal.Tools;
import com.openexchange.folderstorage.mail.MailFolderType;
import com.openexchange.folderstorage.virtual.osgi.Services;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.event.EventPool;
import com.openexchange.mail.event.PooledEvent;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.LoggerFactory;

public final class Delete {
    private Delete() {
    }

    public static boolean deleteTree(int cid, int tree, int user, Session session) throws OXException {
        DatabaseService databaseService = Services.getService(DatabaseService.class);
        Connection con = databaseService.getWritable(cid);
        boolean modified = false;
        boolean rollback = false;
        try {
            List<String> folderIds = Delete.getFoldersForTree(cid, tree, user, con);
            if (folderIds.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            con.setAutoCommit(false);
            rollback = true;
            for (String folderId : folderIds) {
                Delete.deleteFolder(cid, tree, user, folderId, false, true, session, con);
            }
            modified = true;
            con.commit();
            rollback = false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            if (modified) {
                databaseService.backWritable(cid, con);
            } else {
                databaseService.backWritableAfterReading(cid, con);
            }
        }
    }

    private static List<String> getFoldersForTree(int cid, int tree, int user, Connection con) throws OXException {
        LinkedList<String> linkedList;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT folderId FROM virtualTree WHERE cid = ? AND tree = ? AND user = ?");
            stmt.setInt(1, cid);
            stmt.setInt(2, tree);
            stmt.setInt(3, user);
            rs = stmt.executeQuery();
            if (rs.next()) break block6;
            List<String> list = Collections.emptyList();
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return list;
        }
        try {
            LinkedList<String> folderIds = new LinkedList<String>();
            do {
                folderIds.add(rs.getString(1));
            } while (rs.next());
            linkedList = folderIds;
        }
        catch (SQLException e) {
            try {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return linkedList;
    }

    public static void deleteFolder(int cid, int tree, int user, String folderId, boolean backup, Session session) throws OXException {
        DatabaseService databaseService = Services.getService(DatabaseService.class);
        Connection con = databaseService.getWritable(cid);
        boolean rollback = false;
        try {
            con.setAutoCommit(false);
            rollback = true;
            Delete.deleteFolder(cid, tree, user, folderId, backup, session, con);
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            databaseService.backWritable(cid, con);
        }
    }

    public static void deleteFolder(int cid, int tree, int user, String folderId, boolean backup, Session session, Connection con) throws OXException {
        Delete.deleteFolder(cid, tree, user, folderId, backup, false, session, con);
    }

    private static void deleteFolder(int cid, int tree, int user, String folderId, boolean backup, boolean force, Session session, Connection con) throws OXException {
        int pos;
        if (null == con) {
            Delete.deleteFolder(cid, tree, user, folderId, backup, session);
            return;
        }
        PreparedStatement stmt = null;
        if (!force) {
            ResultSet rs;
            block45: {
                block44: {
                    rs = null;
                    stmt = con.prepareStatement("SELECT shadow FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
                    int pos2 = 1;
                    stmt.setInt(pos2++, cid);
                    stmt.setInt(pos2++, tree);
                    stmt.setInt(pos2++, user);
                    stmt.setString(pos2, folderId);
                    rs = stmt.executeQuery();
                    if (rs.next()) break block44;
                    DBUtils.closeSQLStuff(rs, stmt);
                    rs = null;
                    stmt = null;
                    return;
                }
                try {
                    String shadow = rs.getString(1);
                    if (!"default".equals(shadow)) break block45;
                    throw FolderExceptionErrorMessage.FOLDER_NOT_DELETEABLE.create(folderId, user, cid);
                }
                catch (SQLException e) {
                    try {
                        throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeSQLStuff(rs, stmt);
                        rs = null;
                        stmt = null;
                        throw throwable;
                    }
                }
            }
            DBUtils.closeSQLStuff(rs, stmt);
            rs = null;
            stmt = null;
        }
        if (backup) {
            int pos3;
            try {
                stmt = con.prepareStatement("INSERT INTO virtualBackupTree SELECT * FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
                pos3 = 1;
                stmt.setInt(pos3++, cid);
                stmt.setInt(pos3++, tree);
                stmt.setInt(pos3++, user);
                stmt.setString(pos3, folderId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
            try {
                stmt = con.prepareStatement("INSERT INTO virtualBackupPermission SELECT * FROM virtualPermission WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
                pos3 = 1;
                stmt.setInt(pos3++, cid);
                stmt.setInt(pos3++, tree);
                stmt.setInt(pos3++, user);
                stmt.setString(pos3, folderId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
            try {
                stmt = con.prepareStatement("INSERT INTO virtualBackupSubscription SELECT * FROM virtualSubscription WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
                pos3 = 1;
                stmt.setInt(pos3++, cid);
                stmt.setInt(pos3++, tree);
                stmt.setInt(pos3++, user);
                stmt.setString(pos3, folderId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
        }
        try {
            stmt = con.prepareStatement("DELETE FROM virtualSubscription WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        try {
            stmt = con.prepareStatement("DELETE FROM virtualPermission WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        try {
            stmt = con.prepareStatement("DELETE FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        if (null != session) {
            boolean postEvent;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            boolean bl = postEvent = null == service ? true : service.getBoolProperty("com.openexchange.folderstorage.postEASFolderEvents", true);
            if (postEvent) {
                try {
                    if (MailFolderType.getInstance().servesFolderId(folderId)) {
                        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folderId);
                        Delete.postEvent(argument.getAccountId(), argument.getFullname(), false, true, false, session);
                    } else {
                        ServerSession serverSession = ServerSessionAdapter.valueOf(session);
                        new EventClient(serverSession).delete(new OXFolderAccess(con, serverSession.getContext()).getFolderObject(Delete.unsignedInt(folderId)));
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(Delete.class).error("", (Throwable)e);
                }
            }
        }
    }

    private static void postEvent(int accountId, String fullname, boolean contentRelated, boolean immediateDelivery, boolean async, Session session) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(session.getContextId(), session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullname), contentRelated, immediateDelivery, true, session).setAsync(async));
    }

    private static int unsignedInt(String sInteger) {
        return Tools.getUnsignedInteger(sInteger);
    }
}

