/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook.sql;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.outlook.osgi.Services;
import com.openexchange.folderstorage.outlook.sql.Delete;
import com.openexchange.folderstorage.outlook.sql.Insert;
import com.openexchange.folderstorage.outlook.sql.Utility;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public final class Update {
    private static final String SQL_UPDATE_LM = "UPDATE virtualTree SET lastModified = ?, modifiedBy = ? WHERE cid = ? AND tree = ? AND user = ? AND folderId = ? AND lastModified IS NOT NULL";
    private static final String SQL_UPDATE_PARENT = "UPDATE virtualTree SET parentId = ? WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_UPDATE_ID = "UPDATE virtualTree SET folderId = ? WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_UPDATE_NAME = "UPDATE virtualTree SET name = ? WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";

    private Update() {
    }

    public static void updateIds(int cid, int tree, int user, String newId, String oldId, String delim) throws OXException {
        Connection con;
        DatabaseService databaseService = Utility.getDatabaseService();
        try {
            con = databaseService.getWritable(cid);
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        try {
            Update.updateIds(cid, tree, user, newId, oldId, delim, con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            databaseService.backWritable(cid, con);
        }
    }

    public static void updateIds(int cid, int tree, int user, String newId, String oldId, String delim, Connection con) throws OXException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("UPDATE virtualTree SET parentId = ? WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?");
            stmt.setString(1, newId);
            stmt.setInt(2, cid);
            stmt.setInt(3, tree);
            stmt.setInt(4, user);
            stmt.setString(5, oldId);
            stmt.executeUpdate();
            DBUtils.closeSQLStuff(stmt);
            StringBuilder tmp = new StringBuilder();
            String prefix = tmp.append(oldId).append(delim).toString();
            stmt = con.prepareStatement("SELECT parentId FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND SUBSTRING(parentId,1," + prefix.length() + ") = ?");
            stmt.setInt(1, cid);
            stmt.setInt(2, tree);
            stmt.setInt(3, user);
            stmt.setString(4, prefix);
            rs = stmt.executeQuery();
            if (rs.next()) {
                HashMap<String, String> parentIds = new HashMap<String, String>();
                do {
                    String oldS = rs.getString(1);
                    String tail = oldS.substring(prefix.length() + 1);
                    tmp.setLength(0);
                    String newS = tmp.append(newId).append(delim).append(tail).toString();
                    parentIds.put(newS, oldS);
                } while (rs.next());
                DBUtils.closeSQLStuff(rs, stmt);
                stmt = con.prepareStatement("UPDATE virtualTree SET parentId = ? WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?");
                for (Map.Entry entry : parentIds.entrySet()) {
                    stmt.setString(1, (String)entry.getKey());
                    stmt.setInt(2, cid);
                    stmt.setInt(3, tree);
                    stmt.setInt(4, user);
                    stmt.setString(5, (String)entry.getValue());
                    stmt.addBatch();
                    Update.postChangedId((String)entry.getValue(), user, cid);
                }
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                Utility.debugSQL(stmt);
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }

    public static void updateFolder(int cid, int tree, int user, Folder folder) throws OXException {
        Connection con;
        DatabaseService databaseService = Utility.getDatabaseService();
        try {
            con = databaseService.getWritable(cid);
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        try {
            if (Delete.deleteFolder(cid, tree, user, folder.getID(), false, false, con)) {
                Insert.insertFolder(cid, tree, user, folder, con);
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            databaseService.backWritable(cid, con);
        }
    }

    public static void updateLastModified(int cid, int tree, int user, String folderId, long lastModified) throws OXException {
        Connection con;
        DatabaseService databaseService = Utility.getDatabaseService();
        try {
            con = databaseService.getWritable(cid);
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        try {
            Update.updateLastModified(cid, tree, user, folderId, lastModified, con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            databaseService.backWritable(cid, con);
        }
    }

    public static void updateLastModified(int cid, int tree, int user, String folderId, long lastModified, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL_UPDATE_LM);
            int pos = 1;
            stmt.setLong(pos++, lastModified);
            stmt.setInt(pos++, user);
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            Utility.debugSQL(stmt);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    public static void updateParent(int cid, int tree, int user, String folderId, String parentId, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL_UPDATE_PARENT);
            int pos = 1;
            stmt.setString(pos++, parentId);
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            Utility.debugSQL(stmt);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    public static void updateId(int cid, int tree, int user, String folderId, String newFolderId, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL_UPDATE_ID);
            int pos = 1;
            stmt.setString(pos++, newFolderId);
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            Utility.debugSQL(stmt);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    public static void updateName(int cid, int tree, int user, String folderId, String name, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL_UPDATE_NAME);
            int pos = 1;
            stmt.setString(pos++, name);
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            Utility.debugSQL(stmt);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private static void postChangedId(String folderId, int userId, int contextId) {
        EventAdmin eventAdmin = Services.getService(EventAdmin.class);
        if (null != eventAdmin) {
            HashMap<String, Object> properties = new HashMap<String, Object>(6);
            properties.put("com.openexchange.folderstorage.context", contextId);
            properties.put("com.openexchange.folderstorage.user", userId);
            properties.put("com.openexchange.folderstorage.content-related", Boolean.FALSE);
            properties.put("com.openexchange.folderstorage.folder", folderId);
            properties.put("com.openexchange.folderstorage.immediately", Boolean.TRUE);
            Event event = new Event("com/openexchange/folderstorage", properties);
            eventAdmin.postEvent(event);
        }
    }
}

