/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.mail;

import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailFolderType
implements FolderType {
    private static final Logger LOG = LoggerFactory.getLogger(MailFolderType.class);
    private static final int LEN = "default".length();
    private static final MailFolderType instance = new MailFolderType();
    private static final String PRIVATE_FOLDER_ID = String.valueOf(1);

    public static MailFolderType getInstance() {
        return instance;
    }

    private MailFolderType() {
    }

    @Override
    public boolean servesTreeId(String treeId) {
        return FolderStorage.REAL_TREE_ID.equals(treeId);
    }

    @Override
    public boolean servesFolderId(String folderId) {
        int index;
        if (null == folderId) {
            return false;
        }
        if (!folderId.startsWith("default")) {
            return false;
        }
        int len = folderId.length();
        int separator = 47;
        for (index = LEN; index < len && folderId.charAt(index) != '/'; ++index) {
        }
        if (index != LEN) {
            try {
                Integer.parseInt(folderId.substring(LEN, index));
            }
            catch (NumberFormatException e) {
                IllegalArgumentException err = new IllegalArgumentException("Mail account is not a number: " + folderId);
                err.initCause(e);
                LOG.warn("Ignoring invalid folder identifier", (Throwable)err);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean servesParentId(String folderId) {
        int index;
        if (null == folderId) {
            return false;
        }
        if (PRIVATE_FOLDER_ID.equals(folderId)) {
            return true;
        }
        if (!folderId.startsWith("default")) {
            return false;
        }
        int len = folderId.length();
        int separator = 47;
        for (index = LEN; index < len && folderId.charAt(index) != '/'; ++index) {
        }
        if (index != LEN) {
            try {
                Integer.parseInt(folderId.substring(LEN, index));
            }
            catch (NumberFormatException e) {
                IllegalArgumentException err = new IllegalArgumentException("Mail account is not a number: " + folderId);
                err.initCause(e);
                LOG.error("", (Throwable)err);
                return false;
            }
        }
        return true;
    }
}

