/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.event.impl;

import com.openexchange.server.services.ServerServiceRegistry;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginEvent {
    private static final Logger LOG = LoggerFactory.getLogger(LoginEvent.class);
    public static final String TOPIC = "com/openexchange/login";
    private static final String USER_KEY = "USER";
    private static final String CONTEXT_KEY = "CONTEXT";
    private static final String SESSION_KEY = "SESSION";
    private final int userId;
    private final int contextId;
    private final String sessionId;

    public LoginEvent(int userId, int contextId, String sessionId) {
        this.userId = userId;
        this.contextId = contextId;
        this.sessionId = sessionId;
    }

    public LoginEvent(Event event) {
        if (!TOPIC.equals(event.getTopic())) {
            throw new IllegalArgumentException("Can only handle events with topic com/openexchange/login");
        }
        this.userId = (Integer)event.getProperty(USER_KEY);
        this.contextId = (Integer)event.getProperty(CONTEXT_KEY);
        this.sessionId = (String)event.getProperty(SESSION_KEY);
    }

    public int getUserId() {
        return this.userId;
    }

    public int getContextId() {
        return this.contextId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void post() {
        EventAdmin eventAdmin = ServerServiceRegistry.getInstance().getService(EventAdmin.class);
        if (eventAdmin == null) {
            LOG.debug("Event Admin is disabled, so skipping LoginEvent");
            return;
        }
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ((Dictionary)ht).put(USER_KEY, this.userId);
        ((Dictionary)ht).put(CONTEXT_KEY, this.contextId);
        ((Dictionary)ht).put(SESSION_KEY, this.sessionId);
        Event event = new Event(TOPIC, ht);
        eventAdmin.postEvent(event);
    }
}

