/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.data.conversion.ical;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public class ConversionWarning
extends OXException {
    private static final long serialVersionUID = -7593693106963732974L;
    private final int index;

    @Deprecated
    public ConversionWarning(int index, String message, Object ... args) {
        super(9999, "An error occurred inside the server which prevented it from fulfilling the request.", null, new Object[0]);
        this.addCategory(Category.CATEGORY_ERROR);
        this.setLogMessage(message, args);
        this.setPrefix("ICA");
        this.index = index;
    }

    @Deprecated
    public String getFormattedMessage() {
        return this.getLogMessage();
    }

    public ConversionWarning(int index, Code code, Object ... args) {
        this(index, code, null, args);
    }

    public ConversionWarning(int index, Code code, Throwable cause, Object ... args) {
        super(code.getNumber(), ConversionWarning.isDisplay(code) ? code.getMessage() : "An error occurred inside the server which prevented it from fulfilling the request.", cause, ConversionWarning.isDisplay(code) ? args : new Object[]{});
        if (!ConversionWarning.isDisplay(code)) {
            this.setLogMessage(code.getMessage(), args);
        }
        this.addCategory(code.getCategory());
        this.setPrefix(code.getPrefix());
        this.index = index;
    }

    public ConversionWarning(int index, OXException cause) {
        super(cause);
        this.index = index;
    }

    private static boolean isDisplay(Code code) {
        return code.getCategory().getLogLevel().implies(LogLevel.DEBUG);
    }

    public int getIndex() {
        return this.index;
    }

    public static enum Code implements DisplayableOXExceptionCode
    {
        INVALID_STATUS("Unable to convert task status \"%1$s\".", CATEGORY_USER_INPUT, 1, "Unable to convert task status \"%1$s\"."),
        INVALID_PRIORITY("Unable to convert task priority %d.", CATEGORY_USER_INPUT, 2, "Unable to convert task priority %d."),
        CANT_CREATE_RRULE("Can not create recurrence rule: %s", CATEGORY_ERROR, 3, null),
        INVALID_SESSION("Invalid session given to implementation \"%1$s\".", CATEGORY_ERROR, 4, null),
        CANT_GENERATE_UID("Can not generate uid.", CATEGORY_ERROR, 5, null),
        WRITE_PROBLEM("Problem writing to stream.", CATEGORY_CONNECTIVITY, 6, null),
        VALIDATION("Validation of calendar failed.", CATEGORY_ERROR, 7, null),
        CANT_RESOLVE_USER("Can not resolve user: %d", CATEGORY_ERROR, 8, null),
        PARSE_EXCEPTION("Parsing error parsing ical: %s", CATEGORY_USER_INPUT, 9, "Parsing error parsing ical: %s"),
        UNKNOWN_CLASS("Unknown Class: %1$s", CATEGORY_USER_INPUT, 10, "Unknown Class: %1$s"),
        CLASS_CONFIDENTIAL("Cowardly refusing to convert confidential classified objects.", CATEGORY_USER_INPUT, 11, "Cowardly refusing to convert confidential classified objects."),
        MISSING_DTSTART("Missing DTSTART", CATEGORY_USER_INPUT, 12, "Missing DTSTART"),
        CANT_RESOLVE_RESOURCE("Can not resolve resource: %1$s", CATEGORY_ERROR, 13, null),
        PRIVATE_APPOINTMENTS_HAVE_NO_PARTICIPANTS("Private appointments can not have attendees. Removing attendees and accepting appointment anyway.", CATEGORY_USER_INPUT, 14, "Private appointments can not have attendees. Removing attendees and accepting appointment anyway."),
        BYMONTH_NOT_SUPPORTED("Not supported recurrence pattern: BYMONTH", CATEGORY_USER_INPUT, 15, "Not supported recurrence pattern: BYMONTH"),
        DOES_NOT_LOOK_LIKE_ICAL_FILE("This does not look like an iCal file. Please check the file.", CATEGORY_USER_INPUT, 16, "This does not look like an iCal file. Please check the file."),
        EMPTY_CLASS("Empty \"CLASS\" element.", CATEGORY_USER_INPUT, 17, "Empty \"CLASS\" element."),
        INSUFFICIENT_INFORMATION("Insufficient information for parsing/writing this element.", CATEGORY_ERROR, 18, null),
        UNEXPECTED_ERROR("An error occurred: %1$s", CATEGORY_ERROR, 19, null),
        TRUNCATION_WARNING("Element truncated: %s", CATEGORY_TRUNCATED, 20, "Element truncated: %s"),
        CANT_RESOLVE_GROUP("Can not resolve group: %1$s", CATEGORY_ERROR, 21, null);

        private final String message;
        private final Category category;
        private final int number;
        private String displayMessage;

        private Code(String message, Category category, int number, String displayMessage) {
            this.message = message;
            this.category = category;
            this.number = number;
            this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
        }

        public String getPrefix() {
            return "ICA";
        }

        public String getMessage() {
            return this.message;
        }

        public Category getCategory() {
            return this.category;
        }

        public int getNumber() {
            return this.number;
        }

        public boolean equals(OXException e) {
            return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
        }

        public OXException create() {
            return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
        }

        public OXException create(Object ... args) {
            return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
        }

        public OXException create(Throwable cause, Object ... args) {
            return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
        }

        public String getDisplayMessage() {
            return this.displayMessage;
        }
    }
}

