/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.authentication.service;

import com.openexchange.authentication.Authenticated;
import com.openexchange.authentication.AuthenticationService;
import com.openexchange.authentication.BasicAuthenticationService;
import com.openexchange.authentication.LoginInfo;
import com.openexchange.exception.OXException;
import com.openexchange.server.ServiceExceptionCode;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public final class Authentication {
    private static final AtomicReference<AuthenticationService> SERVICE_REF = new AtomicReference();
    private static final AtomicReference<BasicAuthenticationService> BASIC_SERVICE_REF = new AtomicReference();

    private Authentication() {
    }

    public static Authenticated login(final String login, final String pass, final Map<String, Object> properties) throws OXException {
        AuthenticationService auth = SERVICE_REF.get();
        if (null == auth) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{AuthenticationService.class.getName()});
        }
        return auth.handleLoginInfo(new LoginInfo(){

            public String getPassword() {
                return pass;
            }

            public String getUsername() {
                return login;
            }

            public Map<String, Object> getProperties() {
                return properties;
            }
        });
    }

    public static Authenticated autologin(final String login, final String pass, final Map<String, Object> properties) throws OXException {
        AuthenticationService auth = SERVICE_REF.get();
        if (null == auth) {
            return null;
        }
        return auth.handleAutoLoginInfo(new LoginInfo(){

            public String getPassword() {
                return pass;
            }

            public String getUsername() {
                return login;
            }

            public Map<String, Object> getProperties() {
                return properties;
            }
        });
    }

    public static AuthenticationService getService() {
        return SERVICE_REF.get();
    }

    public static boolean setService(AuthenticationService service) {
        return SERVICE_REF.compareAndSet(null, service);
    }

    public static boolean dropService(AuthenticationService service) {
        return SERVICE_REF.compareAndSet(service, null);
    }

    public static BasicAuthenticationService getBasicService() {
        return BASIC_SERVICE_REF.get();
    }

    public static void setBasicService(BasicAuthenticationService service) {
        BASIC_SERVICE_REF.set(service);
    }
}

