/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.api2;

import com.openexchange.api2.FolderSQLInterface;
import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.cache.impl.FolderQueryCacheManager;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbFolderSQLInterface
implements FolderSQLInterface {
    private static final int[] VIRTUAL_IDS = new int[]{11, 12, 13, 14};
    private static final Logger LOG = LoggerFactory.getLogger(RdbFolderSQLInterface.class);
    private final int userId;
    private final int[] groups;
    private final ServerSession session;
    private final Context ctx;
    private final User user;
    private final UserPermissionBits userPermissionBits;
    private final OXFolderAccess oxfolderAccess;

    private static final int getNonTreeVisibleNum(int module) {
        switch (module) {
            case 2: {
                return FolderQuery.NON_TREE_VISIBLE_CALENDAR.queryNum;
            }
            case 1: {
                return FolderQuery.NON_TREE_VISIBLE_TASK.queryNum;
            }
            case 3: {
                return FolderQuery.NON_TREE_VISIBLE_CONTACT.queryNum;
            }
            case 8: {
                return FolderQuery.NON_TREE_VISIBLE_INFOSTORE.queryNum;
            }
        }
        return -1;
    }

    private static final TIntSet newNonTreeVisibleModules() {
        TIntHashSet retval = new TIntHashSet(4);
        retval.add(2);
        retval.add(1);
        retval.add(3);
        retval.add(8);
        return retval;
    }

    public RdbFolderSQLInterface(ServerSession session) {
        this(session, null);
    }

    public RdbFolderSQLInterface(ServerSession session, OXFolderAccess oxfolderAccess) {
        this.session = session;
        this.ctx = session.getContext();
        this.userPermissionBits = session.getUserPermissionBits();
        this.user = session.getUser();
        this.userId = this.user.getId();
        this.groups = this.user.getGroups();
        this.oxfolderAccess = oxfolderAccess == null ? new OXFolderAccess(session.getContext()) : oxfolderAccess;
    }

    @Override
    public FolderObject getUsersInfostoreFolder() throws OXException {
        if (!this.userPermissionBits.hasInfostore()) {
            throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(this.session.getUserId(), OXFolderUtility.folderModule2String(8), this.ctx.getContextId());
        }
        return this.oxfolderAccess.getDefaultFolder(this.userId, 8);
    }

    @Override
    public FolderObject getFolderById(int id) throws OXException {
        int pos = Arrays.binarySearch(VIRTUAL_IDS, id);
        if (pos >= 0) {
            FolderObject fo = FolderObject.createVirtualFolderObject(id, FolderObject.getFolderString(id, this.session.getUser().getLocale()), 5, true, 5);
            if (3 == pos) {
                fo.setParentFolderID(9);
            } else {
                fo.setParentFolderID(2);
            }
            if (FolderCacheManager.isInitialized()) {
                FolderCacheManager.getInstance().putFolderObject(fo, this.ctx);
            }
            return fo;
        }
        try {
            FolderObject fo = this.oxfolderAccess.getFolderObject(id);
            EffectivePermission perm = fo.getEffectiveUserPermission(this.userId, this.userPermissionBits);
            if (!perm.isFolderVisible()) {
                if (!perm.getUnderlyingPermission().isFolderVisible()) {
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(id, this.session.getUserId(), this.ctx.getContextId());
                }
                throw OXFolderExceptionCode.NOT_VISIBLE.create(id, this.session.getUserId(), this.ctx.getContextId());
            }
            if (fo.isShared(this.session.getUserId()) && !this.userPermissionBits.hasFullSharedFolderAccess()) {
                throw OXFolderExceptionCode.NO_SHARED_FOLDER_ACCESS.create(this.session.getUserId(), id, this.ctx.getContextId());
            }
            if (Arrays.binarySearch(this.userPermissionBits.getAccessibleModules(), fo.getModule()) < 0) {
                throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(this.session.getUserId(), OXFolderUtility.folderModule2String(fo.getModule()), this.ctx.getContextId());
            }
            return fo;
        }
        catch (RuntimeException e) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, this.ctx.getContextId());
        }
    }

    @Override
    public FolderObject saveFolderObject(FolderObject folderobjectArg, Date clientLastModified) throws OXException {
        if (!(folderobjectArg.getType() != 2 || this.userPermissionBits.hasFullPublicFolderAccess() || folderobjectArg.containsModule() && folderobjectArg.getModule() == 8)) {
            throw OXFolderExceptionCode.NO_PUBLIC_FOLDER_WRITE_ACCESS.create(this.session.getUserId(), folderobjectArg.getObjectID(), this.ctx.getContextId());
        }
        FolderObject folderobject = folderobjectArg;
        boolean insert = !folderobject.containsObjectID() || folderobject.getObjectID() == -1;
        OXFolderManager manager = OXFolderManager.getInstance((Session)this.session, this.oxfolderAccess);
        try {
            if (insert) {
                if (!folderobject.containsParentFolderID()) {
                    throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("folder_id", this.ctx.getContextId());
                }
                int parentFolderID = folderobject.getParentFolderID();
                if (parentFolderID == 2 && !this.userPermissionBits.hasFullPublicFolderAccess()) {
                    throw OXFolderExceptionCode.NO_PUBLIC_FOLDER_WRITE_ACCESS.create(this.session.getUserId(), folderobjectArg.getObjectID(), this.ctx.getContextId());
                }
                int[] virtualIDs = new int[]{11, 12, 13, 14};
                if (Arrays.binarySearch(virtualIDs, parentFolderID) > -1) {
                    throw OXFolderExceptionCode.NO_CREATE_SUBFOLDER_PERMISSION.create(this.session.getUserId(), parentFolderID, this.ctx.getContextId());
                }
                FolderObject parentFolder = this.oxfolderAccess.getFolderObject(parentFolderID);
                EffectivePermission parentalEffectivePerm = parentFolder.getEffectiveUserPermission(this.userId, this.userPermissionBits);
                if (!parentalEffectivePerm.hasModuleAccess(folderobject.getModule())) {
                    throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(this.session.getUserId(), OXFolderUtility.folderModule2String(folderobject.getModule()), this.ctx.getContextId());
                }
                if (!parentalEffectivePerm.isFolderVisible()) {
                    if (!parentalEffectivePerm.getUnderlyingPermission().isFolderVisible()) {
                        throw OXFolderExceptionCode.NOT_VISIBLE.create(parentFolderID, this.session.getUserId(), this.ctx.getContextId());
                    }
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(parentFolderID, this.session.getUserId(), this.ctx.getContextId());
                }
                if (!parentalEffectivePerm.canCreateSubfolders()) {
                    if (!parentalEffectivePerm.getUnderlyingPermission().canCreateSubfolders()) {
                        throw OXFolderExceptionCode.NO_CREATE_SUBFOLDER_PERMISSION.create(this.session.getUserId(), parentFolderID, this.ctx.getContextId());
                    }
                    throw OXFolderExceptionCode.NO_CREATE_SUBFOLDER_PERMISSION.create(this.session.getUserId(), parentFolderID, this.ctx.getContextId());
                }
                folderobject.setType(this.getFolderType(parentFolderID));
                long createTime = System.currentTimeMillis();
                manager.createFolder(folderobject, false, createTime);
            } else {
                folderobject.fill(this.oxfolderAccess.getFolderObject(folderobject.getObjectID()), false);
                if (!folderobject.exists(this.ctx)) {
                    throw OXFolderExceptionCode.NOT_EXISTS.create(folderobject.getObjectID(), this.ctx.getContextId());
                }
                if (clientLastModified != null && this.oxfolderAccess.getFolderLastModified(folderobject.getObjectID()).after(clientLastModified)) {
                    throw OXFolderExceptionCode.CONCURRENT_MODIFICATION.create(folderobject.getObjectID(), this.ctx.getContextId());
                }
                EffectivePermission effectivePerm = this.oxfolderAccess.getFolderPermission(folderobject.getObjectID(), this.userId, this.userPermissionBits);
                if (!effectivePerm.hasModuleAccess(folderobject.getModule())) {
                    throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(this.session.getUserId(), OXFolderUtility.folderModule2String(folderobject.getModule()), this.ctx.getContextId());
                }
                if (!effectivePerm.isFolderVisible()) {
                    if (!effectivePerm.getUnderlyingPermission().isFolderVisible()) {
                        throw OXFolderExceptionCode.NOT_VISIBLE.create(folderobject.getObjectID(), this.session.getUserId(), this.ctx.getContextId());
                    }
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(folderobject.getObjectID(), this.session.getUserId(), this.ctx.getContextId());
                }
                if (!effectivePerm.isFolderAdmin()) {
                    if (!effectivePerm.getUnderlyingPermission().isFolderAdmin()) {
                        throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(this.session.getUserId(), folderobject.getObjectID(), this.ctx.getContextId());
                    }
                    throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(this.session.getUserId(), folderobject.getObjectID(), this.ctx.getContextId());
                }
                long lastModfified = System.currentTimeMillis();
                manager.updateFolder(folderobject, false, false, lastModfified);
                CacheFolderStorage.getInstance().removeSingleFromCache(Collections.singletonList(Integer.toString(folderobject.getObjectID())), FolderStorage.REAL_TREE_ID, this.userId, this.session, false);
                CacheFolderStorage.getInstance().removeSingleFromCache(Collections.singletonList(Integer.toString(folderobject.getParentFolderID())), FolderStorage.REAL_TREE_ID, this.userId, this.session, false);
            }
            return folderobject;
        }
        catch (RuntimeException e) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, this.ctx.getContextId());
        }
    }

    @Override
    public int deleteFolderObject(FolderObject folderobject, Date clientLastModified) throws OXException {
        try {
            int folderId = folderobject.getObjectID();
            int pos = Arrays.binarySearch(VIRTUAL_IDS, folderId);
            if (pos >= 0) {
                FolderObject fo = FolderObject.createVirtualFolderObject(folderId, FolderObject.getFolderString(folderId, this.session.getUser().getLocale()), 5, true, 5);
                if (3 == pos) {
                    fo.setParentFolderID(9);
                } else {
                    fo.setParentFolderID(2);
                }
                if (FolderCacheManager.isInitialized()) {
                    FolderCacheManager.getInstance().putFolderObject(fo, this.ctx);
                }
                folderobject.fill(fo);
            } else {
                folderobject.fill(this.oxfolderAccess.getFolderObject(folderId), false);
            }
            int module = folderobject.getModule();
            if (2 == folderobject.getType() && 8 != module && !this.userPermissionBits.hasFullPublicFolderAccess()) {
                throw OXFolderExceptionCode.NO_PUBLIC_FOLDER_WRITE_ACCESS.create(this.session.getUserId(), folderobject.getObjectID(), this.ctx.getContextId());
            }
            if (!folderobject.exists(this.ctx)) {
                throw OXFolderExceptionCode.NOT_EXISTS.create(folderId, this.ctx.getContextId());
            }
            if (clientLastModified != null && this.oxfolderAccess.getFolderLastModified(folderId).after(clientLastModified)) {
                throw OXFolderExceptionCode.CONCURRENT_MODIFICATION.create(folderId, this.ctx.getContextId());
            }
            EffectivePermission effectivePerm = folderobject.getEffectiveUserPermission(this.userId, this.userPermissionBits);
            if (!effectivePerm.hasModuleAccess(module)) {
                throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(this.session.getUserId(), OXFolderUtility.folderModule2String(module), this.ctx.getContextId());
            }
            if (!effectivePerm.isFolderVisible()) {
                if (!effectivePerm.getUnderlyingPermission().isFolderVisible()) {
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(folderId, this.session.getUserId(), this.ctx.getContextId());
                }
                throw OXFolderExceptionCode.NOT_VISIBLE.create(folderId, this.session.getUserId(), this.ctx.getContextId());
            }
            if (!effectivePerm.isFolderAdmin()) {
                if (!effectivePerm.getUnderlyingPermission().isFolderAdmin()) {
                    throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(this.session.getUserId(), folderobject.getObjectID(), this.ctx.getContextId());
                }
                throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(this.session.getUserId(), folderobject.getObjectID(), this.ctx.getContextId());
            }
            long lastModified = System.currentTimeMillis();
            OXFolderManager.getInstance((Session)this.session, this.oxfolderAccess).deleteFolder(folderobject, false, lastModified);
            CacheFolderStorage.getInstance().removeSingleFromCache(Collections.singletonList(Integer.toString(folderId)), FolderStorage.REAL_TREE_ID, this.userId, this.session, true);
            CacheFolderStorage.getInstance().removeSingleFromCache(Collections.singletonList(Integer.toString(folderobject.getParentFolderID())), FolderStorage.REAL_TREE_ID, this.userId, this.session, false);
            return folderId;
        }
        catch (RuntimeException e) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, this.ctx.getContextId());
        }
    }

    private static final void loadNonTreeVisibleFoldersIntoQueryCache(ServerSession session, Context ctx, UserPermissionBits userPermissionBits) throws SearchIteratorException, OXException {
        User u = session.getUser();
        int userId = u.getId();
        int[] groups = u.getGroups();
        Queue<FolderObject> q = ((FolderObjectIterator)OXFolderIteratorSQL.getAllVisibleFoldersNotSeenInTreeView(userId, groups, userPermissionBits, ctx)).asQueue();
        int size = q.size();
        Iterator iter = q.iterator();
        TIntSet stdModules = RdbFolderSQLInterface.newNonTreeVisibleModules();
        int prevModule = -1;
        LinkedList<Integer> cacheQueue = new LinkedList<Integer>();
        for (int i = 0; i < size; ++i) {
            FolderObject f = (FolderObject)iter.next();
            if (prevModule != f.getModule()) {
                FolderQueryCacheManager.getInstance().putFolderQuery(RdbFolderSQLInterface.getNonTreeVisibleNum(prevModule), cacheQueue, session, false);
                prevModule = f.getModule();
                stdModules.remove(prevModule);
                cacheQueue.clear();
            }
            cacheQueue.add(f.getObjectID());
        }
        FolderQueryCacheManager.getInstance().putFolderQuery(RdbFolderSQLInterface.getNonTreeVisibleNum(prevModule), cacheQueue, session, false);
        int setSize = stdModules.size();
        TIntIterator iter2 = stdModules.iterator();
        int i = setSize;
        while (i-- > 0) {
            FolderQueryCacheManager.getInstance().putFolderQuery(RdbFolderSQLInterface.getNonTreeVisibleNum(iter2.next()), new LinkedList<Integer>(), session, false);
        }
    }

    @Override
    public SearchIterator<FolderObject> getNonTreeVisiblePublicCalendarFolders() throws OXException {
        if (!this.userPermissionBits.hasCalendar()) {
            throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(this.session.getUserId(), OXFolderUtility.folderModule2String(2), this.ctx.getContextId());
        }
        LinkedList<Integer> result = FolderQueryCacheManager.getInstance().getFolderQuery(FolderQuery.NON_TREE_VISIBLE_CALENDAR.queryNum, this.session);
        if (result == null) {
            RdbFolderSQLInterface.loadNonTreeVisibleFoldersIntoQueryCache(this.session, this.ctx, this.userPermissionBits);
            result = FolderQueryCacheManager.getInstance().getFolderQuery(FolderQuery.NON_TREE_VISIBLE_CALENDAR.queryNum, this.session);
        }
        return new FolderObjectIterator(RdbFolderSQLInterface.int2folder(result, this.oxfolderAccess), false);
    }

    @Override
    public SearchIterator<FolderObject> getNonTreeVisiblePublicTaskFolders() throws OXException {
        if (!this.userPermissionBits.hasTask()) {
            throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(this.session.getUserId(), OXFolderUtility.folderModule2String(1), this.ctx.getContextId());
        }
        LinkedList<Integer> result = FolderQueryCacheManager.getInstance().getFolderQuery(FolderQuery.NON_TREE_VISIBLE_TASK.queryNum, this.session);
        if (result == null) {
            RdbFolderSQLInterface.loadNonTreeVisibleFoldersIntoQueryCache(this.session, this.ctx, this.userPermissionBits);
            result = FolderQueryCacheManager.getInstance().getFolderQuery(FolderQuery.NON_TREE_VISIBLE_TASK.queryNum, this.session);
        }
        return new FolderObjectIterator(RdbFolderSQLInterface.int2folder(result, this.oxfolderAccess), false);
    }

    @Override
    public SearchIterator<FolderObject> getNonTreeVisiblePublicContactFolders() throws OXException {
        if (!this.userPermissionBits.hasContact()) {
            throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(this.session.getUserId(), OXFolderUtility.folderModule2String(3), this.ctx.getContextId());
        }
        LinkedList<Integer> result = FolderQueryCacheManager.getInstance().getFolderQuery(FolderQuery.NON_TREE_VISIBLE_CONTACT.queryNum, this.session);
        if (result == null) {
            RdbFolderSQLInterface.loadNonTreeVisibleFoldersIntoQueryCache(this.session, this.ctx, this.userPermissionBits);
            result = FolderQueryCacheManager.getInstance().getFolderQuery(FolderQuery.NON_TREE_VISIBLE_CONTACT.queryNum, this.session);
        }
        return new FolderObjectIterator(RdbFolderSQLInterface.int2folder(result, this.oxfolderAccess), false);
    }

    @Override
    public SearchIterator<FolderObject> getNonTreeVisiblePublicInfostoreFolders() throws OXException {
        if (!this.userPermissionBits.hasInfostore()) {
            throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(this.session.getUserId(), OXFolderUtility.folderModule2String(8), this.ctx.getContextId());
        }
        LinkedList<Integer> result = FolderQueryCacheManager.getInstance().getFolderQuery(FolderQuery.NON_TREE_VISIBLE_INFOSTORE.queryNum, this.session);
        if (result == null) {
            RdbFolderSQLInterface.loadNonTreeVisibleFoldersIntoQueryCache(this.session, this.ctx, this.userPermissionBits);
            result = FolderQueryCacheManager.getInstance().getFolderQuery(FolderQuery.NON_TREE_VISIBLE_INFOSTORE.queryNum, this.session);
        }
        return new FolderObjectIterator(RdbFolderSQLInterface.int2folder(result, this.oxfolderAccess), false);
    }

    @Override
    public SearchIterator<FolderObject> getRootFolderForUser() throws OXException {
        return OXFolderIteratorSQL.getUserRootFoldersIterator(this.userId, this.groups, this.userPermissionBits, this.ctx);
    }

    private final int getFolderType(int folderIdArg) throws OXException {
        int type = -1;
        int folderId = folderIdArg;
        if (folderId == 3) {
            folderId = 1;
            type = 3;
        } else {
            type = folderId == 1 ? 1 : (folderId == 2 || folderId == 15 || folderId == 10 ? 2 : this.oxfolderAccess.getFolderType(folderId));
        }
        return type;
    }

    @Override
    public SearchIterator<FolderObject> getSubfolders(int parentId, Timestamp since) throws OXException {
        try {
            if (parentId == 3 && !this.userPermissionBits.hasFullSharedFolderAccess()) {
                throw OXFolderExceptionCode.NO_SHARED_FOLDER_ACCESS.create(this.session.getUserId(), FolderObject.getFolderString(3, this.user.getLocale()), this.ctx.getContextId());
            }
            if (this.oxfolderAccess.isFolderShared(parentId, this.userId)) {
                return FolderObjectIterator.EMPTY_FOLDER_ITERATOR;
            }
            return OXFolderIteratorSQL.getVisibleSubfoldersIterator(parentId, this.userId, this.groups, this.ctx, this.userPermissionBits, since);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public SearchIterator<FolderObject> getSharedFoldersFrom(int owner, Timestamp since) throws OXException {
        if (!this.userPermissionBits.hasFullSharedFolderAccess()) {
            throw OXFolderExceptionCode.NO_SHARED_FOLDER_ACCESS.create(this.session.getUserId(), this.ctx.getContextId());
        }
        return OXFolderIteratorSQL.getVisibleSharedFolders(this.userId, this.groups, this.userPermissionBits.getAccessibleModules(), owner, this.ctx, since, null);
    }

    @Override
    public SearchIterator<FolderObject> getPathToRoot(int folderId) throws OXException {
        return OXFolderIteratorSQL.getFoldersOnPathToRoot(folderId, this.userId, this.userPermissionBits, this.user.getLocale(), this.ctx);
    }

    @Override
    public SearchIterator<FolderObject> getDeletedFolders(Date since) throws OXException {
        return OXFolderIteratorSQL.getDeletedFoldersSince(since, this.userId, this.groups, this.userPermissionBits.getAccessibleModules(), this.ctx);
    }

    @Override
    public SearchIterator<FolderObject> getModifiedUserFolders(Date since) throws OXException {
        return OXFolderIteratorSQL.getModifiedFoldersSince(since == null ? new Date(0L) : since, this.userId, this.groups, this.userPermissionBits.getAccessibleModules(), false, this.ctx);
    }

    @Override
    public SearchIterator<FolderObject> getAllModifiedFolders(Date since) throws OXException {
        return OXFolderIteratorSQL.getAllModifiedFoldersSince(since == null ? new Date(0L) : since, this.ctx);
    }

    @Override
    public int clearFolder(FolderObject folderobject, Date clientLastModified) throws OXException {
        try {
            int objectID = folderobject.getObjectID();
            int pos = Arrays.binarySearch(VIRTUAL_IDS, objectID);
            if (pos >= 0) {
                FolderObject fo = FolderObject.createVirtualFolderObject(objectID, FolderObject.getFolderString(objectID, this.session.getUser().getLocale()), 5, true, 5);
                if (3 == pos) {
                    fo.setParentFolderID(9);
                } else {
                    fo.setParentFolderID(2);
                }
                if (FolderCacheManager.isInitialized()) {
                    FolderCacheManager.getInstance().putFolderObject(fo, this.ctx);
                }
                folderobject.fill(fo);
            }
            if (folderobject.getType() == 2 && !this.userPermissionBits.hasFullPublicFolderAccess()) {
                throw OXFolderExceptionCode.NO_PUBLIC_FOLDER_WRITE_ACCESS.create(this.session.getUserId(), folderobject.getObjectID(), this.ctx.getContextId());
            }
            if (!folderobject.exists(this.ctx)) {
                throw OXFolderExceptionCode.NOT_EXISTS.create(objectID, this.ctx.getContextId());
            }
            if (clientLastModified != null && this.oxfolderAccess.getFolderLastModified(objectID).after(clientLastModified)) {
                throw OXFolderExceptionCode.CONCURRENT_MODIFICATION.create(objectID, this.ctx.getContextId());
            }
            EffectivePermission effectivePerm = folderobject.getEffectiveUserPermission(this.userId, this.userPermissionBits);
            if (!effectivePerm.hasModuleAccess(folderobject.getModule())) {
                throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(this.session.getUserId(), OXFolderUtility.folderModule2String(folderobject.getModule()), this.ctx.getContextId());
            }
            if (!effectivePerm.isFolderVisible()) {
                if (!effectivePerm.getUnderlyingPermission().isFolderVisible()) {
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(objectID, this.session.getUserId(), this.ctx.getContextId());
                }
                throw OXFolderExceptionCode.NOT_VISIBLE.create(objectID, this.session.getUserId(), this.ctx.getContextId());
            }
            long lastModified = System.currentTimeMillis();
            OXFolderManager.getInstance((Session)this.session, this.oxfolderAccess).clearFolder(folderobject, false, lastModified);
            return objectID;
        }
        catch (RuntimeException e) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, this.ctx.getContextId());
        }
    }

    private static final Queue<FolderObject> int2folder(Queue<Integer> iq, OXFolderAccess oxfolderAccess) {
        LinkedList<FolderObject> retval = new LinkedList<FolderObject>();
        int size = iq.size();
        Iterator iter = iq.iterator();
        for (int i = 0; i < size; ++i) {
            try {
                retval.add(oxfolderAccess.getFolderObject((Integer)iter.next()));
                continue;
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
        return retval;
    }

    private static enum FolderQuery {
        NON_TREE_VISIBLE_CALENDAR(1),
        NON_TREE_VISIBLE_TASK(2),
        NON_TREE_VISIBLE_CONTACT(3),
        NON_TREE_VISIBLE_INFOSTORE(4),
        ROOT_FOLDERS(5);

        final int queryNum;

        private FolderQuery(int queryNum) {
            this.queryNum = queryNum;
        }
    }
}

