/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.request.SimpleRequest;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class ServletRequestAdapter
implements SimpleRequest {
    private final HttpServletRequest req;
    private final HttpServletResponse res;
    private PrintWriter w;
    private Object body;

    public ServletRequestAdapter(HttpServletRequest req, HttpServletResponse res) {
        this.req = req;
        this.res = res;
    }

    @Override
    public String getParameter(String param) {
        return this.req.getParameter(param);
    }

    public Writer getWriter() throws IOException {
        if (this.w == null) {
            this.w = this.res.getWriter();
        }
        return this.w;
    }

    @Override
    public String[] getParameterValues(String param) {
        return Strings.splitByComma((String)this.req.getParameter(param));
    }

    @Override
    public Object getBody() {
        if (null != this.body) {
            return this.body;
        }
        try {
            ServletInputStream input = this.req.getInputStream();
            UnsynchronizedByteArrayOutputStream baos = new UnsynchronizedByteArrayOutputStream(input.available());
            byte[] buf = new byte[512];
            int length = -1;
            while ((length = input.read(buf)) > 0) {
                baos.write(buf, 0, length);
            }
            String characterEncoding = this.req.getCharacterEncoding();
            if (null == characterEncoding) {
                characterEncoding = ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding);
            }
            String body = new String(baos.toByteArray(), Charsets.forName((String)characterEncoding));
            this.body = new JSONObject("{\"data\": " + body + '}').get("data");
            return this.body;
        }
        catch (IOException e) {
            return null;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        Enumeration e = this.req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            b.append(" | ");
            b.append(name);
            b.append(" : ");
            b.append(this.getParameter(name));
            b.append(" | ");
        }
        b.append("BODY: ");
        Object body = this.getBody();
        if (null == body) {
            b.append("No body");
        } else {
            b.append(body);
        }
        return b.toString();
    }
}

