/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.AJAXUtility;
import com.openexchange.ajax.login.HashCalculator;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestImpl;
import com.openexchange.authentication.Cookie;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.java.util.UUIDs;
import com.openexchange.log.LogProperties;
import com.openexchange.login.Interface;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.share.GuestInfo;
import com.openexchange.share.ShareService;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginTools {
    private static final Logger LOG = LoggerFactory.getLogger(LoginTools.class);
    private static final Pattern PATTERN_CRLF = Pattern.compile("\r?\n|(?:%0[aA])?%0[dD]");
    private static final Pattern PATTERN_DSLASH = Pattern.compile("(?:/|%2[fF]){2}");

    private LoginTools() {
    }

    public static String encodeUrl(String s, boolean forAnchor) {
        return AJAXUtility.encodeUrl(s, forAnchor);
    }

    public static String generateRedirectURL(String uiWebPathParam, String shouldStore, String sessionId, String uiWebPath) {
        String retval = uiWebPathParam;
        if (null == retval) {
            retval = uiWebPath;
        }
        retval = PATTERN_CRLF.matcher(retval).replaceAll("");
        retval = PATTERN_DSLASH.matcher(retval).replaceAll("/");
        retval = LoginTools.addFragmentParameter(retval, "session", sessionId);
        if (shouldStore != null) {
            retval = LoginTools.addFragmentParameter(retval, "store", shouldStore);
        }
        return retval;
    }

    public static String addFragmentParameter(String usedUIWebPath, String param, String value) {
        String retval = usedUIWebPath;
        int fragIndex = retval.indexOf(35);
        int questionMarkIndex = retval.indexOf(63, fragIndex);
        String query = "";
        if (questionMarkIndex > 0) {
            query = retval.substring(questionMarkIndex);
            retval = retval.substring(0, questionMarkIndex);
        }
        if (retval.indexOf(35) < 0) {
            return retval + '#' + AJAXUtility.encodeUrl(param) + '=' + AJAXUtility.encodeUrl(value) + query;
        }
        return retval + '&' + AJAXUtility.encodeUrl(param) + '=' + AJAXUtility.encodeUrl(value) + query;
    }

    public static String parseAuthId(HttpServletRequest req, boolean strict) throws OXException {
        return LoginTools.parseParameter(req, "authId", strict, UUIDs.getUnformattedString((UUID)UUID.randomUUID()));
    }

    public static String parseClient(HttpServletRequest req, boolean strict, String defaultClient) throws OXException {
        return LoginTools.parseParameter(req, "client", strict, defaultClient);
    }

    public static String parseToken(HttpServletRequest req) throws OXException {
        return LoginTools.parseParameter(req, "token");
    }

    public static String parseAppSecret(HttpServletRequest req) throws OXException {
        return LoginTools.parseParameter(req, "secret");
    }

    public static String parseRedirectUrl(HttpServletRequest req) throws OXException {
        return LoginTools.parseParameter(req, "redirectUrl", "");
    }

    public static String parseAutoLogin(HttpServletRequest req, String defaultAutoLogin) {
        return LoginTools.parseParameter(req, "autologin", defaultAutoLogin);
    }

    public static String parseLanguage(HttpServletRequest req) {
        return LoginTools.parseParameter(req, "language", "");
    }

    public static boolean parseStoreLanguage(HttpServletRequest req) {
        String value = req.getParameter("storeLanguage");
        return Boolean.parseBoolean(value);
    }

    public static String parseParameter(HttpServletRequest req, String paramName, boolean strict, String fallback) throws OXException {
        String value = req.getParameter(paramName);
        if (null == value) {
            if (strict) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create(paramName);
            }
            return fallback;
        }
        return value;
    }

    public static String parseParameter(HttpServletRequest req, String paramName, String fallback) {
        String value = req.getParameter(paramName);
        if (null == value) {
            return fallback;
        }
        return value;
    }

    public static String parseParameter(HttpServletRequest req, String paramName) throws OXException {
        String value = req.getParameter(paramName);
        if (null == value) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(paramName);
        }
        return value;
    }

    public static String parseClientIP(HttpServletRequest req) {
        return LoginTools.parseParameter(req, "clientIP", req.getRemoteAddr());
    }

    public static String parseUserAgent(HttpServletRequest req) {
        return LoginTools.parseParameter(req, "clientUserAgent", req.getHeader("user-agent"));
    }

    public static LoginRequestImpl parseLogin(HttpServletRequest req, String login, String password, boolean strict, String defaultClient, boolean forceHTTPS, boolean requiredAuthId) throws OXException {
        return LoginTools.parseLogin(req, login, password, strict, defaultClient, forceHTTPS, requiredAuthId, null);
    }

    public static LoginRequestImpl parseLogin(HttpServletRequest req, String login, String password, boolean strict, String defaultClient, boolean forceHTTPS, boolean requiredAuthId, String ... additionalsForHash) throws OXException {
        String version2;
        String authId = LoginTools.parseAuthId(req, requiredAuthId);
        String client = LoginTools.parseClient(req, strict, defaultClient);
        if (null == req.getParameter("version")) {
            if (strict) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create("version");
            }
            version2 = null;
        } else {
            version2 = req.getParameter("version");
        }
        String clientIP = LoginTools.parseClientIP(req);
        String userAgent = LoginTools.parseUserAgent(req);
        Map<String, List<String>> headers = Tools.copyHeaders(req);
        Cookie[] cookies = Tools.getCookieFromHeader(req);
        String httpSessionId = req.getSession(true).getId();
        LogProperties.putProperty((LogProperties.Name)LogProperties.Name.LOGIN_LOGIN, (Object)Strings.abbreviate((String)login, (int)256));
        LogProperties.putProperty((LogProperties.Name)LogProperties.Name.LOGIN_CLIENT_IP, (Object)clientIP);
        LogProperties.putProperty((LogProperties.Name)LogProperties.Name.LOGIN_USER_AGENT, (Object)userAgent);
        LogProperties.putProperty((LogProperties.Name)LogProperties.Name.LOGIN_AUTH_ID, (Object)authId);
        LogProperties.putProperty((LogProperties.Name)LogProperties.Name.LOGIN_CLIENT, (Object)client);
        LogProperties.putProperty((LogProperties.Name)LogProperties.Name.LOGIN_VERSION, (Object)version2);
        LoginRequestImpl.Builder b = new LoginRequestImpl.Builder().login(login).password(password).clientIP(clientIP);
        b.userAgent(userAgent).authId(authId).client(client).version(version2);
        b.hash(HashCalculator.getInstance().getHash(req, userAgent, client, additionalsForHash));
        b.iface(Interface.HTTP_JSON).headers(headers).cookies(cookies).secure(Tools.considerSecure(req, forceHTTPS));
        b.serverName(req.getServerName()).serverPort(req.getServerPort()).httpSessionID(httpSessionId);
        b.language(LoginTools.parseLanguage(req));
        b.storeLanguage(LoginTools.parseStoreLanguage(req));
        return b.build();
    }

    public static LoginRequestImpl parseLogin(HttpServletRequest req, String loginParamName, boolean strict, String defaultClient, boolean forceHTTPS, boolean disableTrimLogin, boolean requiredAuthId) throws OXException {
        String password;
        String login = req.getParameter(loginParamName);
        if (null == login) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(loginParamName);
        }
        if (!disableTrimLogin) {
            login = login.trim();
        }
        if (null == (password = req.getParameter("password"))) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("password");
        }
        return LoginTools.parseLogin(req, login, password, strict, defaultClient, forceHTTPS, requiredAuthId);
    }

    public static void updateIPAddress(LoginConfiguration conf, String newIP, Session session) {
        if (conf.isInsecure()) {
            String oldIP = session.getLocalIp();
            if (null != newIP && !newIP.equals(oldIP)) {
                LOG.info("Updating session's IP address. authID: {}, sessionID: {}, old IP address: {}, new IP address: {}", new Object[]{session.getAuthId(), session.getSessionID(), oldIP, newIP});
                SessiondService service = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                if (null != service) {
                    try {
                        service.setLocalIp(session.getSessionID(), newIP);
                    }
                    catch (OXException e) {
                        LOG.info("Failed to update session's IP address. authID: {}, sessionID: {}, old IP address: {}, new IP address: {}", new Object[]{session.getAuthId(), session.getSessionID(), oldIP, newIP, e});
                    }
                }
            }
        }
    }

    public static String[] parseShareInformation(HttpServletRequest req) throws OXException {
        String token = req.getParameter("share");
        if (Strings.isNotEmpty((String)token)) {
            ShareService shareService = ServerServiceRegistry.getInstance().getService(ShareService.class);
            if (null == shareService) {
                return null;
            }
            GuestInfo guest = shareService.resolveGuest(token);
            int contextId = guest.getContextID();
            int guestId = guest.getGuestID();
            return new String[]{String.valueOf(contextId), String.valueOf(guestId)};
        }
        return null;
    }
}

