/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.SessionUtility;
import com.openexchange.ajax.login.HashCalculator;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.authentication.Authenticated;
import com.openexchange.authentication.GuestAuthenticated;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.authentication.service.Authentication;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextExceptionCodes;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.login.internal.LoginResultImpl;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessionExceptionCodes;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.share.GuestInfo;
import com.openexchange.share.ShareService;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoLoginTools {
    private static final Logger LOG = LoggerFactory.getLogger(AutoLoginTools.class);

    public static LoginResult reAuthenticate(LoginResult autoLoginResult, String login, String password, Map<String, Object> properties) throws OXException {
        if (null != autoLoginResult) {
            User user;
            Context context;
            Authenticated authenticated = Authentication.login(login, password, properties);
            if (GuestAuthenticated.class.isInstance(authenticated)) {
                GuestAuthenticated guestAuthenticated = (GuestAuthenticated)authenticated;
                context = AutoLoginTools.getContext(guestAuthenticated.getContextID());
                user = AutoLoginTools.getUser(context, guestAuthenticated.getUserID());
            } else {
                context = LoginPerformer.findContext(authenticated.getContextInfo());
                user = LoginPerformer.findUser(context, authenticated.getUserInfo());
            }
            if (context.getContextId() == autoLoginResult.getContext().getContextId() && context.getContextId() == autoLoginResult.getSession().getContextId() && user.getId() == autoLoginResult.getUser().getId() && user.getId() == autoLoginResult.getSession().getUserId()) {
                return autoLoginResult;
            }
        }
        return null;
    }

    public static LoginResult tryAutologin(LoginConfiguration loginConfig, HttpServletRequest request, HttpServletResponse response) throws OXException {
        return AutoLoginTools.tryAutologin(loginConfig, request, response, HashCalculator.getInstance().getHash(request));
    }

    public static LoginResult tryAutologin(LoginConfiguration loginConfig, HttpServletRequest request, HttpServletResponse response, String hash) throws OXException {
        Cookie[] cookies = request.getCookies();
        if (loginConfig.isSessiondAutoLogin() && null != cookies && 0 < cookies.length) {
            String sessionID = null;
            String secret = null;
            String sessionCookieName = LoginServlet.SESSION_PREFIX + hash;
            String secretCookieName = LoginServlet.SECRET_PREFIX + hash;
            try {
                for (int i = 0; i < cookies.length; ++i) {
                    String name = cookies[i].getName();
                    if (name.startsWith(sessionCookieName)) {
                        sessionID = cookies[i].getValue();
                    } else if (name.startsWith(secretCookieName)) {
                        secret = cookies[i].getValue();
                    }
                    if (null == sessionID || null == secret) continue;
                    LOG.debug("Successfully looked up session- & secret-cookie pair for hash {}, continuing auto-login procedure.", (Object)hash);
                    return AutoLoginTools.tryAutoLogin(loginConfig, request, sessionID, secret);
                }
                LOG.debug("No session- & secret-cookie pair for hash {} found, aborting auto-login procedure.", (Object)hash);
            }
            catch (OXException e) {
                if (SessionExceptionCodes.WRONG_CLIENT_IP.equals(e)) {
                    SessionUtility.removeOXCookies(request, response, Collections.singletonList(sessionCookieName));
                    LoginPerformer.getInstance().doLogout(sessionID);
                    return null;
                }
                throw e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginResult tryGuestAutologin(LoginConfiguration loginConfig, HttpServletRequest request, HttpServletResponse response) throws OXException {
        Cookie[] cookies = request.getCookies();
        if (loginConfig.isSessiondAutoLogin() && null != cookies && 0 < cookies.length) {
            String shareCookieName = LoginServlet.getShareCookieName(request);
            String shareToken = null;
            for (Cookie cookie : cookies) {
                if (!cookie.getName().startsWith(shareCookieName)) continue;
                shareToken = cookie.getValue();
                break;
            }
            if (null != shareToken) {
                LOG.debug("Successfully looked up share token {} from {}, continuing auto-login procedure.", shareToken, (Object)shareCookieName);
                LoginResult loginResult = null;
                try {
                    GuestInfo guest = ServerServiceRegistry.getInstance().getService(ShareService.class).resolveGuest(shareToken);
                    if (null == guest) {
                        LoginResult loginResult2 = null;
                        return loginResult2;
                    }
                    LoginResult loginResult3 = loginResult = AutoLoginTools.tryGuestAutologin(guest, loginConfig, request, response);
                    return loginResult3;
                }
                finally {
                    if (null == loginResult) {
                        SessionUtility.removeOXCookies(request, response, Collections.singletonList(shareCookieName));
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginResult tryGuestAutologin(GuestInfo guest, LoginConfiguration loginConfig, HttpServletRequest request, HttpServletResponse response) throws OXException {
        String client = LoginTools.parseClient(request, false, loginConfig.getDefaultClient());
        String userAgent = HashCalculator.getUserAgent(request);
        String guestHash = HashCalculator.getInstance().getHash(request, userAgent, client, String.valueOf(guest.getContextID()), String.valueOf(guest.getGuestID()));
        LoginResult loginResult = null;
        try {
            LoginResult loginResult2 = loginResult = AutoLoginTools.tryAutologin(loginConfig, request, response, guestHash);
            return loginResult2;
        }
        finally {
            if (null == loginResult) {
                String shareCookieName = HashCalculator.getInstance().getHash(request, userAgent, client);
                SessionUtility.removeOXCookies(request, response, Collections.singletonList(shareCookieName));
            }
        }
    }

    private static LoginResult tryAutoLogin(LoginConfiguration loginConfig, HttpServletRequest request, String sessionID, String secret) throws OXException {
        Session session = AutoLoginTools.getSession(sessionID);
        if (null == session || !secret.equals(session.getSecret())) {
            LOG.debug("Session {} not found, aborting auto-login procedure.", (Object)sessionID);
            return null;
        }
        LOG.debug("Successfully looked up session {}, verifying if session is valid.", (Object)sessionID);
        String remoteAddress = request.getRemoteAddr();
        if (loginConfig.isIpCheck()) {
            SessionUtility.checkIP(true, loginConfig.getRanges(), session, remoteAddress, loginConfig.getIpCheckWhitelist());
        }
        LoginTools.updateIPAddress(loginConfig, remoteAddress, session);
        Context context = ContextStorage.getInstance().getContext(session.getContextId());
        User user = UserStorage.getInstance().getUser(session.getUserId(), context);
        if (!context.isEnabled() || !user.isMailEnabled()) {
            throw LoginExceptionCodes.INVALID_CREDENTIALS.create();
        }
        LOG.debug("Auto-login successful for session {} of user {} in context {}.", new Object[]{sessionID, user.getId(), context.getContextId()});
        return new LoginResultImpl(session, context, user);
    }

    private static Session getSession(String sessionID) {
        SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (null == sessiondService) {
            LOG.error("", (Throwable)ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()}));
            return null;
        }
        return sessiondService.getSession(sessionID);
    }

    private static Context getContext(int contextID) throws OXException {
        Context context = ContextStorage.getInstance().getContext(contextID);
        if (null == context) {
            throw ContextExceptionCodes.NOT_FOUND.create(Autoboxing.I((int)contextID));
        }
        return context;
    }

    private static User getUser(Context ctx, int userID) throws OXException {
        return UserStorage.getInstance().getUser(userID, ctx);
    }

    private AutoLoginTools() {
    }
}

