/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.anonymizer;

import com.openexchange.ajax.anonymizer.AnonymizeExceptionCodes;
import com.openexchange.ajax.anonymizer.AnonymizerRegistryService;
import com.openexchange.ajax.anonymizer.AnonymizerService;
import com.openexchange.ajax.anonymizer.Module;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.util.Locale;

public final class Anonymizers {
    private static final EmptyAnonymizer<?> EMPTY_ANONYMIZER = new EmptyAnonymizer();

    private Anonymizers() {
    }

    public static boolean isGuest(Session session) throws OXException {
        return null != session && UserStorage.getInstance().isGuest(session.getUserId(), session.getContextId());
    }

    public static <E> AnonymizerService<E> emptyAnonymizerFor() {
        return EMPTY_ANONYMIZER;
    }

    public static <E> AnonymizerService<E> optAnonymizerFor(Module module) throws OXException {
        AnonymizerRegistryService registry = ServerServiceRegistry.getInstance().getService(AnonymizerRegistryService.class);
        if (null == registry) {
            return Anonymizers.emptyAnonymizerFor();
        }
        AnonymizerService anonymizer = registry.getAnonymizerFor(module);
        return null == anonymizer ? Anonymizers.emptyAnonymizerFor() : anonymizer;
    }

    public static <E> E optAnonymize(E entity, Module module, Session session) throws OXException {
        if (null == entity) {
            return entity;
        }
        return Anonymizers.anonymize0(entity, module, session, false);
    }

    public static <E> E optAnonymizeIfGuest(E entity, Module module, Session session) throws OXException {
        if (null == entity) {
            return entity;
        }
        if (!Anonymizers.isGuest(session)) {
            return entity;
        }
        return Anonymizers.anonymize0(entity, module, session, false);
    }

    public static <E> E anonymize(E entity, Module module, Session session) throws OXException {
        if (null == entity) {
            return entity;
        }
        return Anonymizers.anonymize0(entity, module, session, true);
    }

    public static <E> E anonymizeIfGuest(E entity, Module module, Session session) throws OXException {
        if (null == entity) {
            return entity;
        }
        if (!Anonymizers.isGuest(session)) {
            return entity;
        }
        return Anonymizers.anonymize0(entity, module, session, true);
    }

    private static <E> E anonymize0(E entity, Module module, Session session, boolean failOnAbsence) throws OXException {
        AnonymizerRegistryService registry = ServerServiceRegistry.getInstance().getService(AnonymizerRegistryService.class);
        if (null == registry) {
            if (failOnAbsence) {
                throw ServiceExceptionCode.absentService(AnonymizerRegistryService.class);
            }
            return entity;
        }
        AnonymizerService<E> anonymizer = registry.getAnonymizerFor(module);
        if (null == anonymizer) {
            if (failOnAbsence) {
                throw AnonymizeExceptionCodes.NO_SUCH_ANONYMIZER.create(module.getName());
            }
            return entity;
        }
        return anonymizer.anonymize(entity, session);
    }

    public static String getUserI18nFor(Session session) throws OXException {
        return Anonymizers.getI18nFor("User", session);
    }

    public static String getGroupI18nFor(Session session) throws OXException {
        return Anonymizers.getI18nFor("Group", session);
    }

    public static String getResourceI18nFor(Session session) throws OXException {
        return Anonymizers.getI18nFor("Resource", session);
    }

    public static String getI18nFor(String string, Session session) throws OXException {
        if (null == string) {
            return string;
        }
        return StringHelper.valueOf(Anonymizers.getLocaleFrom(session)).getString(string);
    }

    public static Locale getLocaleFrom(Session session) throws OXException {
        if (null == session) {
            return Locale.US;
        }
        Locale locale = UserStorage.getInstance().getUser(session.getUserId(), session.getContextId()).getLocale();
        return null == locale ? Locale.US : locale;
    }

    private static class EmptyAnonymizer<E>
    implements AnonymizerService<E> {
        EmptyAnonymizer() {
        }

        @Override
        public Module getModule() {
            return null;
        }

        @Override
        public E anonymize(E entity, Session session) throws OXException {
            return entity;
        }
    }
}

