/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.groupware;

import com.openexchange.database.AbstractCreateTableImpl;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.messaging.generic.services.MessagingGenericServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessagingGenericCreateTableTask
extends AbstractCreateTableImpl
implements UpdateTaskV2 {
    private String getMessagingAccountTable() {
        return "CREATE TABLE messagingAccount ( cid INT4 unsigned NOT NULL, user INT4 unsigned NOT NULL, serviceId VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, account INT4 unsigned NOT NULL, confId INT4 unsigned NOT NULL, displayName VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, PRIMARY KEY (cid, user, serviceId, account), FOREIGN KEY (cid, user) REFERENCES user (cid, id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    }

    protected String[] getCreateStatements() {
        return new String[]{this.getMessagingAccountTable()};
    }

    public TaskAttributes getAttributes() {
        return new Attributes();
    }

    public String[] getDependencies() {
        return new String[0];
    }

    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        this.createTable("messagingAccount", this.getMessagingAccountTable(), contextId);
        Logger logger = LoggerFactory.getLogger(MessagingGenericCreateTableTask.class);
        logger.info("UpdateTask ''{}'' successfully performed!", (Object)MessagingGenericCreateTableTask.class.getSimpleName());
    }

    public String[] requiredTables() {
        return new String[]{"user"};
    }

    public String[] tablesToCreate() {
        return new String[]{"messagingAccount"};
    }

    private void createTable(String tablename, String sqlCreate, int contextId) throws OXException {
        DatabaseService ds = this.getService(DatabaseService.class);
        Connection writeCon = ds.getWritable(contextId);
        PreparedStatement stmt = null;
        try {
            if (this.tableExists(writeCon, tablename)) {
                return;
            }
            stmt = writeCon.prepareStatement(sqlCreate);
            stmt.executeUpdate();
            DBUtils.closeSQLStuff((Statement)stmt);
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            ds.backWritable(contextId, writeCon);
        }
        ds.backWritable(contextId, writeCon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(Connection con, String table) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet rs = null;
        boolean retval = false;
        try {
            rs = metaData.getTables(null, null, table, new String[]{"TABLE"});
            retval = rs.next() && rs.getString("TABLE_NAME").equals(table);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs);
            throw throwable;
        }
        DBUtils.closeSQLStuff((ResultSet)rs);
        return retval;
    }

    private <S> S getService(Class<? extends S> clazz) throws OXException {
        try {
            return MessagingGenericServiceRegistry.getService(clazz);
        }
        catch (RuntimeException e) {
            throw new OXException((Throwable)e);
        }
    }
}

