/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Enums {
    public static <T extends Enum<T>> T parse(Class<T> enumeration, String name) {
        T value = Enums.parse(enumeration, name, null);
        if (null != value) {
            return value;
        }
        throw new IllegalArgumentException("No enum value '" + name + "' in Enum " + enumeration.getClass().getName());
    }

    public static <T extends Enum<T>> T parse(Class<T> enumeration, String name, T defaultValue) {
        for (Enum value : (Enum[])enumeration.getEnumConstants()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return (T)value;
        }
        return defaultValue;
    }

    public static <T extends Enum<T>> List<T> parse(Class<T> enumeration, String ... names) {
        if (null == names) {
            return null;
        }
        if (names.length <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> elements = new ArrayList<Object>(names.length);
        for (String name : names) {
            elements.add(Enums.parse(enumeration, name, null));
        }
        return elements;
    }

    public static <T extends Enum<T>> List<T> parseCsv(Class<T> enumeration, String csv) {
        if (Strings.isEmpty(csv)) {
            return Collections.emptyList();
        }
        return Enums.parse(enumeration, Strings.splitByComma(Strings.unquote(csv)));
    }

    private Enums() {
    }
}

