/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.osgi;

import com.openexchange.ajax.customizer.file.AdditionalFileField;
import com.openexchange.java.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.LoggerFactory;

public class FileFieldCollector
implements ServiceTrackerCustomizer<AdditionalFileField, AdditionalFileField> {
    private final ConcurrentMap<Integer, AdditionalFileField> knownFields;
    private final BundleContext context;

    public FileFieldCollector(BundleContext context) {
        this.context = context;
        this.knownFields = new ConcurrentHashMap<Integer, AdditionalFileField>();
    }

    public List<AdditionalFileField> getFields() {
        return new ArrayList<AdditionalFileField>(this.knownFields.values());
    }

    public AdditionalFileField getField(int columnID) {
        return (AdditionalFileField)this.knownFields.get(columnID);
    }

    public List<AdditionalFileField> getFields(int[] columnIDs) {
        ArrayList<AdditionalFileField> fields = new ArrayList<AdditionalFileField>();
        for (int columnID : columnIDs) {
            AdditionalFileField field = this.getField(columnID);
            if (null == field) continue;
            fields.add(field);
        }
        return fields;
    }

    public AdditionalFileField getField(String columnNumberOrName) {
        if (Strings.isEmpty((String)columnNumberOrName)) {
            return null;
        }
        try {
            return (AdditionalFileField)this.knownFields.get(Integer.valueOf(columnNumberOrName));
        }
        catch (NumberFormatException e) {
            for (AdditionalFileField field : this.getFields()) {
                if (!columnNumberOrName.equals(field.getColumnName())) continue;
                return field;
            }
            return null;
        }
    }

    public AdditionalFileField addingService(ServiceReference<AdditionalFileField> reference) {
        AdditionalFileField field = (AdditionalFileField)this.context.getService(reference);
        Integer columnID = field.getColumnID();
        AdditionalFileField existingField = this.knownFields.putIfAbsent(columnID, field);
        if (null != existingField) {
            LoggerFactory.getLogger(FileFieldCollector.class).warn("Collision in file fields. Field '{}' : {} has already been taken. Ignoring second service.", (Object)field.getColumnName(), (Object)field.getColumnID());
        }
        return field;
    }

    public void modifiedService(ServiceReference<AdditionalFileField> reference, AdditionalFileField service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<AdditionalFileField> reference, AdditionalFileField service) {
        try {
            AdditionalFileField field = service;
            Integer columnID = field.getColumnID();
            this.knownFields.remove(columnID);
        }
        finally {
            this.context.ungetService(reference);
        }
    }
}

