/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.IdVersionPair;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.ziputil.ZipMaker;
import com.openexchange.java.Strings;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.IOException;
import java.util.Collections;

@Action(method=RequestMethod.PUT, name="zipfolder", description="Gets a ZIP archive for a folder's infoitems", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder_id", description="A folder identifier."), @Parameter(name="recursive", description="true or false")}, responseDescription="The ZIP archive binary data")
@DispatcherNotes(defaultFormat="file")
public class ZipFolderAction
extends AbstractFileAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        IDBasedFileAccess fileAccess = request.getFileAccess();
        IDBasedFolderAccess folderAccess = request.getFolderAccess();
        String folderId = request.getFolderId();
        if (Strings.isEmpty((String)folderId)) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{AbstractFileAction.Param.FOLDER_ID.getName()});
        }
        String tmp = request.getParameter("recursive");
        boolean recursive = AJAXRequestDataTools.parseBoolParameter((String)tmp);
        String folderName = folderAccess.getFolder(folderId).getName();
        folderName = ZipFolderAction.saneForFileName(folderName);
        ZipMaker zipMaker = new ZipMaker(Collections.singletonList(new IdVersionPair(null, null, folderId)), recursive, fileAccess, folderAccess);
        zipMaker.checkThreshold(ZipFolderAction.threshold());
        AJAXRequestData ajaxRequestData = request.getRequestData();
        if (ajaxRequestData.setResponseHeader("Content-Type", "application/zip")) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("attachment");
            DownloadUtility.appendFilenameParameter((String)(folderName + ".zip"), (String)"application/zip", (String)ajaxRequestData.getUserAgent(), (StringBuilder)sb);
            ajaxRequestData.setResponseHeader("Content-Disposition", sb.toString());
            try {
                zipMaker.writeZipArchive(ajaxRequestData.optOutputStream());
            }
            catch (IOException e) {
                throw AjaxExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            return new AJAXRequestResult(AJAXRequestResult.DIRECT_OBJECT, "direct").setType(AJAXRequestResult.ResultType.DIRECT);
        }
        ThresholdFileHolder fileHolder = new ThresholdFileHolder();
        fileHolder.setDisposition("attachment");
        fileHolder.setName(folderName + ".zip");
        fileHolder.setContentType("application/zip");
        fileHolder.setDelivery("download");
        zipMaker.writeZipArchive(fileHolder.asOutputStream());
        ajaxRequestData.setFormat("file");
        return new AJAXRequestResult((Object)fileHolder, "file");
    }

    private static String saneForFileName(String fileName) {
        if (Strings.isEmpty((String)fileName)) {
            return "archive";
        }
        int len = fileName.length();
        StringBuilder sb = new StringBuilder(len);
        char prev = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = fileName.charAt(i);
            if (Strings.isWhitespace((char)c)) {
                if (prev == '_') continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            if ('/' == c) {
                if (prev == 95) continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            if ('\\' == c) {
                if (prev == 95) continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            if (',' == c) {
                if (prev == 95) continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            if ('.' == c) {
                if (prev == 95) continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            prev = '\u0000';
            sb.append(c);
        }
        String sanitized = sb.toString();
        return Strings.isEmpty((String)sanitized) ? "archive" : sanitized;
    }
}

