/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.ajax.requesthandler.ETagAwareAJAXActionService;
import com.openexchange.ajax.requesthandler.LastModifiedAwareAJAXActionService;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.Document;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageCapability;
import com.openexchange.file.storage.FileStorageUtility;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AJAXInfostoreRequest;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.services.Services;
import com.openexchange.java.Streams;
import com.openexchange.session.Session;
import com.openexchange.tools.images.ImageTransformationUtility;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.GET, defaultFormat="file", name="[filename]?action=document", description="Get an infoitem document", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the requested infoitem."), @Parameter(name="folder", description="Object ID of the infoitem's folder."), @Parameter(name="version", optional=true, description="If present the infoitem data describes the given version. Otherwise the current version is returned"), @Parameter(name="content_type", optional=true, description="If present the response declares the given content_type in the Content-Type header.")}, responseDescription="The raw byte data of the document. The response type for the HTTP Request is set accordingly to the defined mimetype for this infoitem or the content_type given.")
@DispatcherNotes(defaultFormat="file", allowPublicSession=true)
public class DocumentAction
extends AbstractFileAction
implements ETagAwareAJAXActionService,
LastModifiedAwareAJAXActionService {
    static final Logger LOGGER = LoggerFactory.getLogger(DocumentAction.class);
    public static final String DOCUMENT = "com.openexchange.file.storage.json.DocumentAction.DOCUMENT";
    private static final int DEFAULT_IN_MEMORY_THRESHOLD = 65536;
    private final boolean inlineIfPossible;

    public DocumentAction() {
        this.inlineIfPossible = false;
    }

    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        AJAXRequestResult result;
        request.require(AbstractFileAction.Param.ID);
        FileID fileID = new FileID(request.getId());
        IDBasedFileAccess fileAccess = request.getFileAccess();
        if (ImageTransformationUtility.seemsLikeThumbnailRequest((AJAXRequestData)request.getRequestData()) && fileAccess.supports(fileID.getService(), fileID.getAccountId(), new FileStorageCapability[]{FileStorageCapability.THUMBNAIL_IMAGES})) {
            File metadata = fileAccess.getFileMetadata(request.getId(), request.getVersion());
            IFileHolder.InputStreamClosure isClosure = DocumentAction.getThumbnailStream(request.getSession(), request.getId(), request.getVersion());
            FileHolder fileHolder = new FileHolder(isClosure, -1L, null, metadata.getFileName());
            AJAXRequestResult result2 = new AJAXRequestResult((Object)fileHolder, "file");
            this.createAndSetETag(metadata, request, result2);
            this.setLastModified(metadata, result2);
            return result2;
        }
        if (fileAccess.supports(fileID.getService(), fileID.getAccountId(), new FileStorageCapability[]{FileStorageCapability.EFFICIENT_RETRIEVAL})) {
            Document document = request.getCachedDocument();
            if (null == document) {
                document = fileAccess.getDocumentAndMetadata(request.getId(), request.getVersion());
            }
            if (null != document) {
                AJAXRequestResult result3;
                if (this.inlineIfPossible && document.getSize() > 0L && document.getSize() <= 65536L) {
                    ThresholdFileHolder fileHolder = new ThresholdFileHolder();
                    fileHolder.write(document.getData());
                    result3 = new AJAXRequestResult((Object)fileHolder, "file");
                } else {
                    FileHolder fileHolder = new FileHolder(DocumentAction.getDocumentStream(document), document.getSize(), document.getMimeType(), document.getName());
                    if (fileAccess.supports(fileID.getService(), fileID.getAccountId(), new FileStorageCapability[]{FileStorageCapability.RANDOM_FILE_ACCESS})) {
                        fileHolder.setRandomAccessClosure((IFileHolder.RandomAccessClosure)new IDBasedFileAccessRandomAccessClosure(request.getId(), request.getVersion(), document.getSize(), request.getSession()));
                    }
                    result3 = new AJAXRequestResult((Object)fileHolder, "file");
                }
                if (null != document.getEtag()) {
                    this.setETag(document.getEtag(), 0L, result3);
                }
                if (0L < document.getLastModified()) {
                    this.setLastModified(new Date(document.getLastModified()), result3);
                }
                return result3;
            }
        }
        File metadata = fileAccess.getFileMetadata(request.getId(), request.getVersion());
        if (this.inlineIfPossible && metadata.getFileSize() > 0L && metadata.getFileSize() <= 65536L) {
            ThresholdFileHolder fileHolder = new ThresholdFileHolder();
            fileHolder.write(fileAccess.getDocument(request.getId(), request.getVersion()));
            result = new AJAXRequestResult((Object)fileHolder, "file");
        } else {
            IFileHolder.InputStreamClosure isClosure = DocumentAction.getDocumentStream(request.getSession(), request.getId(), request.getVersion());
            FileHolder fileHolder = new FileHolder(isClosure, metadata.getFileSize(), metadata.getFileMIMEType(), metadata.getFileName());
            if (fileAccess.supports(fileID.getService(), fileID.getAccountId(), new FileStorageCapability[]{FileStorageCapability.RANDOM_FILE_ACCESS})) {
                fileHolder.setRandomAccessClosure((IFileHolder.RandomAccessClosure)new IDBasedFileAccessRandomAccessClosure(request.getId(), request.getVersion(), metadata.getFileSize(), request.getSession()));
            }
            result = new AJAXRequestResult((Object)fileHolder, "file");
        }
        this.createAndSetETag(metadata, request, result);
        this.setLastModified(metadata, result);
        return result;
    }

    private void createAndSetETag(File fileMetadata, InfostoreRequest request, AJAXRequestResult result) throws OXException {
        this.setETag(FileStorageUtility.getETagFor((File)fileMetadata), 0L, result);
    }

    private void setLastModified(File fileMetadata, AJAXRequestResult result) throws OXException {
        this.setLastModified(fileMetadata.getLastModified(), result);
    }

    private void setLastModified(Date lastModified, AJAXRequestResult result) throws OXException {
        if (null != lastModified) {
            result.setHeader("Last-Modified", Tools.formatHeaderDate((Date)lastModified));
        }
    }

    public boolean checkETag(String clientETag, AJAXRequestData requestData, ServerSession session) throws OXException {
        String version;
        String id;
        AJAXInfostoreRequest request = new AJAXInfostoreRequest(requestData, session);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        Document document = fileAccess.getDocumentAndMetadata(id = request.getId(), version = request.getVersion(), clientETag);
        if (document != null) {
            requestData.setProperty(DOCUMENT, (Object)document);
            String etag = document.getEtag();
            return etag != null && etag.equals(clientETag);
        }
        File fileMetadata = fileAccess.getFileMetadata(request.getId(), request.getVersion());
        return FileStorageUtility.getETagFor((File)fileMetadata).equals(clientETag);
    }

    public boolean checkLastModified(long clientLastModified, AJAXRequestData requestData, ServerSession session) throws OXException {
        String version;
        String id;
        AJAXInfostoreRequest request = new AJAXInfostoreRequest(requestData, session);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        Document document = fileAccess.getDocumentAndMetadata(id = request.getId(), version = request.getVersion());
        if (document != null) {
            requestData.setProperty(DOCUMENT, (Object)document);
            long lastModified = document.getLastModified();
            return lastModified > 0L ? false : clientLastModified > lastModified;
        }
        File fileMetadata = fileAccess.getFileMetadata(request.getId(), request.getVersion());
        Date lastModified = fileMetadata.getLastModified();
        return null == lastModified ? false : clientLastModified > lastModified.getTime();
    }

    public void setETag(String eTag, long expires, AJAXRequestResult result) throws OXException {
        result.setExpires(expires);
        if (eTag != null) {
            result.setHeader("ETag", eTag);
        }
    }

    private static IFileHolder.InputStreamClosure getThumbnailStream(final ServerSession session, final String id, final String version) {
        return new IFileHolder.InputStreamClosure(){

            public InputStream newStream() throws OXException, IOException {
                InputStream inputStream;
                IDBasedFileAccess fileAccess = Services.getFileAccessFactory().createAccess((Session)session);
                try {
                    inputStream = fileAccess.optThumbnailStream(id, version);
                }
                catch (OXException e) {
                    LOGGER.debug("Unable to retrieve thumbnail for file: {}, falling back to regular document stream.", (Object)id, (Object)e);
                    inputStream = null;
                }
                if (null == inputStream) {
                    inputStream = fileAccess.getDocument(id, version);
                }
                return Streams.bufferedInputStreamFor((InputStream)inputStream);
            }
        };
    }

    private static IFileHolder.InputStreamClosure getDocumentStream(final ServerSession session, final String id, final String version) {
        return new IFileHolder.InputStreamClosure(){

            public InputStream newStream() throws OXException, IOException {
                IDBasedFileAccess fileAccess = Services.getFileAccessFactory().createAccess((Session)session);
                return Streams.bufferedInputStreamFor((InputStream)fileAccess.getDocument(id, version));
            }
        };
    }

    private static IFileHolder.InputStreamClosure getDocumentStream(final Document document) {
        return new IFileHolder.InputStreamClosure(){

            public InputStream newStream() throws OXException, IOException {
                return Streams.bufferedInputStreamFor((InputStream)document.getData());
            }
        };
    }

    private static class IDBasedFileAccessRandomAccess
    implements IFileHolder.RandomAccess,
    IFileHolder.InputStreamClosure {
        private final String id;
        private final String version;
        private final ServerSession session;
        private final long length;
        private long pos = 0L;

        IDBasedFileAccessRandomAccess(String id, String version, long length, ServerSession session) {
            this.id = id;
            this.version = version;
            this.length = length;
            this.session = session;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int n;
            long count = this.length;
            if (this.pos >= count) {
                return -1;
            }
            int length = len;
            long avail = count - this.pos;
            if ((long)length > avail) {
                length = (int)avail;
            }
            if (length <= 0) {
                return 0;
            }
            InputStream partialIn = null;
            try {
                IDBasedFileAccess newFileAccess = Services.getFileAccessFactory().createAccess((Session)this.session);
                partialIn = newFileAccess.getDocument(this.id, this.version, this.pos, (long)length);
                int read = partialIn.read(b, off, length);
                this.pos += (long)read;
                n = read;
            }
            catch (OXException e) {
                try {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new IOException(null == cause ? e : cause);
                }
                catch (Throwable throwable) {
                    Streams.close(partialIn);
                    throw throwable;
                }
            }
            Streams.close((Closeable)partialIn);
            return n;
        }

        public void close() throws IOException {
        }

        public void seek(long pos) throws IOException {
            this.pos = pos;
        }

        public long length() throws IOException {
            return this.length;
        }

        public InputStream newStream() throws OXException, IOException {
            IDBasedFileAccess newFileAccess = Services.getFileAccessFactory().createAccess((Session)this.session);
            return Streams.bufferedInputStreamFor((InputStream)newFileAccess.getDocument(this.id, this.version));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(32);
            builder.append("IDBasedFileAccessRandomAccess [");
            if (this.id != null) {
                builder.append("id=").append(this.id).append(", ");
            }
            if (this.version != null) {
                builder.append("version=").append(this.version).append(", ");
            }
            builder.append("length=").append(this.length).append(", pos=").append(this.pos).append(']');
            return builder.toString();
        }
    }

    private static class IDBasedFileAccessRandomAccessClosure
    implements IFileHolder.RandomAccessClosure {
        private final String id;
        private final String version;
        private final ServerSession session;
        private final long length;

        IDBasedFileAccessRandomAccessClosure(String id, String version, long length, ServerSession session) {
            this.id = id;
            this.version = version;
            this.length = length;
            this.session = session;
        }

        public IFileHolder.RandomAccess newRandomAccess() throws OXException, IOException {
            return new IDBasedFileAccessRandomAccess(this.id, this.version, this.length, this.session);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(32);
            builder.append("IDBasedFileAccessRandomAccessClosure [");
            if (this.id != null) {
                builder.append("id=").append(this.id).append(", ");
            }
            if (this.version != null) {
                builder.append("version=").append(this.version).append(", ");
            }
            builder.append("length=").append(this.length).append(']');
            return builder.toString();
        }
    }
}

