/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.accounts;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.AccountAware;
import com.openexchange.file.storage.CapabilityAware;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageCapability;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.json.actions.accounts.AbstractFileStorageAccountAction;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class AllAction
extends AbstractFileStorageAccountAction {
    public AllAction(FileStorageServiceRegistry registry) {
        super(registry);
    }

    @Override
    protected AJAXRequestResult doIt(AJAXRequestData request, ServerSession session) throws JSONException, OXException {
        String fsServiceId = request.getParameter("filestorageService");
        ArrayList<FileStorageService> services = new ArrayList<FileStorageService>();
        if (fsServiceId != null) {
            services.add(this.registry.getFileStorageService(fsServiceId));
        } else {
            services.addAll(this.registry.getAllServices());
        }
        JSONArray result = new JSONArray(services.size() << 1);
        AJAXRequestResult requestResult = new AJAXRequestResult((Object)result);
        for (FileStorageService fsService : services) {
            List userAccounts = null;
            if (fsService instanceof AccountAware) {
                userAccounts = ((AccountAware)fsService).getAccounts((Session)session);
            }
            if (null == userAccounts) {
                userAccounts = fsService.getAccountManager().getAccounts((Session)session);
            }
            for (FileStorageAccount account : userAccounts) {
                try {
                    FileStorageAccountAccess access = fsService.getAccountAccess(account.getId(), (Session)session);
                    FileStorageFolder rootFolder = access.getRootFolder();
                    if (null == rootFolder) continue;
                    HashSet<String> caps = new HashSet<String>();
                    if (access instanceof CapabilityAware) {
                        CapabilityAware capabilityAware = (CapabilityAware)access;
                        Boolean supported = capabilityAware.supports(FileStorageCapability.FILE_VERSIONS);
                        if (null != supported && supported.booleanValue()) {
                            caps.add(FileStorageCapability.FILE_VERSIONS.name());
                        }
                        if (null != (supported = capabilityAware.supports(FileStorageCapability.EXTENDED_METADATA)) && supported.booleanValue()) {
                            caps.add(FileStorageCapability.EXTENDED_METADATA.name());
                        }
                        if (((CapabilityAware)access).supports(FileStorageCapability.RANDOM_FILE_ACCESS).booleanValue()) {
                            caps.add(FileStorageCapability.RANDOM_FILE_ACCESS.name());
                        }
                        if (((CapabilityAware)access).supports(FileStorageCapability.LOCKS).booleanValue()) {
                            caps.add(FileStorageCapability.LOCKS.name());
                        }
                    }
                    result.put((Object)this.writer.write(account, rootFolder, caps));
                }
                catch (OXException e) {
                    if (e.equalsCode(6, "OAUTH")) {
                        try {
                            fsService.getAccountManager().deleteAccount(account, (Session)session);
                        }
                        catch (Exception x) {}
                        continue;
                    }
                    requestResult.setException(e);
                }
            }
        }
        return requestResult;
    }
}

