/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.json.FormContentWriter;
import com.openexchange.datatypes.genericonf.json.FormDescriptionWriter;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccounts;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.composition.FolderID;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileStorageAccountWriter {
    public JSONObject write(FileStorageAccount account, FileStorageFolder rootFolder, Set<String> capabilities) throws JSONException {
        JSONObject accountJSON = new JSONObject(7);
        accountJSON.put("id", (Object)account.getId());
        FileStorageService fsService = account.getFileStorageService();
        accountJSON.put("qualifiedId", (Object)FileStorageAccounts.getQualifiedID((FileStorageAccount)account));
        accountJSON.put("displayName", (Object)account.getDisplayName());
        accountJSON.put("filestorageService", (Object)fsService.getId());
        accountJSON.put("rootFolder", (Object)new FolderID(fsService.getId(), account.getId(), rootFolder.getId()).toUniqueID());
        accountJSON.put("isDefaultAccount", FileStorageAccounts.isDefaultAccount((FileStorageAccount)account));
        DynamicFormDescription formDescription = fsService.getFormDescription();
        if (null != formDescription && null != account.getConfiguration()) {
            JSONObject configJSON = FormContentWriter.write((DynamicFormDescription)formDescription, (Map)account.getConfiguration(), null);
            accountJSON.put("configuration", (Object)configJSON);
        }
        if (capabilities == null) {
            capabilities = new HashSet<String>(0);
        }
        accountJSON.put("capabilities", capabilities);
        return accountJSON;
    }

    public JSONObject write(FileStorageService service) throws JSONException {
        JSONArray jFormDescription;
        JSONObject serviceJSON = new JSONObject(6);
        serviceJSON.put("id", (Object)service.getId());
        serviceJSON.put("displayName", (Object)service.getDisplayName());
        DynamicFormDescription formDescription = service.getFormDescription();
        if (null != formDescription && (jFormDescription = new FormDescriptionWriter().write(formDescription)).length() > 0) {
            serviceJSON.put("configuration", (Object)jFormDescription);
        }
        return serviceJSON;
    }
}

