/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json;

import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFileStorageGuestObjectPermission;
import com.openexchange.file.storage.DefaultFileStorageObjectPermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.java.Enums;
import com.openexchange.share.core.tools.ShareTool;
import com.openexchange.share.recipient.RecipientType;
import java.util.ArrayList;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileMetadataFieldParser {
    public static Object convert(File.Field field, Object value) throws JSONException, OXException {
        Object val = value;
        if (val == JSONObject.NULL) {
            val = null;
        }
        switch (field) {
            case CATEGORIES: {
                if (String.class.isInstance(val)) {
                    return val;
                }
                return FileMetadataFieldParser.categories((JSONArray)val);
            }
            case META: {
                if (value == null || value == JSONObject.NULL) {
                    return null;
                }
                return JSONCoercion.coerceToNative((Object)value);
            }
            case OBJECT_PERMISSIONS: {
                if (null == val || JSONObject.NULL.equals(val)) {
                    return null;
                }
                JSONArray jsonArray = (JSONArray)val;
                ArrayList<FileStorageObjectPermission> objectPermissions = new ArrayList<FileStorageObjectPermission>(jsonArray.length());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    objectPermissions.add(FileMetadataFieldParser.parseObjetPermission(jsonArray.getJSONObject(i), null));
                }
                return objectPermissions;
            }
        }
        return val;
    }

    private static Object categories(JSONArray value) throws JSONException {
        if (value.length() == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int size = value.length();
        for (int i = 0; i < size; ++i) {
            b.append(value.getString(i)).append(", ");
        }
        b.setLength(b.length() - 2);
        return b.toString();
    }

    private static FileStorageObjectPermission parseObjetPermission(JSONObject jsonObject, TimeZone timeZone) throws OXException, JSONException {
        if (!jsonObject.hasAndNotNull("bits")) {
            throw FileStorageExceptionCodes.MISSING_PARAMETER.create(new Object[]{"bits"});
        }
        int bits = jsonObject.getInt("bits");
        RecipientType type = (RecipientType)Enums.parse(RecipientType.class, (String)jsonObject.optString("type"), null);
        if (null != type && (RecipientType.ANONYMOUS == type || RecipientType.GUEST == type)) {
            DefaultFileStorageGuestObjectPermission parsedGuestPermission = new DefaultFileStorageGuestObjectPermission();
            parsedGuestPermission.setRecipient(ShareTool.parseRecipient((JSONObject)jsonObject, null));
            parsedGuestPermission.setPermissions(bits);
            return parsedGuestPermission;
        }
        DefaultFileStorageObjectPermission parsedPermission = new DefaultFileStorageObjectPermission();
        if (!jsonObject.has("entity")) {
            throw FileStorageExceptionCodes.MISSING_PARAMETER.create(new Object[]{"entity"});
        }
        parsedPermission.setEntity(jsonObject.getInt("entity"));
        if (jsonObject.has("group")) {
            parsedPermission.setGroup(jsonObject.getBoolean("group"));
        } else if (null != type) {
            parsedPermission.setGroup(RecipientType.GROUP == type);
        } else {
            throw FileStorageExceptionCodes.MISSING_PARAMETER.create(new Object[]{"group"});
        }
        parsedPermission.setPermissions(bits);
        return parsedPermission;
    }
}

