/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore.internal;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.Document;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.infostore.InfostoreFile;
import com.openexchange.groupware.infostore.DocumentAndMetadata;
import com.openexchange.groupware.infostore.DocumentMetadata;
import java.io.InputStream;

public class InfostoreDocument
extends Document {
    private final DocumentAndMetadata documentAndMetadata;

    public InfostoreDocument(DocumentAndMetadata documentAndMetadata) throws OXException {
        this.documentAndMetadata = documentAndMetadata;
        this.setEtag(documentAndMetadata.getETag());
        DocumentMetadata metadata = documentAndMetadata.getMetadata();
        if (null != metadata) {
            this.setFile((File)new InfostoreFile(metadata));
            this.setMimeType(metadata.getFileMIMEType());
            this.setName(metadata.getFileName());
            this.setSize(metadata.getFileSize());
            if (null != metadata.getLastModified()) {
                this.setLastModified(metadata.getLastModified().getTime());
            }
        }
    }

    public InputStream getData() throws OXException {
        return this.documentAndMetadata.getData();
    }
}

