/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.json.JSONBinary;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;
import org.json.JSONValue;

abstract class AbstractJSONValue
implements JSONValue {
    private static final long serialVersionUID = -1594307735237035381L;
    private static final int BUF_SIZE = 2048;
    private static final int SB_SIZE = 8192;
    private static final JsonGenerator.Feature ESCAPE_NON_ASCII = JsonGenerator.Feature.ESCAPE_NON_ASCII;
    protected static final JsonFactory JSON_FACTORY = new JsonFactory();
    protected static final MinimalPrettyPrinter STANDARD_MINIMAL_PRETTY_PRINTER = new MinimalPrettyPrinter();
    protected static final DefaultPrettyPrinter STANDARD_DEFAULT_PRETTY_PRINTER = new DefaultPrettyPrinter();

    protected static String readFrom(Reader reader, long maxRead) throws IOException {
        if (null == reader) {
            return null;
        }
        int buflen = 2048;
        char[] cbuf = new char[2048];
        StringBuilder sa = new StringBuilder(8192);
        long count = 0L;
        int read = reader.read(cbuf, 0, 2048);
        while (read > 0 && (maxRead <= 0L || (count += (long)read) < maxRead)) {
            sa.append(cbuf, 0, read);
            read = reader.read(cbuf, 0, 2048);
        }
        if (0 == sa.length()) {
            return null;
        }
        return sa.toString();
    }

    protected static JsonToken nextTokenSafe(JsonParser jParser) throws IOException {
        JsonToken token = null;
        while (null == token) {
            try {
                token = jParser.nextToken();
            }
            catch (JsonParseException e) {
                if (!e.getMessage().startsWith("Unexpected character")) {
                    throw e;
                }
                token = null;
            }
        }
        return token;
    }

    protected static JsonParser createParser(Reader reader) throws IOException, JsonParseException {
        JsonParser jParser = JSON_FACTORY.createParser(reader);
        jParser.enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES);
        jParser.enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
        jParser.enable(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER);
        jParser.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
        jParser.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        return jParser;
    }

    protected static JsonGenerator createGenerator(Writer writer, boolean asciiOnly) throws IOException {
        JsonGenerator jGenerator = JSON_FACTORY.createGenerator(writer);
        jGenerator.disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
        jGenerator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        if (asciiOnly) {
            jGenerator.enable(ESCAPE_NON_ASCII);
        }
        return jGenerator;
    }

    protected static void writeEndAndFlush(JsonGenerator jGenerator, boolean isJsonObject) {
        if (null != jGenerator) {
            try {
                if (isJsonObject) {
                    jGenerator.writeEndObject();
                } else {
                    jGenerator.writeEndArray();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                jGenerator.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static String directString(int off, int len, char[] chars) {
        try {
            return new String(chars, off, len);
        }
        catch (Exception e) {
            return new String(chars, off, len);
        }
    }

    protected AbstractJSONValue() {
    }

    @Override
    public void writeTo(File file) throws JSONException {
        if (null == file) {
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            this.write(writer);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            try {
                throw new JSONException(e);
            }
            catch (Throwable throwable) {
                AbstractJSONValue.close(writer);
                throw throwable;
            }
        }
        AbstractJSONValue.close(writer);
    }

    @Override
    public void prettyPrintTo(File file) throws JSONException {
        if (null == file) {
            return;
        }
        BufferedWriter writer = null;
        JsonGenerator jGenerator = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            jGenerator = AbstractJSONValue.createGenerator(writer, false);
            jGenerator.setPrettyPrinter((PrettyPrinter)STANDARD_DEFAULT_PRETTY_PRINTER);
            AbstractJSONValue.write(this, jGenerator);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            try {
                throw new JSONException(e);
            }
            catch (Throwable throwable) {
                AbstractJSONValue.close(jGenerator);
                AbstractJSONValue.close(writer);
                throw throwable;
            }
        }
        AbstractJSONValue.close((Closeable)jGenerator);
        AbstractJSONValue.close(writer);
    }

    protected static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected abstract void writeTo(JsonGenerator var1) throws IOException, JSONException;

    protected static void write(Object v, JsonGenerator jGenerator) throws IOException, JSONException {
        block17: {
            block19: {
                block18: {
                    block16: {
                        if (null != v && !JSONObject.NULL.equals(v)) break block16;
                        jGenerator.writeNull();
                        break block17;
                    }
                    if (!(v instanceof AbstractJSONValue)) break block18;
                    ((AbstractJSONValue)v).writeTo(jGenerator);
                    break block17;
                }
                if (!(v instanceof JSONBinary)) break block19;
                InputStream binary = null;
                try {
                    JSONBinary jsonBinary = (JSONBinary)v;
                    binary = jsonBinary.getBinary();
                    jGenerator.writeBinary(binary, (int)jsonBinary.length());
                }
                catch (Exception e) {
                    try {
                        throw new JSONException(e);
                    }
                    catch (Throwable throwable) {
                        AbstractJSONValue.close(binary);
                        throw throwable;
                    }
                }
                AbstractJSONValue.close(binary);
                break block17;
            }
            if (v instanceof JSONString) {
                try {
                    String s = ((JSONString)v).toJSONString();
                    jGenerator.writeString(s);
                }
                catch (Exception e) {
                    throw new JSONException(e);
                }
            } else if (v instanceof Number) {
                jGenerator.writeNumber(JSONObject.numberToString((Number)v));
            } else if (v instanceof Boolean) {
                jGenerator.writeBoolean(((Boolean)v).booleanValue());
            } else if (jGenerator.isEnabled(ESCAPE_NON_ASCII)) {
                jGenerator.writeString(v.toString());
            } else {
                String str = v.toString();
                if (AbstractJSONValue.escapeNonAscii(str)) {
                    int prev = jGenerator.getHighestEscapedChar();
                    jGenerator.setHighestNonEscapedChar(127);
                    jGenerator.writeString(str);
                    jGenerator.setHighestNonEscapedChar(prev);
                } else {
                    jGenerator.writeString(str);
                }
            }
        }
    }

    protected static boolean escapeNonAscii(String str) {
        if (null == str) {
            return false;
        }
        return str.indexOf(8232) >= 0 || str.indexOf(8233) >= 0;
    }

    protected static boolean isNull(Object value) {
        return value == null || value == JSONObject.NULL;
    }
}

