/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.osgi;

import com.openexchange.ajax.LoginTest;
import com.openexchange.test.osgi.AbstractBundleTest;
import org.json.JSONArray;
import org.json.JSONObject;

public final class BundleTestSessionD
extends AbstractBundleTest {
    private static final String BUNDLE_ID = "com.openexchange.sessiond";

    public BundleTestSessionD(String name) {
        super(name);
    }

    @Override
    protected String getBundleName() {
        return BUNDLE_ID;
    }

    public void testSessionDAbsenceThroughLogin() {
        try {
            LoginTest loginTest = new LoginTest("LoginTest");
            JSONObject jsonObject = BundleTestSessionD.login(this.getWebConversation(), loginTest.getHostName(), loginTest.getLogin(), loginTest.getPassword());
            BundleTestSessionD.assertTrue((String)"No error contained in returned JSON object", (jsonObject.has("error") && !jsonObject.isNull("error") ? 1 : 0) != 0);
            BundleTestSessionD.assertTrue((String)"Missing error code", (jsonObject.has("code") && !jsonObject.isNull("code") ? 1 : 0) != 0);
            BundleTestSessionD.assertTrue((String)("Unexpected error code: " + jsonObject.getString("code")), (boolean)"LGI-0005".equals(jsonObject.get("code")));
        }
        catch (Exception e) {
            e.printStackTrace();
            BundleTestSessionD.fail((String)e.getMessage());
        }
    }

    public void testSessionDAbsence() {
        try {
            this.startBundle.start(BUNDLE_ID);
            LoginTest loginTest = new LoginTest("LoginTest");
            JSONObject loginObject = BundleTestSessionD.login(this.getWebConversation(), loginTest.getHostName(), loginTest.getLogin(), loginTest.getPassword());
            BundleTestSessionD.assertTrue((String)"Error contained in returned JSON object", (!loginObject.has("error") || loginObject.isNull("error") ? 1 : 0) != 0);
            BundleTestSessionD.assertTrue((String)"Error contained in returned JSON object", (loginObject.has("session") && !loginObject.isNull("session") ? 1 : 0) != 0);
            this.stopBundle.stop(BUNDLE_ID);
            String sessionId = loginObject.getString("session");
            JSONObject jsonObject = BundleTestSessionD.getRootFolders(this.getWebConversation(), loginTest.getHostName(), sessionId);
            BundleTestSessionD.assertTrue((String)"No error contained in returned JSON object", (jsonObject.has("error") && !jsonObject.isNull("error") ? 1 : 0) != 0);
            BundleTestSessionD.assertTrue((String)"Missing error code", (jsonObject.has("code") && !jsonObject.isNull("code") ? 1 : 0) != 0);
            BundleTestSessionD.assertTrue((String)("Unexpected error code: " + jsonObject.getString("code")), (boolean)"SRV-0001".equals(jsonObject.get("code")));
            BundleTestSessionD.assertTrue((String)"Missing error parameters", (jsonObject.has("error_params") && !jsonObject.isNull("error_params") ? 1 : 0) != 0);
            JSONArray jArray = jsonObject.getJSONArray("error_params");
            BundleTestSessionD.assertTrue((String)("Unexpected error parameters: " + jArray), (jArray.length() == 1 && "com.openexchange.sessiond.SessiondService".equals(jArray.getString(0)) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            BundleTestSessionD.fail((String)e.getMessage());
        }
    }
}

