/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.test.fixtures.DefaultFixtures;
import com.openexchange.test.fixtures.Document;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import com.openexchange.test.fixtures.transformators.CredentialsTransformator;
import com.openexchange.test.fixtures.transformators.Transformator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class DocumentFixtureFactory
implements FixtureFactory<Document> {
    private final File datapath;
    private String seleniumDataPath;
    private String seleniumSeparator;
    private final FixtureLoader fixtureLoader;

    public DocumentFixtureFactory(File datapath, FixtureLoader fixtureLoader) {
        this.datapath = datapath;
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Fixtures<Document> createFixture(String fixtureName, Map<String, Map<String, String>> entries) {
        DocumentFixtures documentFixtures = new DocumentFixtures(fixtureName, entries, this.datapath, this.fixtureLoader);
        if (this.seleniumDataPath != null) {
            documentFixtures.setSeleniumConfiguration(this.seleniumDataPath, this.seleniumSeparator);
        }
        return documentFixtures;
    }

    public void setSeleniumConfiguration(String seleniumDataPath, String seleniumSeparator) {
        this.seleniumDataPath = seleniumDataPath;
        this.seleniumSeparator = seleniumSeparator;
    }

    private class DocumentFixtures
    extends DefaultFixtures<Document>
    implements Fixtures<Document> {
        private final Map<String, Map<String, String>> entries;
        private final Map<String, Fixture<Document>> knownDocuments;
        private final File datapath;
        private String seleniumDataPath;
        private String seleniumSeparator;

        public DocumentFixtures(String fixtureName, Map<String, Map<String, String>> values, File datapath, FixtureLoader fixtureLoader) {
            super(Document.class, values, fixtureLoader);
            this.knownDocuments = new HashMap<String, Fixture<Document>>();
            this.entries = values;
            this.datapath = datapath;
            super.addTransformator((Transformator)new CredentialsTransformator(fixtureLoader), "created_by");
        }

        @Override
        public Fixture<Document> getEntry(String entryName) throws OXException {
            if (this.knownDocuments.containsKey(entryName)) {
                return this.knownDocuments.get(entryName);
            }
            Map<String, String> values = this.entries.get(entryName);
            if (null == values) {
                throw new FixtureException("Entry with name " + entryName + " not found");
            }
            Document document = new Document(this.datapath);
            this.apply(document, values);
            if (this.seleniumDataPath != null) {
                document.setSeleniumConfiguration(this.seleniumDataPath, this.seleniumSeparator);
            }
            Fixture<Document> fixture = new Fixture<Document>(document, values.keySet().toArray(new String[values.size()]), values);
            this.knownDocuments.put(entryName, fixture);
            return fixture;
        }

        public void setSeleniumConfiguration(String seleniumDataPath, String seleniumSeparator) {
            this.seleniumDataPath = seleniumDataPath;
            this.seleniumSeparator = seleniumSeparator;
        }
    }
}

