/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import org.json.JSONArray;
import org.json.JSONObject;

public class MailTNEFStructureTest
extends AbstractMailTest {
    private static final byte[] SIMPLE = "From: postmaster@integralis.com\nTo: martin.kauss@open-xchange.com\nDate: Wed, 10 Feb 2010 16:18:27 +0000\nMIME-Version: 1.0\nX-DSNContext: 335a7efd - 4523 - 00000001 - 80040546\nMessage-ID: <FrMGaJe3s00001a1a@the-exch-bh.ai.pri>\nSubject: Delivery Status Notification (Failure)\nX-OriginalArrivalTime: 10 Feb 2010 16:18:27.0773 (UTC) FILETIME=[AD833ED0:01CAAA6C]\nContent-Type: multipart/report; report-type=delivery-status;\n    boundary=\"9B095B5ADSN=_01CA9AE238EA8D2400001AE0the?exch?bh.ai.p\"\nX-purgate-ID: expurgator32/1265818709-0000735A-7BA32A72/0-0/0-18\nX-purgate-size: 5390\nX-purgate-type: clean.bounce\nX-purgate-Ad: Categorized by eleven eXpurgate (R) http://www.eleven.de\nX-purgate: This mail is considered clean (visit http://www.eleven.de for further information)\nX-purgate: clean\n\nThis is a MIME-formatted message.  \nPortions of this message may be unreadable without a MIME-capable mail program.\n\n--9B095B5ADSN=_01CA9AE238EA8D2400001AE0the?exch?bh.ai.p\nContent-Type: text/plain; charset=unicode-1-1-utf-7\n\nThis is an automatically generated Delivery Status Notification.\n\nDelivery to the following recipients failed.\n\n       bill.wohlars@integralis.com\n\n\n\n\n--9B095B5ADSN=_01CA9AE238EA8D2400001AE0the?exch?bh.ai.p\nContent-Type: message/delivery-status\n\nReporting-MTA: dns;the-exch-bh.ai.pri\nReceived-From-MTA: dns;the-msw-scanner.integralis.com\nArrival-Date: Wed, 10 Feb 2010 16:18:27 +0000\n\nOriginal-Recipient: rfc822;bill.wohlars@integralis.com\nFinal-Recipient: rfc822;bill.wohlars@integralis.com\nAction: failed\nStatus: 5.1.1\n\n--9B095B5ADSN=_01CA9AE238EA8D2400001AE0the?exch?bh.ai.p\nContent-Type: message/rfc822\n\nReceived: from the-msw-scanner.integralis.com ([195.66.81.55]) by the-exch-bh.ai.pri with Microsoft SMTPSVC(6.0.3790.3959);\n     Wed, 10 Feb 2010 16:18:27 +0000\nReceived: from keys.articon-integralis.com (unverified) by the-msw-scanner.integralis.com\n (Clearswift SMTPRS 5.2.5) with ESMTP id <T93c51686e7c34251371ba0@the-msw-scanner.integralis.com> for <bill.wohlars@integralis.com>;\n Wed, 10 Feb 2010 16:19:40 +0000\nReceived: from ixe-mta-20.emailfiltering.com ([194.116.199.214])\n  by keys.articon-integralis.com (PGP Universal service);\n  Wed, 10 Feb 2010 16:18:27 +0000\nX-PGP-Universal: processed;\n    by keys.articon-integralis.com on Wed, 10 Feb 2010 16:18:27 +0000\nReceived: from alcatraz.open-xchange.com ([217.6.212.138])\n    by ixe-mta-20.emailfiltering.com with emfmta (version 4.3.0.64.1.rd-3.2.3-libc2.3.2) vanilla id 23744690\n    for bill.wohlars@integralis.com; Wed, 10 Feb 2010 16:18:25 +0000\nReceived: from localhost (localhost [127.0.0.1])\n    by mail.open-xchange.com (Postfix) with ESMTP id 5AC1728016\n    for <bill.wohlars@Integralis.Com>; Wed, 10 Feb 2010 17:18:24 +0100 (CET)\nReceived: from mail.open-xchange.com ([127.0.0.1])\n    by localhost (mail.open-xchange.com [127.0.0.1]) (amavisd-new, port 10024)\n    with ESMTP id Kdqq7R9ZAgY6 for <bill.wohlars@Integralis.Com>;\n    Wed, 10 Feb 2010 17:18:24 +0100 (CET)\nReceived: by mail.open-xchange.com (Postfix, from userid 1001)\n    id D17152801A; Wed, 10 Feb 2010 17:18:23 +0100 (CET)\nX-Spam-Checker-Version: SpamAssassin 3.2.3 (2007-08-08) on\n    mail.open-xchange.com\nX-Spam-Level: \nX-Spam-Status: No, score=-0.7 required=5.0 tests=AWL,BAYES_40,MISSING_MIMEOLE,\n    MSGID_MULTIPLE_AT,RDNS_NONE autolearn=no version=3.2.3\nReceived: from ox.open-xchange.com (ox.open-xchange.com [10.20.30.100])\n    by mail.open-xchange.com (Postfix) with ESMTP id 7F0C72801A\n    for <bill.wohlars@Integralis.Com>; Wed, 10 Feb 2010 17:18:17 +0100 (CET)\nReceived: from localhost (localhost.localdomain [127.0.0.1])\n    by ox.open-xchange.com (Postfix) with ESMTP id 8E3CB2AC4009\n    for <bill.wohlars@Integralis.Com>; Wed, 10 Feb 2010 17:18:17 +0100 (CET)\nReceived: from ox.open-xchange.com ([127.0.0.1])\n    by localhost (ox.open-xchange.com [127.0.0.1]) (amavisd-new, port 10024)\n    with ESMTP id jMA81NK7+YQv for <bill.wohlars@Integralis.Com>;\n    Wed, 10 Feb 2010 17:18:17 +0100 (CET)\nReceived: from gate4 (unknown [62.225.134.174])\n    by ox.open-xchange.com (Postfix) with ESMTP id 3FACB2AC4008\n    for <bill.wohlars@Integralis.Com>; Wed, 10 Feb 2010 17:18:17 +0100 (CET)\nFrom: \"Martin Kauss\" <martin.kauss@open-xchange.com>\nTo: \"'Bill Wohlars'\" <bill.wohlars@Integralis.Com>\nSubject: =?Windows-1252?Q?Lesebest=E4tigung:_An_idea_addressing_your_increasing_co?=\n    =?Windows-1252?Q?st?=\nDate: Wed, 10 Feb 2010 17:18:04 +0100\nMessage-ID: <000801caaa6c$a76403e0$f62c0ba0$@kauss@open-xchange.com>\nMIME-Version: 1.0\nX-Priority: 1 (Highest)\nX-MSMail-Priority: High\nX-Mailer: Microsoft Office Outlook 12.0\nX-MS-TNEF-Correlator: 00000000161985588D741D4085C9E6F5FFB923E5C4326100\nthread-index: AcmhwxbSK+hp2QcQSnC/nECdaY3GhEIp4t3S\nImportance: High\nReturn-Path: martin.kauss@open-xchange.com\nX-OriginalArrivalTime: 10 Feb 2010 16:18:27.0340 (UTC) FILETIME=[AD412CC0:01CAAA6C]\nContent-Type: application/ms-tnef;\n    name=\"winmail.dat\"\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment;\n    filename=\"winmail.dat\"\n\neJ8+IhEQAQaQCAAEAAAAAAABAAEAAQeQBgAIAAAA5AQAAAAAAADoAAEIgAcAIAAAAElQTS5NaWNy\nb3NvZnQgTWFpbC5SZWFkIFJlY2VpcHQAAwsBCoABACEAAAAzQ0ZEQkNENjY5QjRBOTRCQTk1ODkx\nMjBEM0I4NEJBRQB0BwEDkAYAlAIAABgAAAALACkAAAAAAEAAMgBAHkaiaqrKAR4ASQABAAAAKAAA\nAEFuIGlkZWEgYWRkcmVzc2luZyB5b3VyIGluY3JlYXNpbmcgY29zdAACAUwAAQAAAHQAAAAAAAAA\ngSsfpL6jEBmdbgDdAQ9UAgAAAYBCAGkAbABsACAAVwBvAGgAbABhAHIAcwAAAFMATQBUAFAAAABi\nAGkAbABsAC4AdwBvAGgAbABhAHIAcwBAAEkAbgB0AGUAZwByAGEAbABpAHMALgBDAG8AbQAAAB4A\nTQABAAAADQAAAEJpbGwgV29obGFycwAAAABAAE4AgAfNFsOhyQFAAFUAAEGhi8WhyQEeAHAAAQAA\nACgAAABBbiBpZGVhIGFkZHJlc3NpbmcgeW91ciBpbmNyZWFzaW5nIGNvc3QAAgFxAAEAAAAbAAAA\nAcmhwxbSK+hp2QcQSnC/nECdaY3GhEIp4t3SAB4AcgABAAAAAQAAAAAAAAAeAHMAAQAAAAEAAAAA\nAAAAHgB0AAEAAAAeAAAATWFydGluLmthdXNzQG9wZW4teGNoYW5nZS5jb20AAAALAAgMAAAAAAsA\nAQ4BAAAAAwAUDgEAAAAeAAEQAQAAABIAAAB3dXJkZSBnZWxlc2VuIGFtOgAAAAsAHw4BAAAAAgH4\nDwEAAAAQAAAAFhmFWI10HUCFyeb1/7kj5QIB+g8BAAAAEAAAABYZhViNdB1Ahcnm9f+5I+UDAP4P\nBQAAAAMADTT9P6UGAwAPNP0/pQYCARQ0AQAAABAAAABOSVRB+b+4AQCqADfZbgAAAgF/AAEAAAAx\nAAAAMDAwMDAwMDAxNjE5ODU1ODhENzQxRDQwODVDOUU2RjVGRkI5MjNFNUM0MzI2MTAwAAAAAIOS\n\n\n\n--9B095B5ADSN=_01CA9AE238EA8D2400001AE0the?exch?bh.ai.p--".getBytes();

    public MailTNEFStructureTest() {
    }

    public MailTNEFStructureTest(String name) {
        super(name);
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])SIMPLE);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            MailTNEFStructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            Object bodyObject = jsonMailObject.opt("body");
            MailTNEFStructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
            MailTNEFStructureTest.assertTrue((String)"Body object is not a JSON array.", (boolean)(bodyObject instanceof JSONArray));
            JSONArray jsonBodyObject = (JSONArray)bodyObject;
            JSONObject nestedMessage = jsonBodyObject.getJSONObject(2);
            JSONObject headers = nestedMessage.getJSONObject("headers");
            JSONObject ct = headers.getJSONObject("content-type");
            MailTNEFStructureTest.assertTrue((String)"Should be a nested message, but isn't.", (boolean)"message/rfc822".equalsIgnoreCase(ct.getString("type")));
        }
        catch (Exception e) {
            e.printStackTrace();
            MailTNEFStructureTest.fail((String)e.getMessage());
        }
    }
}

