/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.messagestorage;

import com.openexchange.exception.OXException;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.messagestorage.MessageStorageTest;
import java.util.Arrays;
import java.util.HashSet;

public final class MailDeleteTest
extends MessageStorageTest {
    private static final MailField[] FIELDS_ID = new MailField[]{MailField.ID};
    private static final MailField[] FIELDS_EVEN_MORE = new MailField[]{MailField.ID, MailField.CONTENT_TYPE, MailField.FLAGS, MailField.FROM, MailField.TO, MailField.DISPOSITION_NOTIFICATION_TO, MailField.COLOR_LABEL, MailField.HEADERS, MailField.SUBJECT, MailField.THREAD_LEVEL, MailField.SIZE, MailField.PRIORITY, MailField.SENT_DATE, MailField.RECEIVED_DATE, MailField.CC, MailField.BCC, MailField.FOLDER_ID};

    public void testMailDeleteNonExistingMails() throws OXException {
        try {
            long currentTimeMillis = System.currentTimeMillis();
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", new String[]{String.valueOf(currentTimeMillis), String.valueOf(currentTimeMillis + 1L)}, true);
        }
        catch (Exception e) {
            MailDeleteTest.fail((String)("No Exception should be thrown here. Exception was " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailDeleteNonExistingMailsMixed() throws OXException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            long currentTimeMillis = System.currentTimeMillis();
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", new String[]{String.valueOf(currentTimeMillis), uids[0]}, true);
            MailMessage message = this.mailAccess.getMessageStorage().getMessage("INBOX", uids[0], true);
            MailDeleteTest.assertTrue((String)"The message which should be deleted in the mixed delete test, isn't deleted.", (null == message ? 1 : 0) != 0);
        }
        catch (Exception e) {
            MailDeleteTest.fail((String)("No Exception should be thrown here. Exception was " + e.getMessage()));
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailDeleteNonExistingFolder() throws OXException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            this.mailAccess.getMessageStorage().deleteMessages("NonExistingFolder1337", uids, true);
        }
        catch (OXException e) {
            MailDeleteTest.assertTrue((String)"Wrong Exception is thrown.", (boolean)e.getErrorCode().endsWith("-1002"));
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailDelete() throws OXException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        Object[] trashedIDs = null;
        try {
            boolean countCap;
            String trashFullname = this.mailAccess.getFolderStorage().getTrashFolder();
            int prevMessageCount = this.getMessageCount(this.mailAccess, trashFullname);
            MailMessage[] trashed = this.mailAccess.getMessageStorage().getAllMessages(trashFullname, IndexRange.NULL, MailSortField.RECEIVED_DATE, OrderDirection.DESC, FIELDS_ID);
            HashSet<String> prevIds = new HashSet<String>();
            for (MailMessage mail : trashed) {
                prevIds.add(mail.getMailId());
            }
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, false);
            boolean bl = countCap = this.getMessageCount(this.mailAccess, trashFullname) >= 0;
            if (countCap) {
                MailDeleteTest.assertTrue((String)"Trash's number of message has not been increased appropriately", (prevMessageCount + uids.length == this.getMessageCount(this.mailAccess, trashFullname) ? 1 : 0) != 0);
                trashed = this.mailAccess.getMessageStorage().getAllMessages(trashFullname, IndexRange.NULL, MailSortField.RECEIVED_DATE, OrderDirection.DESC, FIELDS_ID);
                MailDeleteTest.assertTrue((String)("Size mismatch: " + trashed.length + " but should be " + this.getMessageCount(this.mailAccess, trashFullname)), (trashed.length == this.getMessageCount(this.mailAccess, trashFullname) ? 1 : 0) != 0);
                HashSet<String> ids = new HashSet<String>(this.getMessageCount(this.mailAccess, trashFullname));
                for (MailMessage mail : trashed) {
                    ids.add(mail.getMailId());
                }
                ids.removeAll(prevIds);
                MailDeleteTest.assertTrue((String)("Size mismatch: " + ids.size() + " but should be " + uids.length), (ids.size() == uids.length ? 1 : 0) != 0);
                trashedIDs = new String[uids.length];
                int k = 0;
                for (String id : ids) {
                    trashedIDs[k++] = id;
                }
                trashed = this.mailAccess.getMessageStorage().getMessages(trashFullname, (String[])trashedIDs, FIELDS_EVEN_MORE);
                MailDeleteTest.assertTrue((String)("No matching trashed messages found: " + (null == trashed ? "null" : String.valueOf(trashed.length)) + " IDs: " + Arrays.toString(trashedIDs)), (trashed != null && trashed.length == uids.length ? 1 : 0) != 0);
                for (int i = 0; i < trashed.length; ++i) {
                    MailDeleteTest.assertFalse((String)"Missing mail ID", (trashed[i].getMailId() == null ? 1 : 0) != 0);
                    MailDeleteTest.assertTrue((String)"Missing content type", (boolean)trashed[i].containsContentType());
                    MailDeleteTest.assertTrue((String)"Missing flags", (boolean)trashed[i].containsFlags());
                    MailDeleteTest.assertTrue((String)"Missing From", (boolean)trashed[i].containsFrom());
                    MailDeleteTest.assertTrue((String)"Missing To", (boolean)trashed[i].containsTo());
                    MailDeleteTest.assertTrue((String)"Missing Disposition-Notification-To", (boolean)trashed[i].containsDispositionNotification());
                    MailDeleteTest.assertTrue((String)"Missing color label", (boolean)trashed[i].containsColorLabel());
                    MailDeleteTest.assertTrue((String)"Missing headers", (boolean)trashed[i].containsHeaders());
                    MailDeleteTest.assertTrue((String)"Missing subject", (boolean)trashed[i].containsSubject());
                    MailDeleteTest.assertTrue((String)"Missing thread level", (boolean)trashed[i].containsThreadLevel());
                    MailDeleteTest.assertTrue((String)"Missing size", (boolean)trashed[i].containsSize());
                    MailDeleteTest.assertTrue((String)"Missing priority", (boolean)trashed[i].containsPriority());
                    MailDeleteTest.assertTrue((String)"Missing sent date", (boolean)trashed[i].containsSentDate());
                    MailDeleteTest.assertTrue((String)"Missing received date", (boolean)trashed[i].containsReceivedDate());
                    MailDeleteTest.assertTrue((String)"Missing Cc", (boolean)trashed[i].containsCc());
                    MailDeleteTest.assertTrue((String)"Missing Bcc", (boolean)trashed[i].containsBcc());
                    MailDeleteTest.assertTrue((String)"Missing folder fullname", (boolean)trashed[i].containsFolder());
                }
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
            if (trashedIDs != null) {
                this.mailAccess.getMessageStorage().deleteMessages(this.mailAccess.getFolderStorage().getTrashFolder(), trashedIDs, true);
            }
        }
    }
}

