/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.calendar.CalendarAdministration;
import com.openexchange.calendar.CalendarSql;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.Participants;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.downgrade.DowngradeEvent;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.setuptools.TestFolderToolkit;
import com.openexchange.tools.events.EventAssertions;
import com.openexchange.tools.events.TestEventAdmin;
import com.openexchange.tools.oxfolder.OXFolderManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;

public class CalendarDowngradeUserTest
extends TestCase {
    private int user;
    private int other_user;
    private Context ctx;
    private Session session;
    private int publicFolderId = -1;
    private static TestContextToolkit tools = new TestContextToolkit();
    private static TestFolderToolkit folders = new TestFolderToolkit();
    private final List<CalendarDataObject> clean = new LinkedList<CalendarDataObject>();
    private final List<FolderObject> cleanFolders = new LinkedList<FolderObject>();

    public void setUp() throws Exception {
        Init.startServer();
        AJAXConfig.init();
        TestEventAdmin.getInstance().clearEvents();
        this.ctx = tools.getDefaultContext();
        this.user = tools.resolveUser(AJAXConfig.getProperty(AJAXConfig.Property.LOGIN), this.ctx);
        this.other_user = tools.resolveUser(AJAXConfig.getProperty(AJAXConfig.Property.SECONDUSER), this.ctx);
        this.session = SessionObjectWrapper.createSessionObject((int)this.user, (Context)this.ctx, (String)"calendarDeleteUserDataTest");
    }

    public void tearDown() throws Exception {
        this.deleteAll();
        Init.stopServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDelete(int user) {
        UserConfiguration config = new UserConfiguration(new HashSet(), user, tools.getGroups(user, this.ctx), this.ctx);
        Connection con = null;
        try {
            con = DBPool.pickupWriteable((Context)this.ctx);
            DowngradeEvent event = new DowngradeEvent(config, con, this.ctx);
            new CalendarAdministration().downgradePerformed(event);
        }
        catch (OXException x) {
            x.printStackTrace();
            CalendarDowngradeUserTest.fail((String)x.getMessage());
        }
        finally {
            if (con != null) {
                DBPool.pushWrite((Context)this.ctx, (Connection)con);
            }
        }
    }

    public void testRemovePrivate() throws OXException {
        CalendarDataObject cdao = this.createPrivateAppointment(this.user);
        this.runDelete(this.user);
        this.assertAppointmentNotFound(cdao.getParentFolderID(), cdao.getObjectID());
        EventAssertions.assertDeleteEvent(Appointment.class, cdao.getParentFolderID(), cdao.getObjectID());
    }

    public void testRemoveFromParticipants() throws OXException {
        CalendarDataObject cdao = this.createPublicAppointmentWithSomeoneElse(this.user, this.other_user);
        this.runDelete(this.user);
        this.assertNotInUserParticipants(cdao.getParentFolderID(), cdao.getObjectID(), this.user);
        EventAssertions.assertModificationEvent(Appointment.class, cdao.getParentFolderID(), cdao.getObjectID());
    }

    public void testRemoveAppointmentWhenOnlyParticipant() throws OXException {
        CalendarDataObject cdao = this.createPublicAppointmentWithOnlyOneParticipant(this.user);
        this.runDelete(this.user);
        this.assertAppointmentNotFound(cdao.getParentFolderID(), cdao.getObjectID());
        EventAssertions.assertDeleteEvent(Appointment.class, cdao.getParentFolderID(), cdao.getObjectID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAll() {
        CalendarSql calendars = new CalendarSql(this.session);
        for (CalendarDataObject cdao : this.clean) {
            try {
                calendars.deleteAppointmentObject(cdao, cdao.getParentFolderID(), new Date(Long.MAX_VALUE));
            }
            catch (OXException oXException) {}
        }
        Connection writecon = null;
        try {
            writecon = DBPool.pickupWriteable((Context)this.ctx);
            OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session, (AppointmentSQLInterface)calendars, (Connection)writecon, (Connection)writecon);
            for (FolderObject folder : this.cleanFolders) {
                oxma.deleteFolder(folder, false, System.currentTimeMillis());
            }
        }
        catch (OXException oXException) {
        }
        finally {
            if (writecon != null) {
                DBPool.pushWrite((Context)this.ctx, (Connection)writecon);
            }
        }
    }

    private CalendarDataObject newAppointment(String title, int folder, Context ctx) {
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle(title);
        cdao.setParentFolderID(folder);
        cdao.setIgnoreConflicts(true);
        cdao.setStartDate(new Date(0L));
        cdao.setEndDate(new Date(3600000L));
        cdao.setContext(ctx);
        return cdao;
    }

    private CalendarDataObject createPrivateAppointment(int userId) throws OXException {
        CalendarDataObject cdao = this.newAppointment("Private appointment", folders.getStandardFolder(userId, this.ctx), this.ctx);
        CalendarSql csql = new CalendarSql(this.session);
        csql.insertAppointmentObject(cdao);
        this.clean.add(cdao);
        return cdao;
    }

    private CalendarDataObject createPublicAppointmentWithSomeoneElse(int user, int other_user) throws OXException {
        int publicFolder = this.createPublicFolder();
        CalendarDataObject cdao = this.newAppointment("Public appointment  with two participants", publicFolder, this.ctx);
        this.setParticipants(cdao, user, other_user);
        CalendarSql csql = new CalendarSql(this.session);
        csql.insertAppointmentObject(cdao);
        this.clean.add(cdao);
        return cdao;
    }

    private CalendarDataObject createPublicAppointmentWithOnlyOneParticipant(int user) throws OXException {
        int publicFolder = this.createPublicFolder();
        CalendarDataObject cdao = this.newAppointment("Public appointment with only one participant", publicFolder, this.ctx);
        this.setParticipants(cdao, user);
        CalendarSql csql = new CalendarSql(this.session);
        csql.insertAppointmentObject(cdao);
        this.clean.add(cdao);
        return cdao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createPublicFolder() throws OXException {
        if (this.publicFolderId != -1) {
            return this.publicFolderId;
        }
        Connection writecon = null;
        try {
            writecon = DBPool.pickupWriteable((Context)this.ctx);
            OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session, (Connection)writecon, (Connection)writecon);
            OCLPermission oclp = new OCLPermission();
            oclp.setEntity(this.user);
            oclp.setAllPermission(128, 128, 128, 128);
            oclp.setFolderAdmin(true);
            FolderObject fo = new FolderObject();
            fo.setFolderName("Public Folder " + System.currentTimeMillis());
            fo.setParentFolderID(2);
            fo.setModule(2);
            fo.setType(2);
            fo.setPermissionsAsArray(new OCLPermission[]{oclp});
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            this.cleanFolders.add(fo);
            int n = this.publicFolderId = fo.getObjectID();
            return n;
        }
        catch (OXException e) {
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            if (writecon != null) {
                DBPool.pushWrite((Context)this.ctx, (Connection)writecon);
            }
        }
    }

    private void setParticipants(CalendarDataObject cdao, int ... users) {
        Participants participants = new Participants();
        for (int uid : users) {
            participants.add(new UserParticipant(uid));
        }
        cdao.setParticipants(participants.getList());
    }

    private void assertAppointmentNotFound(int parentFolderID, int objectID) {
        CalendarSql csql = new CalendarSql(this.session);
        try {
            csql.getObjectById(objectID, parentFolderID);
            CalendarDowngradeUserTest.fail((String)"The appointment exists!");
        }
        catch (OXException x) {
            if (x.getCode() != 1) {
                x.printStackTrace();
                CalendarDowngradeUserTest.fail((String)x.toString());
            }
        }
        catch (SQLException x) {
            x.printStackTrace();
            CalendarDowngradeUserTest.fail((String)x.toString());
        }
    }

    private void assertNotInUserParticipants(int parentFolderID, int objectID, int user) {
        CalendarSql csql = new CalendarSql(this.session);
        try {
            CalendarDataObject cdao = csql.getObjectById(objectID, parentFolderID);
            for (Participant participant : cdao.getParticipants()) {
                if (participant.getType() != 1 || user != participant.getIdentifier()) continue;
                CalendarDowngradeUserTest.fail((String)("Participants should not contain user " + user));
            }
        }
        catch (OXException x) {
            x.printStackTrace();
            CalendarDowngradeUserTest.fail((String)x.toString());
        }
        catch (SQLException x) {
            x.printStackTrace();
            CalendarDowngradeUserTest.fail((String)x.toString());
        }
    }
}

