/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware;

import com.openexchange.calendar.CalendarMySQL;
import com.openexchange.calendar.CalendarSql;
import com.openexchange.calendar.api.AppointmentSqlFactory;
import com.openexchange.calendar.api.CalendarCollection;
import com.openexchange.event.impl.EventConfigImpl;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.AppointmentBugTests;
import com.openexchange.groupware.CalendarTest;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.RecurringResultInterface;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.Participants;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.test.AjaxInit;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;
import junit.framework.TestCase;

public class CalendarRecurringTests
extends TestCase {
    public static final String TIMEZONE = "Europe/Berlin";
    private static int userid = 11;
    public static int contextid = 1;
    private static boolean init = false;

    protected void setUp() throws Exception {
        super.setUp();
        Init.startServer();
        init = true;
        TestConfig config = new TestConfig();
        String userName = config.getUser();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        Context ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        int user = tools.resolveUser(userName, ctx);
        EventConfigImpl event = new EventConfigImpl();
        event.setEventQueueEnabled(false);
        contextid = ctx.getContextId();
        userid = user;
        ContextStorage.start();
        CalendarMySQL.setApppointmentSqlFactory((AppointmentSqlFactoryService)new AppointmentSqlFactory());
    }

    protected void tearDown() throws Exception {
        if (init) {
            init = false;
            Init.stopServer();
        }
        super.tearDown();
    }

    private static Properties getAJAXProperties() {
        Properties properties = AjaxInit.getAJAXProperties();
        return properties;
    }

    private static int resolveUser(String u) throws Exception {
        UserStorage uStorage = UserStorage.getInstance();
        return uStorage.getUserId(u, CalendarRecurringTests.getContext());
    }

    public static int getUserId() throws Exception {
        if (!init) {
            Init.startServer();
            init = true;
        }
        String user = AbstractConfigWrapper.parseProperty((Properties)CalendarRecurringTests.getAJAXProperties(), (String)"user_participant2", (String)"");
        return CalendarRecurringTests.resolveUser(user);
    }

    public static Context getContext() {
        return new ContextImpl(contextid);
    }

    public static int getPrivateFolder() throws Exception {
        int privatefolder = 0;
        Context context = CalendarRecurringTests.getContext();
        privatefolder = CalendarTest.getCalendarDefaultFolderForUser(userid, context);
        return privatefolder;
    }

    public void testBasicRecurring() throws Throwable {
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        CalendarRecurringTests.assertFalse((boolean)cdao.calculateRecurrence());
        cdao.setStartDate(new Date(0L));
        cdao.setEndDate(new Date(0L));
        cdao.setUntil(new Date(0L));
        cdao.setTitle("testBasicRecurring");
        cdao.setRecurrenceID(1);
        CalendarRecurringTests.assertFalse((boolean)cdao.calculateRecurrence());
        cdao.setRecurrenceType(1);
        CalendarRecurringTests.assertFalse((boolean)cdao.calculateRecurrence());
        cdao.setRecurrenceCalculator(1);
        CalendarRecurringTests.assertFalse((boolean)cdao.calculateRecurrence());
        cdao.setInterval(1);
        CalendarRecurringTests.assertTrue((boolean)cdao.calculateRecurrence());
    }

    public void testBasicRecurringWithOccurrence() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext((Context)context);
        cdao.setTimezone(TIMEZONE);
        CalendarTest.fillDatesInDao(cdao);
        cdao.removeUntil();
        cdao.setOccurrence(5);
        CalendarRecurringTests.assertFalse((String)"test if no until is set", (boolean)cdao.containsUntil());
        long l = cdao.getEndDate().getTime();
        new CalendarCollection().getClass();
        long test_until = l + 86400000L * 4L;
        test_until += (long)TimeZone.getTimeZone(TIMEZONE).getOffset(test_until);
        test_until = new CalendarCollection().normalizeLong(test_until);
        cdao.setTitle("testBasicRecurringWithOccurrence");
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        new CalendarCollection().fillDAO(cdao);
        CalendarRecurringTests.assertEquals((String)"Check correct until for tis Occurrence", (long)test_until, (long)cdao.getUntil().getTime());
        cdao.setParentFolderID(fid);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        cdao.removeUntil();
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject test_dao = csql.getObjectById(object_id, fid);
        CalendarRecurringTests.assertEquals((String)"Check correct Occurrence value", (int)5, (int)test_dao.getOccurrence());
        new CalendarCollection().fillDAO(cdao);
    }

    public void testBasicRecurringWithoutUntilAndWithoutOccurrence() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext((Context)context);
        cdao.setTimezone(TIMEZONE);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("testBasicRecurringWithoutUntilAndWithoutOccurrence");
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        new CalendarCollection().fillDAO(cdao);
        cdao.removeUntil();
        CalendarRecurringTests.assertFalse((String)"test if no until is set", (boolean)cdao.containsUntil());
        CalendarRecurringTests.assertFalse((String)"test if no Occurrence is set", (boolean)cdao.containsOccurrence());
        int years = new CalendarCollection().getMAX_END_YEARS();
        long test_until = this.addYears(cdao.getEndDate().getTime(), years);
        test_until = new CalendarCollection().normalizeLong(test_until);
        CalendarDataObject clone = cdao.clone();
        try {
            RecurringResultsInterface rresults = new CalendarCollection().calculateRecurring((CalendarObject)clone, 0L, 0L, 0);
            RecurringResultInterface rresult = rresults.getRecurringResultByPosition(999);
            if (rresult != null) {
                test_until = new CalendarCollection().normalizeLong(rresult.getEnd());
            }
        }
        catch (OXException rresult) {
            // empty catch block
        }
        CalendarRecurringTests.assertEquals((String)"Check correct until for tis Occurrence", (long)test_until, (long)cdao.getUntil().getTime());
        cdao.setParentFolderID(fid);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject test_dao = csql.getObjectById(object_id, fid);
        CalendarRecurringTests.assertFalse((String)"test if no Occurrence is set", (boolean)test_dao.containsOccurrence());
    }

    public void testBasicRecurringWithoutUntil() throws Throwable {
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        CalendarRecurringTests.assertFalse((boolean)cdao.calculateRecurrence());
        cdao.setStartDate(new Date(0L));
        cdao.setEndDate(new Date(0L));
        cdao.setTitle("Basic Recurring Test");
        cdao.setRecurrenceID(1);
        CalendarRecurringTests.assertFalse((boolean)cdao.calculateRecurrence());
        cdao.setRecurrenceType(1);
        CalendarRecurringTests.assertFalse((boolean)cdao.calculateRecurrence());
        cdao.setRecurrenceCalculator(1);
        CalendarRecurringTests.assertFalse((boolean)cdao.calculateRecurrence());
        cdao.setInterval(1);
        CalendarRecurringTests.assertTrue((boolean)cdao.calculateRecurrence());
    }

    public void testDailyRecurring() throws Throwable {
        long s = 1149768000000L;
        long e = 1149771600000L;
        long u = 1150156800000L;
        long u_test = 1150106400000L;
        String testrecurrence = "t|1|i|1|s|1149768000000|e|1150156800000|";
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1149768000000L));
        cdao.setEndDate(new Date(1149771600000L));
        cdao.setUntil(new Date(1150106400000L));
        cdao.setTitle("Daily Appointment Test");
        cdao.setRecurrence("t|1|i|1|s|1149768000000|e|1150156800000|");
        cdao.setRecurrenceCalculator(1);
        cdao.setRecurrenceID(1);
        long pass_one_start = System.currentTimeMillis();
        new CalendarCollection().fillDAO(cdao);
        long pass_one_end = System.currentTimeMillis();
        long pass_one_time = pass_one_end - pass_one_start;
        long pass_two_start = System.currentTimeMillis();
        new CalendarCollection().fillDAO(cdao);
        long pass_two_end = System.currentTimeMillis();
        long pass_two_time = pass_two_end - pass_two_start;
        String check = new CalendarCollection().createDSString(cdao);
        CalendarRecurringTests.assertTrue((String)"Checking daily sequence", (boolean)check.equals("t|1|i|1|s|1149768000000|e|1150156800000|"));
        RecurringResultsInterface m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        CalendarRecurringTests.assertEquals((String)"Check calculation", (int)6, (int)m.size());
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 1);
        CalendarRecurringTests.assertEquals((String)"Check calculation", (int)1, (int)m.size());
        double percent = pass_two_time / 10L;
        percent = (double)(pass_one_time * 100L) / percent;
    }

    public void testDailyByPosition() throws Throwable {
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setTitle("Daily Appointment By Position Test");
        CalendarTest.fillDatesInDao(cdao);
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        new CalendarCollection().fillDAO(cdao);
        RecurringResultsInterface rrs = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        for (int a = 0; a < rrs.size(); ++a) {
            RecurringResultsInterface rrs_check = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, rrs.getRecurringResult(a).getPosition());
            RecurringResultInterface rr = rrs_check.getRecurringResult(0);
            CalendarRecurringTests.assertEquals((String)"Check correct recurrence position", (int)rrs.getRecurringResult(a).getPosition(), (int)rr.getPosition());
            CalendarRecurringTests.assertEquals((String)"Check correct start time", (long)rrs.getRecurringResult(a).getStart(), (long)rr.getStart());
            CalendarRecurringTests.assertTrue((String)"Check correct position calculation", (a + 1 == rr.getPosition() ? 1 : 0) != 0);
        }
    }

    public void testDailyRecurringWithDAO() throws Throwable {
        long s = 1149768000000L;
        long e = 1149771600000L;
        long u = 1150070400000L;
        long u_test = 1150106400000L;
        String testrecurrence = "t|1|i|1|s|1149768000000|e|1150070400000|";
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1149768000000L));
        cdao.setEndDate(new Date(1149771600000L));
        cdao.setUntil(new Date(1150106400000L));
        cdao.setTitle("Daily Appointment Test only with DAO");
        cdao.setRecurrenceCalculator(1);
        cdao.setRecurrenceID(1);
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        new CalendarCollection().fillDAO(cdao);
        String check = new CalendarCollection().createDSString(cdao);
        CalendarRecurringTests.assertTrue((String)"Checking daily sequence", (boolean)check.equals("t|1|i|1|s|1149768000000|e|1150070400000|"));
        RecurringResultsInterface m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        CalendarRecurringTests.assertEquals((String)"Check calculation", (int)5, (int)m.size());
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 1);
        CalendarRecurringTests.assertEquals((String)"Check calculation", (int)1, (int)m.size());
    }

    public void testWeeklyRecurrence() throws Throwable {
        long s = 1149768000000L;
        long e = 1149771600000L;
        long u = 1151100000000L;
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE));
        RecurringResultsInterface m = null;
        CalendarDataObject cdao = null;
        cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1149768000000L));
        cdao.setEndDate(new Date(1149771600000L));
        cdao.setUntil(new Date(1151100000000L));
        cdao.setTitle("Weekly Appointment Test");
        cdao.setRecurrenceCalculator(1);
        cdao.setRecurrenceID(1);
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(2);
        new CalendarCollection().fillDAO(cdao);
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 1);
        c.setTimeInMillis(new Date(m.getRecurringResult(0).getStart()).getTime());
        CalendarRecurringTests.assertEquals((String)"First day check (MONDAY)", (int)c.get(7), (int)2);
        cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1149768000000L));
        cdao.setEndDate(new Date(1149771600000L));
        cdao.setUntil(new Date(1151100000000L));
        cdao.setTitle("Weekly Appointment Test");
        cdao.setRecurrenceCalculator(1);
        cdao.setRecurrenceID(1);
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(1);
        new CalendarCollection().fillDAO(cdao);
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 1);
        c.setTimeInMillis(new Date(m.getRecurringResult(0).getStart()).getTime());
        CalendarRecurringTests.assertEquals((String)"First day check (SUNDAY)", (int)c.get(7), (int)1);
        cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1149768000000L));
        cdao.setEndDate(new Date(1149771600000L));
        cdao.setUntil(new Date(1151100000000L));
        cdao.setTitle("Weekly Appointment Test");
        cdao.setRecurrenceCalculator(1);
        cdao.setRecurrenceID(1);
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(4);
        new CalendarCollection().fillDAO(cdao);
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 1);
        c.setTimeInMillis(new Date(m.getRecurringResult(0).getStart()).getTime());
        CalendarRecurringTests.assertEquals((String)"First day check (TUESDAY)", (int)c.get(7), (int)3);
        cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1149768000000L));
        cdao.setEndDate(new Date(1149771600000L));
        cdao.setUntil(new Date(1151100000000L));
        cdao.setTitle("Weekly Appointment Test");
        cdao.setRecurrenceCalculator(1);
        cdao.setRecurrenceID(1);
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(8);
        new CalendarCollection().fillDAO(cdao);
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 1);
        c.setTimeInMillis(new Date(m.getRecurringResult(0).getStart()).getTime());
        CalendarRecurringTests.assertEquals((String)"First day check (WEDNESDAY)", (int)c.get(7), (int)4);
        cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1149768000000L));
        cdao.setEndDate(new Date(1149771600000L));
        cdao.setUntil(new Date(1151100000000L));
        cdao.setTitle("Weekly Appointment Test");
        cdao.setRecurrenceCalculator(1);
        cdao.setRecurrenceID(1);
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(16);
        new CalendarCollection().fillDAO(cdao);
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 1);
        c.setTimeInMillis(new Date(m.getRecurringResult(0).getStart()).getTime());
        CalendarRecurringTests.assertEquals((String)"First day check (THURSDAY)", (int)c.get(7), (int)5);
        cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1149768000000L));
        cdao.setEndDate(new Date(1149771600000L));
        cdao.setUntil(new Date(1151100000000L));
        cdao.setTitle("Weekly Appointment Test");
        cdao.setRecurrenceCalculator(1);
        cdao.setRecurrenceID(1);
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(32);
        new CalendarCollection().fillDAO(cdao);
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 1);
        c.setTimeInMillis(new Date(m.getRecurringResult(0).getStart()).getTime());
        CalendarRecurringTests.assertEquals((String)"First day check (FRIDAY)", (int)c.get(7), (int)6);
        cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1149768000000L));
        cdao.setEndDate(new Date(1149771600000L));
        cdao.setUntil(new Date(1151100000000L));
        cdao.setTitle("Weekly Appointment Test");
        cdao.setRecurrenceCalculator(1);
        cdao.setRecurrenceID(1);
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(64);
        new CalendarCollection().fillDAO(cdao);
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 1);
        c.setTimeInMillis(new Date(m.getRecurringResult(0).getStart()).getTime());
        CalendarRecurringTests.assertEquals((String)"First day check (SATURDAY)", (int)c.get(7), (int)7);
        cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1149768000000L));
        cdao.setEndDate(new Date(1149771600000L));
        cdao.setUntil(new Date(1151100000000L));
        cdao.setTitle("Weekly Appointment Test");
        cdao.setRecurrenceCalculator(1);
        cdao.setRecurrenceID(1);
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(18);
        new CalendarCollection().fillDAO(cdao);
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        CalendarRecurringTests.assertEquals((String)"Check calculation", (int)5, (int)m.size());
        c.setTimeInMillis(new Date(m.getRecurringResult(0).getStart()).getTime());
        CalendarRecurringTests.assertEquals((String)"First day check (THURSDAY)", (int)c.get(7), (int)5);
        c.setTimeInMillis(new Date(m.getRecurringResult(1).getStart()).getTime());
        CalendarRecurringTests.assertEquals((String)"First day check (MONDAY)", (int)c.get(7), (int)2);
        cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1149768000000L));
        cdao.setEndDate(new Date(1149771600000L));
        cdao.setUntil(new Date(1151100000000L));
        cdao.setTitle("Weekly Appointment Test");
        cdao.setRecurrenceCalculator(1);
        cdao.setRecurrenceID(1);
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(3);
        new CalendarCollection().fillDAO(cdao);
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        CalendarRecurringTests.assertEquals((String)"Check calculation", (int)4, (int)m.size());
        c.setTimeInMillis(new Date(m.getRecurringResult(0).getStart()).getTime());
        CalendarRecurringTests.assertEquals((String)"First day check (SUNDAY)", (int)c.get(7), (int)1);
        c.setTimeInMillis(new Date(m.getRecurringResult(1).getStart()).getTime());
        CalendarRecurringTests.assertEquals((String)"First day check (MONDAY)", (int)c.get(7), (int)2);
    }

    public void testSaveRecurring() throws Throwable {
        long e;
        long s;
        ContextImpl context = new ContextImpl(contextid);
        CalendarDataObject cdao = new CalendarDataObject();
        long cals = s = System.currentTimeMillis();
        new CalendarCollection().getClass();
        long calsmod = s % 86400000L;
        cals -= calsmod;
        long endcalc = 3600000L;
        long mod = s % 3600000L;
        long saves = s -= mod;
        long savee = e = s + 3600000L;
        new CalendarCollection().getClass();
        long u = s + 86400000L * 10L;
        new CalendarCollection().getClass();
        mod = u % 86400000L;
        u -= mod;
        Calendar start = Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE));
        start.setTimeInMillis(saves);
        Calendar ende = Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE));
        ende.setTimeInMillis(savee);
        cdao.setStartDate(new Date(s));
        cdao.setEndDate(new Date(e));
        cdao.setUntil(new Date(u));
        cdao.setTitle("testSaveRecurring");
        cdao.setRecurrenceType(1);
        cdao.setRecurrenceCalculator(1);
        cdao.setInterval(1);
        cdao.setParentFolderID(CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context));
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        RecurringResultsInterface rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, cals, u, 0);
        CalendarRecurringTests.assertEquals((String)"Testing size ", (int)rss.size(), (int)10);
        for (int a = 0; a < rss.size(); ++a) {
            RecurringResultInterface rs = rss.getRecurringResult(a);
            CalendarRecurringTests.assertEquals((String)"Testing start time", (long)rs.getStart(), (long)start.getTimeInMillis());
            CalendarRecurringTests.assertEquals((String)"Testing end time", (long)rs.getEnd(), (long)ende.getTimeInMillis());
            CalendarRecurringTests.assertEquals((String)"Testing Position", (int)(a + 1), (int)rs.getPosition());
            start.add(5, 1);
            ende.add(5, 1);
        }
    }

    public void testDeleteSingleRecurringAppointment() throws Throwable {
        long e;
        long s;
        ContextImpl context = new ContextImpl(contextid);
        CalendarDataObject cdao = new CalendarDataObject();
        long cals = s = TimeTools.D("04.10.2013 08:00").getTime();
        long calsmod = s % 86400000L;
        cals -= calsmod;
        long endcalc = 3600000L;
        long mod = s % 3600000L;
        long saves = s -= mod;
        long savee = e = s + 3600000L;
        long u = s + 864000000L;
        mod = u % 86400000L;
        u -= mod;
        Calendar start = Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE));
        start.setTimeInMillis(saves);
        Calendar ende = Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE));
        ende.setTimeInMillis(savee);
        String user2 = AbstractConfigWrapper.parseProperty((Properties)CalendarRecurringTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int uid2 = CalendarRecurringTests.resolveUser(user2);
        int folder_id = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        int folder_id2 = CalendarTest.getCalendarDefaultFolderForUser(uid2, (Context)context);
        cdao.setStartDate(new Date(s));
        cdao.setEndDate(new Date(e));
        cdao.setUntil(new Date(u));
        cdao.setTitle("testDeleteSingleRecurringAppointment - step 1 - insert ");
        cdao.setRecurrenceType(1);
        cdao.setRecurrenceCalculator(1);
        cdao.setInterval(1);
        cdao.setParentFolderID(folder_id);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)uid2, (int)context.getContextId(), (String)"myTestIdentifier");
        Participants p = new Participants();
        UserParticipant pa = new UserParticipant(userid);
        p.add((Participant)pa);
        UserParticipant pa2 = new UserParticipant(uid2);
        p.add((Participant)pa2);
        cdao.setParticipants(p.getList());
        cdao.setContext((Context)context);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        Date last = cdao.getLastModified();
        RecurringResultsInterface rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, cals, u, 0);
        CalendarRecurringTests.assertEquals((String)"Testing size ", (int)10, (int)rss.size());
        for (int a = 0; a < rss.size(); ++a) {
            RecurringResultInterface rs = rss.getRecurringResult(a);
            CalendarRecurringTests.assertEquals((String)"Testing start time", (long)start.getTimeInMillis(), (long)rs.getStart());
            CalendarRecurringTests.assertEquals((String)"Testing end time", (long)ende.getTimeInMillis(), (long)rs.getEnd());
            CalendarRecurringTests.assertEquals((String)"Testing Position", (int)(a + 1), (int)rs.getPosition());
            start.add(5, 1);
            ende.add(5, 1);
        }
        csql.getObjectById(object_id, folder_id);
        rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        CalendarRecurringTests.assertEquals((String)"Testing size ", (int)11, (int)rss.size());
        CalendarDataObject delete_owner = new CalendarDataObject();
        delete_owner.setContext((Context)context);
        delete_owner.setRecurrencePosition(3);
        delete_owner.setObjectID(object_id);
        csql.deleteAppointmentObject(delete_owner, folder_id, new Date());
        CalendarDataObject test_object = csql.getObjectById(object_id, folder_id);
        rss = new CalendarCollection().calculateRecurring((CalendarObject)test_object, 0L, 0L, 0);
        CalendarRecurringTests.assertEquals((String)"Testing size after deleteing single app from sequence", (int)10, (int)rss.size());
        rss = new CalendarCollection().calculateRecurring((CalendarObject)test_object, 0L, 0L, 3);
        CalendarRecurringTests.assertEquals((String)"Testing size after requesting single deleted app from sequence", (int)0, (int)rss.size());
        CalendarSql csql2 = new CalendarSql((Session)so2);
        CalendarDataObject test_delete_not_owner = new CalendarDataObject();
        test_delete_not_owner.setContext((Context)context);
        test_delete_not_owner.setObjectID(object_id);
        test_delete_not_owner.setRecurrencePosition(5);
        csql2.deleteAppointmentObject(test_delete_not_owner, folder_id2, new Date());
        rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 5, 999, true);
        CalendarRecurringTests.assertEquals((String)"Can't calculate date position of virtual exception.", (int)1, (int)rss.size());
        Date recurrence_date_position = new Date(rss.getRecurringResult(0).getNormalized());
        CalendarDataObject test_master_object = csql.getObjectById(object_id, folder_id);
        UserParticipant[] up = test_master_object.getUsers();
        CalendarRecurringTests.assertEquals((String)"Testing participants in master object", (int)up.length, (int)2);
        int[] cols = new int[]{200, 1, 206, 207, 209, 211, 210};
        SearchIterator si = csql.getModifiedAppointmentsInFolder(folder_id, cols, last);
        boolean found_exception = false;
        while (si.hasNext()) {
            Appointment tcdao = (Appointment)si.next();
            if (tcdao.getRecurrenceID() == object_id && tcdao.getObjectID() != object_id) {
                found_exception = true;
                CalendarRecurringTests.assertNull((String)"Deleted exceptions should be null.", (Object)tcdao.getDeleteException());
                CalendarRecurringTests.assertEquals((String)"Check correct recurrence position", (int)5, (int)tcdao.getRecurrencePosition());
                CalendarRecurringTests.assertEquals((String)"Recurrence date position is not correct.", (Object)recurrence_date_position, (Object)tcdao.getRecurrenceDatePosition());
                continue;
            }
            if (tcdao.getObjectID() != object_id) continue;
            Date[] test_deleted_exceptions = tcdao.getDeleteException();
            Date[] test_changed_exceptions = tcdao.getChangeException();
            CalendarRecurringTests.assertTrue((String)"Test changed exception is ! NULL", (test_changed_exceptions != null ? 1 : 0) != 0);
            CalendarRecurringTests.assertTrue((String)"Test changed exception is 1", (test_changed_exceptions.length == 1 ? 1 : 0) != 0);
            CalendarRecurringTests.assertEquals((String)"Check master recurrence position", (int)0, (int)tcdao.getRecurrencePosition());
        }
        si.close();
        CalendarRecurringTests.assertTrue((String)"Found created exception ", (boolean)found_exception);
        CalendarDataObject delete_all = new CalendarDataObject();
        delete_all.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        delete_all.setObjectID(object_id);
        csql.deleteAppointmentObject(delete_all, folder_id, new Date());
        si = csql.getModifiedAppointmentsInFolder(folder_id, cols, last);
        while (si.hasNext()) {
            Appointment tcdao = (Appointment)si.next();
            CalendarRecurringTests.assertFalse((String)"Object should not exists anymore ", (tcdao.getRecurrenceID() == object_id ? 1 : 0) != 0);
        }
    }

    public void testRecurringSimpleUpdate() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int folder_id = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(folder_id);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("testRecurringSimpleUpdate - Step 1 - Insert");
        cdao.setRecurrenceType(1);
        cdao.setRecurrenceCalculator(1);
        cdao.setInterval(1);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, folder_id);
        Date save_start = testobject.getStartDate();
        Date save_end = testobject.getEndDate();
        String rec_string = new CalendarCollection().createDSString(testobject);
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setTitle("testRecurringSimpleUpdate - Step 2 - Update");
        update.setObjectID(object_id);
        update.setIgnoreConflicts(true);
        csql.updateAppointmentObject(update, folder_id, new Date());
        CalendarDataObject testobject_update = csql.getObjectById(object_id, folder_id);
        CalendarRecurringTests.assertEquals((String)"Check start date", (Object)save_start, (Object)testobject_update.getStartDate());
        CalendarRecurringTests.assertEquals((String)"Check end date", (Object)save_end, (Object)testobject_update.getEndDate());
        CalendarRecurringTests.assertTrue((String)"Check rec string", (boolean)rec_string.equals(new CalendarCollection().createDSString(testobject_update)));
        RecurringResultsInterface rss = new CalendarCollection().calculateRecurring((CalendarObject)testobject_update, 0L, 0L, 1);
        CalendarRecurringTests.assertTrue((String)"Got results ", (rss.size() == 1 ? 1 : 0) != 0);
        RecurringResultInterface rs = rss.getRecurringResult(0);
        CalendarDataObject update_with_times = new CalendarDataObject();
        update_with_times.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update_with_times.setTitle("testRecurringSimpleUpdate - Step 3 - Update");
        update_with_times.setObjectID(object_id);
        update_with_times.setStartDate(new Date(rs.getStart()));
        update_with_times.setEndDate(new Date(rs.getEnd()));
        update_with_times.setIgnoreConflicts(true);
        csql.updateAppointmentObject(update_with_times, folder_id, new Date());
        testobject_update = csql.getObjectById(object_id, folder_id);
        CalendarRecurringTests.assertEquals((String)"Check start date", (Object)save_start, (Object)testobject_update.getStartDate());
        CalendarRecurringTests.assertEquals((String)"Check end date", (Object)save_end, (Object)testobject_update.getEndDate());
        CalendarRecurringTests.assertEquals((String)"Check rec string", (String)rec_string, (String)new CalendarCollection().createDSString(testobject_update));
        CalendarDataObject update_with_changed_times = new CalendarDataObject();
        update_with_changed_times.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update_with_changed_times.setTitle("testRecurringSimpleUpdate - Step 4 - Update");
        update_with_changed_times.setObjectID(object_id);
        update_with_changed_times.setStartDate(new Date(rs.getStart() + 3600000L));
        update_with_changed_times.setEndDate(new Date(rs.getEnd() + 3600000L));
        update_with_changed_times.setRecurrenceType(1);
        update_with_changed_times.setInterval(1);
        update_with_changed_times.setIgnoreConflicts(true);
        csql.updateAppointmentObject(update_with_changed_times, folder_id, new Date());
        testobject_update = csql.getObjectById(object_id, folder_id);
        CalendarRecurringTests.assertEquals((String)"Check start date", (Object)new Date(save_start.getTime() + 3600000L), (Object)testobject_update.getStartDate());
        CalendarRecurringTests.assertEquals((String)"Check end date", (Object)new Date(save_end.getTime() + 3600000L), (Object)testobject_update.getEndDate());
        CalendarRecurringTests.assertTrue((String)"Check rec string", (!rec_string.equals(new CalendarCollection().createDSString(testobject_update)) ? 1 : 0) != 0);
    }

    public void testUpdateSimpleAppointmentToRecurring() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int folder_id = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(folder_id);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("testUpdateSimpleAppointmentToRecurring - Step 1 - Insert");
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setTitle("testUpdateSimpleAppointmentToRecurring - Step 2 - Update - Recurring");
        update.setObjectID(object_id);
        update.setRecurrenceType(1);
        update.setRecurrenceCalculator(1);
        update.setInterval(1);
        update.setUntil(cdao.getUntil());
        update.setIgnoreConflicts(true);
        csql.updateAppointmentObject(update, folder_id, new Date());
        CalendarDataObject testobject = csql.getObjectById(object_id, folder_id);
        RecurringResultsInterface rss = new CalendarCollection().calculateRecurring((CalendarObject)testobject, 0L, 0L, 0);
        CalendarRecurringTests.assertTrue((String)"Test object is not null", (rss != null ? 1 : 0) != 0);
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE));
        c.setTimeInMillis(cdao.getStartDate().getTime());
        for (int a = 0; a < rss.size(); ++a) {
            RecurringResultInterface rs = rss.getRecurringResult(a);
            CalendarRecurringTests.assertEquals((String)"Check correct start time ", (long)c.getTimeInMillis(), (long)rs.getStart());
            c.add(5, 1);
        }
        CalendarDataObject update_normal = new CalendarDataObject();
        update_normal.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update_normal.setTitle("testUpdateSimpleAppointmentToRecurring - Step 3 - Update - Normal");
        update_normal.setObjectID(object_id);
        update_normal.setRecurrenceType(0);
        update_normal.setIgnoreConflicts(true);
        csql.updateAppointmentObject(update_normal, folder_id, new Date());
        CalendarDataObject testobject2 = csql.getObjectById(object_id, folder_id);
        CalendarRecurringTests.assertEquals((String)"Check if appointment is no sequence", (int)0, (int)testobject2.getRecurrenceType());
        String null_check = "\"" + testobject2.getRecurrence() + "\"";
        CalendarRecurringTests.assertEquals((String)"Check that the recurrence is null ", (String)"\"null\"", (String)null_check);
    }

    public void testCreateExceptionFromRecurring() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int folder_id = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(folder_id);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("testCreateExceptionFromRecurring - Step 1 - Insert");
        cdao.setRecurrenceType(1);
        cdao.setRecurrenceCalculator(1);
        cdao.setInterval(1);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        Date last = cdao.getLastModified();
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setIgnoreConflicts(true);
        RecurringResultsInterface rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 3);
        RecurringResultInterface rs = rss.getRecurringResult(0);
        long new_start = rs.getStart() + 3600000L;
        long new_end = rs.getEnd() + 3600000L;
        Date test_new_start_date = new Date(new_start);
        Date test_new_end_date = new Date(new_end);
        update.setStartDate(test_new_start_date);
        update.setEndDate(test_new_end_date);
        update.setTitle("testCreateExceptionFromRecurring - Step 2 - Update (create exception)");
        update.setRecurrencePosition(3);
        csql.updateAppointmentObject(update, folder_id, new Date());
        CalendarRecurringTests.assertTrue((String)"Got a new object_id", (object_id != update.getObjectID() ? 1 : 0) != 0);
        CalendarDataObject testobject = csql.getObjectById(object_id, folder_id);
        new CalendarCollection().calculateRecurring((CalendarObject)testobject, 0L, 0L, 3, 999, true);
        RecurringResultInterface rs_test = rss.getRecurringResult(0);
        CalendarRecurringTests.assertTrue((String)"Got RecurringResultInterface", (rs_test != null ? 1 : 0) != 0);
        CalendarRecurringTests.assertEquals((String)"Check first calc", (long)rs.getStart(), (long)rs_test.getStart());
        CalendarRecurringTests.assertTrue((String)"Got correct exception", (3 == rs_test.getPosition() ? 1 : 0) != 0);
        long exception_date = rs_test.getNormalized();
        Date[] exceptions = testobject.getChangeException();
        CalendarRecurringTests.assertTrue((String)"Got exceptions", (exceptions != null ? 1 : 0) != 0);
        CalendarRecurringTests.assertEquals((String)"Check correct exception calculation", (long)exception_date, (long)exceptions[0].getTime());
        int[] cols = new int[]{200, 201, 202, 1, 206, 207, 209, 211, 210};
        SearchIterator si = csql.getModifiedAppointmentsInFolder(folder_id, cols, last);
        boolean found_exception = false;
        while (si.hasNext()) {
            CalendarDataObject tcdao = (CalendarDataObject)si.next();
            if (tcdao.getRecurrenceID() != object_id || tcdao.getRecurrencePosition() != 3) continue;
            CalendarRecurringTests.assertTrue((String)"Test if we got a unique ID", (tcdao.getRecurrenceID() != tcdao.getObjectID() ? 1 : 0) != 0);
            found_exception = true;
            CalendarRecurringTests.assertEquals((String)"Test exception start date", (long)test_new_start_date.getTime(), (long)tcdao.getStartDate().getTime());
            CalendarRecurringTests.assertEquals((String)"Test exception end date", (long)test_new_end_date.getTime(), (long)tcdao.getEndDate().getTime());
        }
        si.close();
        CalendarRecurringTests.assertTrue((String)"Found exception", (boolean)found_exception);
        si = csql.getAppointmentsBetweenInFolder(folder_id, cols, new Date(0L), new Date(253402210800000L), 0, null);
        int counter = 0;
        while (si.hasNext()) {
            CalendarDataObject tcdao = (CalendarDataObject)si.next();
            if (tcdao.getRecurrenceID() == object_id) {
                ++counter;
                continue;
            }
            if (tcdao.getRecurrenceID() != object_id || tcdao.getRecurrencePosition() != 3) continue;
            Date[] check_exception = tcdao.getChangeException();
            CalendarRecurringTests.assertTrue((String)"Got exceptions", (check_exception != null ? 1 : 0) != 0);
        }
        si.close();
        CalendarRecurringTests.assertEquals((String)"Check correct number of results", (int)2, (int)counter);
    }

    public void testWeeklyMonday() throws Throwable {
        RecurringResultsInterface m = null;
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        CalendarTest.fillDatesInDao(cdao);
        cdao.removeUntil();
        cdao.setTitle("testWeeklyMonday");
        cdao.setRecurrenceID(1);
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(2);
        new CalendarCollection().fillDAO(cdao);
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        for (int a = 0; a < m.size(); ++a) {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE));
            c.setTimeInMillis(m.getRecurringResult(a).getStart());
            CalendarRecurringTests.assertEquals((String)"First day check (MONDAY)", (int)2, (int)c.get(7));
        }
    }

    public void testCreateExceptionFromRecurringWithDatePosition() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int folder_id = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(folder_id);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("testCreateExceptionFromRecurringWithDatePosition - Step 1 - Insert");
        cdao.setRecurrenceType(1);
        cdao.setRecurrenceCalculator(1);
        cdao.setInterval(1);
        Participants p = new Participants();
        new ResourceParticipant(100);
        cdao.setParticipants(p.getList());
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        Date last = cdao.getLastModified();
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setIgnoreConflicts(true);
        RecurringResultsInterface rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 3);
        RecurringResultInterface rs = rss.getRecurringResult(0);
        long new_start = rs.getStart() + 3600000L;
        long new_end = rs.getEnd() + 3600000L;
        Date test_new_start_date = new Date(new_start);
        Date test_new_end_date = new Date(new_end);
        update.setStartDate(test_new_start_date);
        update.setEndDate(test_new_end_date);
        update.setTitle("testCreateExceptionFromRecurringWithDatePosition - Step 2 - Update (create exception)");
        long changeExceptionDate = new CalendarCollection().normalizeLong(new_start);
        update.setRecurrenceDatePosition(new Date(changeExceptionDate));
        csql.updateAppointmentObject(update, folder_id, new Date());
        CalendarDataObject testobject = csql.getObjectById(object_id, folder_id);
        RecurringResultsInterface rss_test = new CalendarCollection().calculateRecurring((CalendarObject)testobject, 0L, 0L, 3, 999, true);
        RecurringResultInterface rs_test = rss_test.getRecurringResult(0);
        CalendarRecurringTests.assertTrue((String)"Got RecurringResultInterface", (rs_test != null ? 1 : 0) != 0);
        CalendarRecurringTests.assertEquals((String)"Check first calc", (long)rs.getStart(), (long)rs_test.getStart());
        CalendarRecurringTests.assertTrue((String)"Got correct exception", (3 == rs_test.getPosition() ? 1 : 0) != 0);
        long exception_date = rs_test.getNormalized();
        Date[] exceptions = testobject.getChangeException();
        CalendarRecurringTests.assertTrue((String)"Got exceptions", (exceptions != null ? 1 : 0) != 0);
        CalendarRecurringTests.assertEquals((String)"Check correct exception calculation", (long)exception_date, (long)changeExceptionDate);
        CalendarRecurringTests.assertEquals((String)"Check correct exception calculation with stored date", (long)exception_date, (long)exceptions[0].getTime());
        int[] cols = new int[]{200, 201, 202, 1, 206, 207, 209, 211, 210};
        SearchIterator si = csql.getModifiedAppointmentsInFolder(folder_id, cols, last);
        boolean found_exception = false;
        while (si.hasNext()) {
            CalendarDataObject tcdao = (CalendarDataObject)si.next();
            if (tcdao.getRecurrenceID() != object_id || tcdao.getRecurrencePosition() != 3) continue;
            CalendarRecurringTests.assertTrue((String)"Test if we got a unique ID", (tcdao.getRecurrenceID() != tcdao.getObjectID() ? 1 : 0) != 0);
            found_exception = true;
            CalendarRecurringTests.assertEquals((String)"Test exception start date", (long)test_new_start_date.getTime(), (long)tcdao.getStartDate().getTime());
            CalendarRecurringTests.assertEquals((String)"Test exception end date", (long)test_new_end_date.getTime(), (long)tcdao.getEndDate().getTime());
        }
        si.close();
        CalendarRecurringTests.assertTrue((String)"Found exception", (boolean)found_exception);
        si = csql.getAppointmentsBetweenInFolder(folder_id, cols, new Date(0L), new Date(253402210800000L), 0, null);
        int counter = 0;
        while (si.hasNext()) {
            CalendarDataObject tcdao = (CalendarDataObject)si.next();
            if (tcdao.getRecurrenceID() != object_id) continue;
            ++counter;
        }
        si.close();
        CalendarRecurringTests.assertEquals((String)"Check correct number of results", (int)2, (int)counter);
    }

    public void testWeeklyDifferentInterval() throws Throwable {
        long s = 1149501600000L;
        long e = 1149505200000L;
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE));
        c.setTimeInMillis(1149501600000L);
        RecurringResultsInterface m = null;
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1149501600000L));
        cdao.setEndDate(new Date(1149505200000L));
        cdao.setOccurrence(10);
        cdao.setTitle("Weekly Appointment Test");
        cdao.setRecurrenceID(1);
        cdao.setRecurrenceType(2);
        cdao.setInterval(2);
        cdao.setDays(42);
        new CalendarCollection().fillDAO(cdao);
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        c.setTimeInMillis(new Date(m.getRecurringResult(0).getStart()).getTime());
        CalendarRecurringTests.assertEquals((String)"First day check (MONDAY)", (int)c.get(7), (int)2);
        c.setTimeInMillis(new Date(m.getRecurringResult(1).getStart()).getTime());
        CalendarRecurringTests.assertEquals((String)"First day check (WEDNESDAY)", (int)c.get(7), (int)4);
        c.setTimeInMillis(new Date(m.getRecurringResult(2).getStart()).getTime());
        CalendarRecurringTests.assertEquals((String)"First day check (FRIDAY)", (int)c.get(7), (int)6);
    }

    private long addYears(long base, int years) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(base);
        ((Calendar)calendar).add(1, years);
        return calendar.getTimeInMillis();
    }

    public void testCorrectUntilCalculation() throws Throwable {
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        CalendarTest.fillDatesInDao(cdao);
        cdao.removeUntil();
        cdao.setTitle("testCorrectUntilCalculation");
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(8);
        new CalendarCollection().fillDAO(cdao);
        int years = new CalendarCollection().getMAX_END_YEARS();
        long check_until = new CalendarCollection().normalizeLong(this.addYears(cdao.getStartDate().getTime(), years));
        CalendarDataObject clone = cdao.clone();
        try {
            RecurringResultsInterface rresults = new CalendarCollection().calculateRecurring((CalendarObject)clone, 0L, 0L, 0);
            RecurringResultInterface rresult = rresults.getRecurringResultByPosition(999);
            if (rresult != null) {
                check_until = new CalendarCollection().normalizeLong(rresult.getEnd());
            }
        }
        catch (OXException rresult) {
            // empty catch block
        }
        CalendarRecurringTests.assertEquals((String)"Check correct until for !yearly ", (long)check_until, (long)cdao.getUntil().getTime());
        int MONTH = 7;
        int DAY = 20;
        Calendar cdao2Cal = TimeTools.createCalendar(TimeZone.getTimeZone(TIMEZONE));
        cdao2Cal.set(2, 7);
        cdao2Cal.set(5, 20);
        CalendarDataObject cdao2 = new CalendarDataObject();
        cdao2.setTimezone(TIMEZONE);
        cdao2.setStartDate(cdao2Cal.getTime());
        cdao2Cal.add(10, 1);
        cdao2.setEndDate(cdao2Cal.getTime());
        cdao2.setTitle("testCorrectUntilCalculation yearly");
        cdao2.setRecurrenceType(4);
        cdao2.setInterval(1);
        cdao2.setMonth(7);
        cdao2.setDayInMonth(20);
        new CalendarCollection().fillDAO(cdao2);
        CalendarCollection coll = new CalendarCollection();
        GregorianCalendar check_until2 = new GregorianCalendar();
        check_until2.setTime(cdao2.getStartDate());
        ((Calendar)check_until2).add(1, 998);
        check_until2.set(2, 7);
        check_until2.set(5, 20);
        Date expected = new Date(coll.normalizeLong(check_until2.getTimeInMillis()));
        Date actual = cdao2.getUntil();
        CalendarRecurringTests.assertEquals((String)"Check correct until for yearly ", (Object)expected, (Object)actual);
    }

    public void testFlagSingleException() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int folder_id = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setContext((Context)context);
        CalendarTest.fillDatesInDao(cdao);
        cdao.removeUntil();
        cdao.setTitle("testFlagSingleException");
        cdao.setParentFolderID(folder_id);
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        cdao.setOccurrence(7);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        Date last = cdao.getLastModified();
        CalendarDataObject flag_exception = new CalendarDataObject();
        flag_exception.setContext((Context)context);
        flag_exception.setObjectID(object_id);
        flag_exception.setRecurrencePosition(2);
        flag_exception.setLabel(2);
        flag_exception.setIgnoreConflicts(true);
        csql.updateAppointmentObject(flag_exception, folder_id, last);
        int object_exception_id = flag_exception.getObjectID();
        flag_exception.getLastModified();
        CalendarRecurringTests.assertTrue((String)("Exception created (object_id:object_exception_id) (" + object_id + ":" + object_exception_id + ")"), (object_id != object_exception_id ? 1 : 0) != 0);
        CalendarDataObject testobject = csql.getObjectById(object_id, folder_id);
        CalendarDataObject testobject_exception = csql.getObjectById(object_exception_id, folder_id);
        CalendarRecurringTests.assertEquals((String)"Check recurrence id", (int)testobject.getRecurrenceID(), (int)testobject_exception.getRecurrenceID());
    }

    public void testWholeDayRecurringWithOccurrence() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int folder_id = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setContext((Context)context);
        CalendarTest.fillDatesInDao(cdao);
        cdao.removeUntil();
        long s = new CalendarCollection().normalizeLong(cdao.getStartDate().getTime());
        cdao.setStartDate(new Date(s));
        new CalendarCollection().getClass();
        long e = s + 86400000L;
        cdao.setEndDate(new Date(e));
        cdao.setFullTime(true);
        long start_time = cdao.getStartDate().getTime();
        start_time = new CalendarCollection().normalizeLong(start_time);
        cdao.setTitle("testWholeDayRecurringWithOccurrence");
        cdao.setParentFolderID(folder_id);
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        int occurrence = 2;
        cdao.setOccurrence(2);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        cdao.getLastModified();
        CalendarDataObject testobject = csql.getObjectById(object_id, folder_id);
        new CalendarCollection().getClass();
        Date check_time = new Date(start_time + 86400000L * 1L);
        CalendarRecurringTests.assertEquals((String)"Check correct until", (Object)check_time, (Object)testobject.getUntil());
    }

    public void testComplexOccurrence() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int folder_id = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setContext((Context)context);
        CalendarTest.fillDatesInDao(cdao);
        cdao.removeUntil();
        cdao.setTitle("testComplexOccurrence - Step 1");
        cdao.setParentFolderID(folder_id);
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        cdao.setOccurrence(3);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, folder_id);
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setIgnoreConflicts(true);
        update.setTitle("testComplexOccurrence - Step 2");
        update.setOccurrence(5);
        update.setRecurrenceType(1);
        update.setInterval(1);
        update.setObjectID(object_id);
        csql.updateAppointmentObject(update, folder_id, cdao.getLastModified());
        CalendarDataObject testobject2 = csql.getObjectById(object_id, folder_id);
        CalendarRecurringTests.assertTrue((String)"Check that until date is different", (testobject.getUntil().getTime() != testobject2.getUntil().getTime() ? 1 : 0) != 0);
    }

    public void no_testRecurringConflictHandling() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setContext((Context)context);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("ConflictAppointment");
        cdao.setIgnoreConflicts(true);
        cdao.setParentFolderID(fid);
        CalendarDataObject cdao2 = cdao.clone();
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        cdao.getObjectID();
        cdao2.setTitle("testRecurringConflictHandling");
        cdao2.setRecurrenceType(1);
        cdao2.setInterval(7);
        cdao2.setParentFolderID(fid);
        cdao2.setIgnoreConflicts(false);
        cdao2.removeUntil();
        CalendarDataObject[] conflicts = csql.insertAppointmentObject(cdao2);
        CalendarRecurringTests.assertTrue((String)"Recurring Appointments should not conflict!", (conflicts == null ? 1 : 0) != 0);
        int object_id2 = cdao2.getObjectID();
        CalendarDataObject flag_exception = new CalendarDataObject();
        flag_exception.setContext((Context)context);
        flag_exception.setObjectID(object_id2);
        flag_exception.setRecurrencePosition(1);
        flag_exception.setLabel(2);
        flag_exception.setIgnoreConflicts(true);
        conflicts = csql.updateAppointmentObject(flag_exception, fid, cdao2.getLastModified());
        CalendarRecurringTests.assertTrue((String)"Recurring Appointments should not conflict!", (conflicts == null ? 1 : 0) != 0);
    }

    public void testMonthlyRecurringWithDayLightSavingTimeShift() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext((Context)context);
        cdao.setTimezone(TIMEZONE);
        long s = 1172754000000L;
        long e = 1172757600000L;
        cdao.setStartDate(new Date(1172754000000L));
        cdao.setEndDate(new Date(1172757600000L));
        Calendar check_start = Calendar.getInstance();
        check_start.setTimeZone(TimeZone.getTimeZone(TIMEZONE));
        check_start.setTimeInMillis(1172754000000L);
        int check_start_hour = check_start.get(10);
        int check_start_minute = check_start.get(12);
        cdao.setTitle("testMonthlyRecurringWithDayLightSavingTimeShift");
        cdao.setRecurrenceType(3);
        cdao.setDays(32);
        cdao.setDayInMonth(1);
        cdao.setInterval(1);
        cdao.setOccurrence(3);
        cdao.setParentFolderID(fid);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject test_dao = csql.getObjectById(object_id, fid);
        new CalendarCollection().fillDAO(cdao);
        RecurringResultsInterface m = new CalendarCollection().calculateRecurring((CalendarObject)test_dao, 0L, 0L, 0);
        CalendarRecurringTests.assertTrue((String)"Result != null", (m != null ? 1 : 0) != 0);
        CalendarRecurringTests.assertTrue((String)"Got results", (m.size() > 0 ? 1 : 0) != 0);
        for (int a = 0; a < m.size(); ++a) {
            RecurringResultInterface rs = m.getRecurringResult(a);
            Calendar test_start = Calendar.getInstance();
            test_start.setTimeZone(TimeZone.getTimeZone(TIMEZONE));
            test_start.setTimeInMillis(rs.getStart());
            int test_start_hour = test_start.get(10);
            int test_start_minute = test_start.get(12);
            CalendarRecurringTests.assertEquals((String)("Test hour (of occurence " + rs.getPosition() + ")"), (int)check_start_hour, (int)test_start_hour);
            CalendarRecurringTests.assertEquals((String)("Test minute (of occurence " + rs.getPosition() + ")"), (int)check_start_minute, (int)test_start_minute);
        }
    }

    public void testYearly() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext((Context)context);
        cdao.setTimezone(TIMEZONE);
        CalendarTest.fillDatesInDao(cdao);
        cdao.removeUntil();
        cdao.setTitle("testYearly");
        cdao.setRecurrenceType(4);
        cdao.setInterval(1);
        cdao.setMonth(1);
        cdao.setDayInMonth(19);
        cdao.setParentFolderID(fid);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject test_dao = csql.getObjectById(object_id, fid);
        new CalendarCollection().fillDAO(test_dao);
        RecurringResultsInterface m = new CalendarCollection().calculateRecurring((CalendarObject)test_dao, 0L, 0L, 0);
        CalendarRecurringTests.assertTrue((String)"Result != null", (m != null ? 1 : 0) != 0);
        CalendarRecurringTests.assertTrue((String)"Got results", (m.size() > 0 ? 1 : 0) != 0);
        for (int a = 0; a < m.size(); ++a) {
            RecurringResultInterface rs = m.getRecurringResult(a);
            Calendar test_start = Calendar.getInstance();
            test_start.setTimeZone(TimeZone.getTimeZone(TIMEZONE));
            test_start.setTimeInMillis(rs.getStart());
            int test_month = test_start.get(2);
            int test_day_of_month = test_start.get(5);
            CalendarRecurringTests.assertEquals((String)("Test month (of occurence " + rs.getPosition() + ")"), (int)1, (int)test_month);
            CalendarRecurringTests.assertEquals((String)("Test day_of_month (of occurence " + rs.getPosition() + ")"), (int)19, (int)test_day_of_month);
        }
    }

    public void testErrors() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext((Context)context);
        cdao.setTimezone(TIMEZONE);
        CalendarTest.fillDatesInDao(cdao);
        cdao.removeUntil();
        cdao.setTitle("testYearly");
        cdao.setRecurrenceType(1);
        cdao.setInterval(-1);
        boolean check_if_error_is_thrown = false;
        try {
            new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
            CalendarRecurringTests.fail((String)"An error must occur at this time. Fix me!");
        }
        catch (OXException oxce) {
            check_if_error_is_thrown = true;
        }
        CalendarRecurringTests.assertTrue((String)"Check if the error was thrown", (boolean)check_if_error_is_thrown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveExceptionToDifferentFolerAndSetPrivateFlag() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)CalendarRecurringTests.getContext().getContextId(), (String)"myTestSearch");
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (Connection)readcon, (Connection)writecon);
        FolderObject fo = new FolderObject();
        CalendarSql csql = new CalendarSql((Session)so);
        OCLPermission oclp1 = new OCLPermission();
        oclp1.setEntity(userid);
        oclp1.setAllPermission(128, 128, 128, 128);
        oclp1.setFolderAdmin(true);
        new OCLPermission();
        fo.setFolderName("testExceptionHandlingFolder_" + String.valueOf(System.currentTimeMillis()));
        fo.setParentFolderID(fid);
        fo.setModule(2);
        fo.setType(1);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp1});
        int test_folder = 0;
        try {
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            test_folder = fo.getObjectID();
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setParentFolderID(fid);
            CalendarTest.fillDatesInDao(cdao);
            cdao.setTitle("testMoveExceptionToDifferentFolerAndSetPrivateFlag");
            cdao.setRecurrenceType(1);
            cdao.setRecurrenceCalculator(1);
            cdao.setInterval(1);
            cdao.setIgnoreConflicts(true);
            csql.insertAppointmentObject(cdao);
            int object_id = cdao.getObjectID();
            CalendarDataObject exception = new CalendarDataObject();
            exception.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            exception.setObjectID(object_id);
            exception.setIgnoreConflicts(true);
            exception.setTitle("testMoveExceptionToDifferentFolerAndSetPrivateFlag - Update (create exception)");
            exception.setRecurrencePosition(3);
            csql.updateAppointmentObject(exception, fid, new Date());
            int exception_id = exception.getObjectID();
            CalendarRecurringTests.assertTrue((String)"Object was created", (exception_id > 0 ? 1 : 0) != 0);
            CalendarRecurringTests.assertTrue((String)"Got a new object_id", (object_id != exception_id ? 1 : 0) != 0);
            CalendarDataObject test_move_folder = new CalendarDataObject();
            test_move_folder.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            test_move_folder.setObjectID(exception_id);
            test_move_folder.setParentFolderID(test_folder);
            test_move_folder.setIgnoreConflicts(true);
            try {
                csql.updateAppointmentObject(test_move_folder, fid, new Date());
                CalendarRecurringTests.fail((String)"An exception should not be moved to a different folder");
            }
            catch (OXException oxca) {
                CalendarRecurringTests.assertEquals((String)"Check correct error code", (int)66, (int)oxca.getCode());
            }
            CalendarDataObject test_private_flag = new CalendarDataObject();
            test_private_flag.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            test_private_flag.setObjectID(exception_id);
            test_private_flag.setParentFolderID(fid);
            test_private_flag.setPrivateFlag(true);
            test_private_flag.setIgnoreConflicts(true);
            try {
                csql.updateAppointmentObject(test_private_flag, fid, new Date());
                CalendarRecurringTests.fail((String)"An exception should not be flagged as private");
            }
            catch (OXException oxca) {
                CalendarRecurringTests.assertEquals((String)"Check correct error code", (int)69, (int)oxca.getCode());
            }
        }
        finally {
            try {
                if (test_folder > 0) {
                    oxma.deleteFolder(new FolderObject(test_folder), true, System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                CalendarRecurringTests.fail((String)"Error deleting folder object.");
            }
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    public void testCreateAndDeleteException() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int folder_id = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(folder_id);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("testCreateAndDeleteException");
        cdao.setRecurrenceType(1);
        cdao.setRecurrenceCalculator(1);
        cdao.setInterval(1);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        cdao.getLastModified();
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setIgnoreConflicts(true);
        RecurringResultsInterface rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 3);
        RecurringResultInterface rs = rss.getRecurringResult(0);
        long new_start = rs.getStart() + 3600000L;
        long new_end = rs.getEnd() + 3600000L;
        Date test_new_start_date = new Date(new_start);
        Date test_new_end_date = new Date(new_end);
        update.setStartDate(test_new_start_date);
        update.setEndDate(test_new_end_date);
        update.setTitle("testCreateAndDeleteException - Exception");
        update.setRecurrencePosition(3);
        csql.updateAppointmentObject(update, folder_id, new Date());
        CalendarRecurringTests.assertTrue((String)"Got a new object_id", (object_id != update.getObjectID() ? 1 : 0) != 0);
        int exception_object_id = update.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(exception_object_id, folder_id);
        CalendarRecurringTests.assertTrue((String)"Got correct exception", (3 == testobject.getRecurrencePosition() ? 1 : 0) != 0);
        CalendarRecurringTests.assertTrue((String)"Check if recurring_id is set", (boolean)testobject.containsRecurrenceID());
        CalendarRecurringTests.assertTrue((String)("Check if recurring_id (" + testobject.getRecurrenceID() + ") > 0 "), (testobject.getRecurrenceID() > 0 ? 1 : 0) != 0);
        CalendarRecurringTests.assertEquals((String)"Check if object is still a recurring event", (boolean)true, (boolean)testobject.isSequence());
        CalendarDataObject delete = new CalendarDataObject();
        delete.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        delete.setObjectID(object_id);
        delete.setIgnoreConflicts(true);
        delete.setTitle("testCreateAndDeleteException - delete single exception and change title");
        Date[] changed_exceptions = testobject.getChangeException();
        long changeExceptionDate = changed_exceptions[0].getTime();
        CalendarRecurringTests.assertTrue((String)"Got changed exceptions", (changed_exceptions != null ? 1 : 0) != 0);
        delete.setDeleteExceptions(new Date[]{changed_exceptions[0]});
        csql.updateAppointmentObject(delete, folder_id, new Date());
        CalendarDataObject test_dao = csql.getObjectById(object_id, folder_id);
        CalendarRecurringTests.assertTrue((String)"Check if recurring_id is set", (boolean)test_dao.containsRecurrenceID());
        CalendarRecurringTests.assertTrue((String)("Check if recurring_id (" + test_dao.getRecurrenceID() + ") > 0 "), (test_dao.getRecurrenceID() > 0 ? 1 : 0) != 0);
        CalendarRecurringTests.assertEquals((String)"Check if object is still a recurring event", (boolean)true, (boolean)test_dao.isSequence());
        try {
            csql.getObjectById(exception_object_id, folder_id);
            CalendarRecurringTests.fail((String)"The exception still exists but should be deleted!");
        }
        catch (OXException oXException) {
            // empty catch block
        }
        CalendarRecurringTests.assertTrue((String)"Change exception has not been removed in database", (test_dao.getChangeException() == null || test_dao.getChangeException().length == 0 ? 1 : 0) != 0);
        CalendarRecurringTests.assertTrue((String)"Delete exception has not been stored to database", (test_dao.getDeleteException() != null && test_dao.getDeleteException().length == 1 ? 1 : 0) != 0);
        CalendarRecurringTests.assertTrue((String)"Delete exception date is not equal to previous change exception date", (changeExceptionDate == test_dao.getDeleteException()[0].getTime() ? 1 : 0) != 0);
    }

    public void testDeleteException() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int folder_id = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(folder_id);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("testDeleteException");
        cdao.setRecurrenceType(1);
        cdao.setRecurrenceCalculator(1);
        cdao.setInterval(1);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        cdao.getLastModified();
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setIgnoreConflicts(true);
        RecurringResultsInterface rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0, 999, true);
        RecurringResultInterface first = rss.getRecurringResult(0);
        long deleteExceptionDate = new CalendarCollection().normalizeLong(first.getStart());
        update.setDeleteExceptions(new Date[]{new Date(deleteExceptionDate)});
        csql.updateAppointmentObject(update, folder_id, new Date());
        CalendarDataObject tdao = csql.getObjectById(object_id, folder_id);
        CalendarRecurringTests.assertTrue((String)"Delete exception not contained in recurring appointment", (tdao.containsDeleteExceptions() && tdao.getDeleteException() != null && tdao.getDeleteException().length > 0 ? 1 : 0) != 0);
    }

    public void testDeleteExceptionUntilFullDelete() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int folder_id = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(folder_id);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("testDeleteExceptionUntilFullDelete");
        cdao.setRecurrenceType(1);
        cdao.setRecurrenceCalculator(1);
        cdao.setInterval(1);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        cdao.getLastModified();
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setIgnoreConflicts(true);
        RecurringResultsInterface rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0, 999, true);
        int size = rss.size();
        ArrayList<Date> ddates = new ArrayList<Date>(size);
        for (int i = 0; i < size; ++i) {
            RecurringResultInterface rs = rss.getRecurringResult(i);
            long deleteExceptionDate = new CalendarCollection().normalizeLong(rs.getStart());
            ddates.add(new Date(deleteExceptionDate));
        }
        update.setDeleteExceptions(ddates.toArray(new Date[ddates.size()]));
        csql.updateAppointmentObject(update, folder_id, new Date());
        try {
            csql.getObjectById(object_id, folder_id);
            CalendarRecurringTests.fail((String)"The recurring appointment still exists but should have been deleted!");
        }
        catch (OXException oXException) {
            // empty catch block
        }
    }

    public void testDeleteSingleRecurringAppointmentsUntilFullDelete() throws Throwable {
        int i;
        long e;
        long s;
        ContextImpl context = new ContextImpl(contextid);
        CalendarDataObject cdao = new CalendarDataObject();
        long cals = s = TimeTools.D("04.10.2013 08:00").getTime();
        new CalendarCollection().getClass();
        long calsmod = s % 86400000L;
        cals -= calsmod;
        long endcalc = 3600000L;
        long mod = s % 3600000L;
        long saves = s -= mod;
        long savee = e = s + 3600000L;
        new CalendarCollection().getClass();
        long u = s + 86400000L * 10L;
        new CalendarCollection().getClass();
        mod = u % 86400000L;
        u -= mod;
        Calendar start = Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE));
        start.setTimeInMillis(saves);
        Calendar ende = Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE));
        ende.setTimeInMillis(savee);
        String user2 = AbstractConfigWrapper.parseProperty((Properties)CalendarRecurringTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int uid2 = CalendarRecurringTests.resolveUser(user2);
        int folder_id = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarTest.getCalendarDefaultFolderForUser(uid2, (Context)context);
        cdao.setStartDate(new Date(s));
        cdao.setEndDate(new Date(e));
        cdao.setUntil(new Date(u));
        cdao.setTitle("testDeleteSingleRecurringAppointment - step 1 - insert ");
        cdao.setRecurrenceType(1);
        cdao.setRecurrenceCalculator(1);
        cdao.setInterval(1);
        cdao.setParentFolderID(folder_id);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        SessionObjectWrapper.createSessionObject((int)uid2, (int)context.getContextId(), (String)"myTestIdentifier");
        Participants p = new Participants();
        UserParticipant pa = new UserParticipant(userid);
        p.add((Participant)pa);
        UserParticipant pa2 = new UserParticipant(uid2);
        p.add((Participant)pa2);
        cdao.setParticipants(p.getList());
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        cdao.getLastModified();
        RecurringResultsInterface rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, cals, u, 0);
        CalendarRecurringTests.assertEquals((String)"Testing size ", (int)rss.size(), (int)10);
        for (int a = 0; a < rss.size(); ++a) {
            RecurringResultInterface rs = rss.getRecurringResult(a);
            CalendarRecurringTests.assertEquals((String)"Testing start time", (long)rs.getStart(), (long)start.getTimeInMillis());
            CalendarRecurringTests.assertEquals((String)"Testing end time", (long)rs.getEnd(), (long)ende.getTimeInMillis());
            CalendarRecurringTests.assertEquals((String)"Testing Position", (int)(a + 1), (int)rs.getPosition());
            start.add(5, 1);
            ende.add(5, 1);
        }
        csql.getObjectById(object_id, folder_id);
        rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        CalendarRecurringTests.assertEquals((String)"Testing size ", (int)rss.size(), (int)11);
        for (i = 1; i <= rss.size(); ++i) {
            RecurringResultsInterface foo = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, i);
            RecurringResultInterface bar = foo.getRecurringResult(0);
            CalendarRecurringTests.assertTrue((String)"Recurrence position is null", (bar != null ? 1 : 0) != 0);
            CalendarRecurringTests.assertEquals((String)"Recurrence position mismatch", (int)bar.getPosition(), (int)i);
        }
        for (i = 1; i <= rss.size(); ++i) {
            CalendarDataObject delete_owner = new CalendarDataObject();
            delete_owner.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            delete_owner.setRecurrencePosition(i);
            delete_owner.setObjectID(object_id);
            csql.deleteAppointmentObject(delete_owner, folder_id, new Date());
        }
        try {
            CalendarDataObject check_object = csql.getObjectById(object_id, folder_id);
            CalendarRecurringTests.fail((String)("The recurring appointment still exists but should have been deleted! " + check_object.getObjectID()));
        }
        catch (OXException oXException) {
            // empty catch block
        }
    }
}

