/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug21240Test
extends CardDAVTest {
    @Before
    public void setUserAgent() throws Exception {
        super.getWebDAVClient().setUserAgent("Address%20Book/883 CFNetwork/454.12.4 Darwin/10.8.0 (i386)");
    }

    @Test
    public void testDeleteContact() throws Exception {
        String uid = Bug21240Test.randomUID() + "-ABSPlugin";
        String pathUid = Bug21240Test.randomUID() + "-ABSPlugin";
        String firstName = "test";
        String lastName = "hannes";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:hannes;test;;;\r\nFN:test hannes\r\nCATEGORIES:Kontakte\r\nX-ABUID:A33920F3-656F-47B7-A335-2C603DA3F324\\:ABPerson\r\nUID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "END:VCARD" + "\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putVCard(pathUid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Assert.assertEquals((String)"uid wrong", (Object)uid, (Object)contact.getUid());
        Assert.assertEquals((String)"firstname wrong", (Object)"test", (Object)contact.getGivenName());
        Assert.assertEquals((String)"lastname wrong", (Object)"hannes", (Object)contact.getSurName());
        Assert.assertEquals((String)"response code wrong", (long)200L, (long)super.delete(pathUid));
        Assert.assertNull((String)"contact not deleted", (Object)super.getContact(uid));
        Map<String, String> allETags = super.getAllETags();
        for (String href : allETags.values()) {
            Assert.assertFalse((String)"resource still present", (boolean)href.contains(pathUid));
        }
    }
}

