/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.tests;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class NewTest
extends CalDAVTest {
    @Test
    public void testCreateSimpleOnClient() throws Exception {
        String uid = NewTest.randomUID();
        String summary = "test";
        String location = "testcity";
        Date start = TimeTools.D("tomorrow at 3pm");
        Date end = TimeTools.D("tomorrow at 4pm");
        String iCal = NewTest.generateICal(start, end, uid, summary, location);
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(uid, iCal));
        Appointment appointment = super.getAppointment(uid);
        super.rememberForCleanUp(appointment);
        NewTest.assertAppointmentEquals(appointment, start, end, uid, summary, location);
        ICalResource iCalResource = super.get(uid, null);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
    }

    @Test
    public void testCreateSimpleOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = NewTest.randomUID();
        String summary = "hallo";
        String location = "achtung";
        Date start = TimeTools.D("next friday at 11:30");
        Date end = TimeTools.D("next friday at 12:45");
        Appointment appointment = NewTest.generateAppointment(start, end, uid, summary, location);
        super.rememberForCleanUp(super.create(appointment));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = NewTest.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
    }

    @Test
    public void testCreateAllDayOnClient() throws Exception {
        String uid = NewTest.randomUID();
        String summary = "test all day";
        Date start = TimeTools.D("midnight");
        Date end = TimeTools.D("tomorrow at midnight");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//iCal 5.0.2//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VEVENT\r\nCREATED:" + NewTest.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "DTEND;VALUE=DATE:" + NewTest.formatAsDate(end) + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "CLASS:PUBLIC" + "\r\n" + "SUMMARY:" + summary + "\r\n" + "LAST-MODIFIED:" + NewTest.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + NewTest.formatAsUTC(new Date()) + "\r\n" + "DTSTART;VALUE=DATE:" + NewTest.formatAsDate(start) + "\r\n" + "SEQUENCE:0" + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(uid, iCal));
        Appointment appointment = super.getAppointment(uid);
        Assert.assertNotNull((String)"appointmnet not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        Assert.assertEquals((String)"title wrong", (Object)summary, (Object)appointment.getTitle());
        Assert.assertTrue((String)"full time wrong", (boolean)appointment.getFullTime());
        ICalResource iCalResource = super.get(uid, null);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"START wrong", (Object)start, (Object)iCalResource.getVEvent().getDTStart());
        Assert.assertEquals((String)"END wrong", (Object)end, (Object)iCalResource.getVEvent().getDTEnd());
    }

    @Test
    public void testAllDayOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = NewTest.randomUID();
        String summary = "all day";
        String location = "testing";
        Date start = TimeTools.D("next monday at midnight");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.add(6, 1);
        Date end = calendar.getTime();
        Appointment appointment = NewTest.generateAppointment(start, end, uid, summary, location);
        appointment.setFullTime(true);
        super.rememberForCleanUp(super.create(appointment));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = NewTest.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
        Assert.assertEquals((String)"START wrong", (Object)start, (Object)iCalResource.getVEvent().getDTStart());
        Assert.assertEquals((String)"END wrong", (Object)end, (Object)iCalResource.getVEvent().getDTEnd());
    }

    @Test
    public void testCreateWithDifferentName() throws Exception {
        String resourceName = NewTest.randomUID();
        String uid = NewTest.randomUID();
        String summary = "test with filename";
        String location = "loco";
        Date start = TimeTools.D("last sunday at 2am");
        Date end = TimeTools.D("last sunday at 7am");
        String iCal = NewTest.generateICal(start, end, uid, summary, location);
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(resourceName, iCal));
        Appointment appointment = super.getAppointment(uid);
        super.rememberForCleanUp(appointment);
        NewTest.assertAppointmentEquals(appointment, start, end, uid, summary, location);
        ICalResource iCalResource = super.get(resourceName, null);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
    }
}

