/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug31453Test
extends CalDAVTest {
    private FolderObject publicFolder = null;
    private String publicFolderID = null;

    @Before
    public void setUp() throws Exception {
        this.publicFolder = this.createPublicFolder();
        this.publicFolderID = String.valueOf(this.publicFolder.getObjectID());
    }

    @Test
    public void testCreateReminderInClient() throws Exception {
        String uid = Bug31453Test.randomUID();
        Date start = TimeTools.D("next sunday at 14:15");
        Date end = TimeTools.D("next sunday at 15:30");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nMETHOD:REQUEST\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.2//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:CEST\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:CET\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTEND;TZID=Europe/Berlin:" + Bug31453Test.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug31453Test.formatAsUTC(new Date()) + "\r\n" + "LOCATION:loc" + "\r\n" + "DESCRIPTION:stripped" + "\r\n" + "SEQUENCE:2" + "\r\n" + "SUMMARY:test" + "\r\n" + "BEGIN:VALARM" + "\r\n" + "X-WR-ALARMUID:" + uid + "\r\n" + "UID:" + uid + "\r\n" + "TRIGGER:-PT15M" + "\r\n" + "DESCRIPTION:Ereignisbenachrichtigung" + "\r\n" + "ACTION:DISPLAY" + "\r\n" + "END:VALARM" + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug31453Test.format(start, "Europe/Berlin") + "\r\n" + "CREATED:" + Bug31453Test.formatAsUTC(TimeTools.D("yesterday noon")) + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(this.publicFolderID, uid, iCal));
        Appointment appointment = super.getAppointment(this.publicFolderID, uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minuteswrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = super.get(this.publicFolderID, uid, null);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
    }

    @Test
    public void testRemoveReminderInClient() throws Exception {
        String uid = Bug31453Test.randomUID();
        Date start = TimeTools.D("next sunday at 14:15");
        Date end = TimeTools.D("next sunday at 15:30");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nMETHOD:REQUEST\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.2//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:CEST\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:CET\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTEND;TZID=Europe/Berlin:" + Bug31453Test.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug31453Test.formatAsUTC(new Date()) + "\r\n" + "LOCATION:loc" + "\r\n" + "DESCRIPTION:stripped" + "\r\n" + "SEQUENCE:2" + "\r\n" + "SUMMARY:test" + "\r\n" + "BEGIN:VALARM" + "\r\n" + "X-WR-ALARMUID:" + uid + "\r\n" + "UID:" + uid + "\r\n" + "TRIGGER:-PT15M" + "\r\n" + "DESCRIPTION:Ereignisbenachrichtigung" + "\r\n" + "ACTION:DISPLAY" + "\r\n" + "END:VALARM" + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug31453Test.format(start, "Europe/Berlin") + "\r\n" + "CREATED:" + Bug31453Test.formatAsUTC(TimeTools.D("yesterday noon")) + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(this.publicFolderID, uid, iCal));
        Appointment appointment = super.getAppointment(this.publicFolderID, uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = super.get(this.publicFolderID, uid, null);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        SimpleICal.Component vAlarm = iCalResource.getVEvent().getVAlarm();
        iCalResource.getVEvent().getComponents().remove(vAlarm);
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(this.publicFolderID, uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertFalse((String)"reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)0L, (long)appointment.getAlarm());
        iCalResource = super.get(this.publicFolderID, uid, iCalResource.getETag());
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNull((String)"ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
    }

    @Test
    public void testEditReminderInClient() throws Exception {
        String uid = Bug31453Test.randomUID();
        Date start = TimeTools.D("next sunday at 14:15");
        Date end = TimeTools.D("next sunday at 15:30");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nMETHOD:REQUEST\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.2//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:CEST\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:CET\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTEND;TZID=Europe/Berlin:" + Bug31453Test.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug31453Test.formatAsUTC(new Date()) + "\r\n" + "LOCATION:loc" + "\r\n" + "DESCRIPTION:stripped" + "\r\n" + "SEQUENCE:2" + "\r\n" + "SUMMARY:test" + "\r\n" + "BEGIN:VALARM" + "\r\n" + "X-WR-ALARMUID:" + uid + "\r\n" + "UID:" + uid + "\r\n" + "TRIGGER:-PT15M" + "\r\n" + "DESCRIPTION:Ereignisbenachrichtigung" + "\r\n" + "ACTION:DISPLAY" + "\r\n" + "END:VALARM" + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug31453Test.format(start, "Europe/Berlin") + "\r\n" + "CREATED:" + Bug31453Test.formatAsUTC(TimeTools.D("yesterday noon")) + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(this.publicFolderID, uid, iCal));
        Appointment appointment = super.getAppointment(this.publicFolderID, uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = super.get(this.publicFolderID, uid, null);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        iCalResource.getVEvent().getVAlarm().setProperty("TRIGGER", "-PT20M");
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(this.publicFolderID, uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)20L, (long)appointment.getAlarm());
        iCalResource = super.get(this.publicFolderID, uid, iCalResource.getETag());
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT20M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
    }

    @Test
    public void testCreateReminderAtServer() throws Exception {
        String uid = Bug31453Test.randomUID();
        Date start = TimeTools.D("next friday at 08:50");
        Date end = TimeTools.D("next friday at 09:20");
        Appointment appointment = Bug31453Test.generateAppointment(start, end, uid, "test", "test");
        appointment.setAlarm(30);
        appointment = this.create(this.publicFolderID, appointment);
        ICalResource iCalResource = super.get(String.valueOf(this.publicFolder.getObjectID()), uid, null);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT30M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
    }

    @Test
    public void testRemoveReminderAtServer() throws Exception {
        String uid = Bug31453Test.randomUID();
        Date start = TimeTools.D("next friday at 08:50");
        Date end = TimeTools.D("next friday at 09:20");
        Appointment appointment = Bug31453Test.generateAppointment(start, end, uid, "test", "test");
        appointment.setAlarm(30);
        appointment = this.create(this.publicFolderID, appointment);
        ICalResource iCalResource = super.get(String.valueOf(this.publicFolder.getObjectID()), uid, null);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT30M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        appointment.setAlarm(-1);
        super.update(appointment);
        iCalResource = super.get(this.publicFolderID, uid, iCalResource.getETag());
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNull((String)"ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
    }

    @Test
    public void testEditReminderAtServer() throws Exception {
        String uid = Bug31453Test.randomUID();
        Date start = TimeTools.D("next friday at 08:50");
        Date end = TimeTools.D("next friday at 09:20");
        Appointment appointment = Bug31453Test.generateAppointment(start, end, uid, "test", "test");
        appointment.setAlarm(30);
        appointment = this.create(this.publicFolderID, appointment);
        ICalResource iCalResource = super.get(String.valueOf(this.publicFolder.getObjectID()), uid, null);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT30M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        appointment.setAlarm(20);
        super.update(appointment);
        iCalResource = super.get(this.publicFolderID, uid, iCalResource.getETag());
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT20M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
    }
}

