/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug27224Test
extends CalDAVTest {
    @Test
    public void testChangetransparency() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = Bug27224Test.randomUID();
        String summary = "Bug27224Test";
        String location = "da";
        Date start = TimeTools.D("next friday at 02:00");
        Date end = TimeTools.D("next friday at 04:00");
        Appointment appointment = Bug27224Test.generateAppointment(start, end, uid, summary, location);
        appointment.setShownAs(1);
        super.rememberForCleanUp(super.create(appointment));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug27224Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
        if (null != iCalResource.getVEvent().getTransp()) {
            Assert.assertEquals((String)"TRANSP wrong", (Object)"OPAQUE", (Object)iCalResource.getVEvent().getTransp());
        }
        iCalResource.getVEvent().setTransp("TRANSPARENT");
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertEquals((String)"shown as wrong", (long)4L, (long)appointment.getShownAs());
        iCalResource = super.get(uid, iCalResource.getETag());
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertEquals((String)"TRANSP wrong", (Object)"TRANSPARENT", (Object)iCalResource.getVEvent().getTransp());
    }
}

