/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug23612Test
extends CalDAVTest {
    @Test
    public void testUpdateAppointment() throws Exception {
        for (int shownAs : new int[]{4, 2, 1, 3}) {
            this.updateAppointment(shownAs);
        }
    }

    private void updateAppointment(int appointmentShownAs) throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = Bug23612Test.randomUID();
        String summary = "Bug23612Test-" + appointmentShownAs;
        String location = "ja";
        Date start = TimeTools.D("next monday at 5:00");
        Date end = TimeTools.D("next monday at 5:55");
        Appointment appointment = Bug23612Test.generateAppointment(start, end, uid, summary, location);
        appointment.setShownAs(appointmentShownAs);
        super.rememberForCleanUp(super.create(appointment));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug23612Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
        if (null != iCalResource.getVEvent().getTransp()) {
            Assert.assertEquals((String)"TRANSP wrong", (Object)(4 == appointmentShownAs ? "TRANSPARENT" : "OPAQUE"), (Object)iCalResource.getVEvent().getTransp());
        }
        iCalResource.getVEvent().setSummary(appointment.getTitle() + "_edit");
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertEquals((String)"shown as wrong", (long)appointmentShownAs, (long)appointment.getShownAs());
    }
}

