/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.exception.OXException;

public final class Config {
    private Config() {
    }

    public static String getBaseUri() throws OXException {
        return Config.getProtocol() + "://" + Config.getHostname();
    }

    public static AJAXClient.User getUser() {
        return AJAXClient.User.User1;
    }

    public static String getLogin() throws OXException {
        return Config.getLogin(Config.getUser());
    }

    public static String getUsername() throws OXException {
        return Config.getUsername(Config.getUser());
    }

    public static String getPassword() throws OXException {
        return Config.getPassword(Config.getUser());
    }

    public static String getHostname() throws OXException {
        String hostname = AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME);
        if (null == hostname) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{AJAXConfig.Property.HOSTNAME.getPropertyName()});
        }
        return hostname;
    }

    public static String getProtocol() throws OXException {
        String hostname = AJAXConfig.getProperty(AJAXConfig.Property.PROTOCOL);
        if (null == hostname) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{AJAXConfig.Property.PROTOCOL.getPropertyName()});
        }
        return hostname;
    }

    public static String getLogin(AJAXClient.User user) throws OXException {
        String login = AJAXConfig.getProperty(user.getLogin());
        if (null == login) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{user.getLogin().getPropertyName()});
        }
        if (login.contains("@")) {
            return login;
        }
        String context = AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        if (null == context) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{AJAXConfig.Property.CONTEXTNAME.getPropertyName()});
        }
        return login + "@" + context;
    }

    public static String getUsername(AJAXClient.User user) throws OXException {
        String username = AJAXConfig.getProperty(user.getLogin());
        if (null == username) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{user.getLogin().getPropertyName()});
        }
        return username.contains("@") ? username.substring(0, username.indexOf("@")) : username;
    }

    public static String getPassword(AJAXClient.User user) throws OXException {
        String password = AJAXConfig.getProperty(user.getPassword());
        if (null == password) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{user.getPassword().getPropertyName()});
        }
        return password;
    }
}

