/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.storage;

import com.openexchange.contact.Data;
import com.openexchange.contact.storage.ContactStorageTest;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.Test;

public class CreateTest
extends ContactStorageTest {
    @Test
    public void testCreateSimple() throws Exception {
        String folderId = "500002";
        Contact contact = new Contact();
        contact.setCreatedBy(this.getUserID());
        contact.setDisplayName("Otto Maier");
        contact.setGivenName("Otto");
        contact.setSurName("Maier");
        contact.setEmail1("otto.maier@example.com");
        contact.setUid(UUID.randomUUID().toString());
        this.getStorage().create(this.getSession(), "500002", contact);
        super.rememberForCleanUp(contact);
        Contact savedContact = super.findContact(contact.getUid(), "500002");
        CreateTest.assertNotNull((String)"contact not found", (Object)savedContact);
        CreateTest.assertEquals((String)"display name wrong", (String)contact.getDisplayName(), (String)savedContact.getDisplayName());
        CreateTest.assertEquals((String)"surname wrong", (String)contact.getSurName(), (String)savedContact.getSurName());
        CreateTest.assertEquals((String)"givenname wrong", (String)contact.getGivenName(), (String)savedContact.getGivenName());
        CreateTest.assertEquals((String)"email1 wrong", (String)contact.getEmail1(), (String)savedContact.getEmail1());
    }

    @Test
    public void testCreateWithImage() throws Exception {
        String folderId = "500004";
        Contact contact = new Contact();
        contact.setCreatedBy(this.getUserID());
        contact.setDisplayName("Dirk Dampf");
        contact.setGivenName("Dirk");
        contact.setSurName("Dampf");
        contact.setEmail1("dirk.dampf@example.com");
        contact.setUid(UUID.randomUUID().toString());
        contact.setImage1(Data.image);
        contact.setImageContentType("image/png");
        this.getStorage().create(this.getSession(), "500004", contact);
        super.rememberForCleanUp(contact);
        Contact savedContact = super.findContact(contact.getUid(), "500004");
        CreateTest.assertNotNull((String)"contact not found", (Object)savedContact);
        CreateTest.assertNotNull((String)"no image found", (Object)savedContact.getImage1());
        CreateTest.assertEquals((String)"number of images wrong", (int)1, (int)savedContact.getNumberOfImages());
        CreateTest.assertTrue((String)"image wrong", (boolean)Arrays.equals(contact.getImage1(), savedContact.getImage1()));
        CreateTest.assertEquals((String)"image content type wrong", (String)contact.getImageContentType(), (String)savedContact.getImageContentType());
    }

    @Test
    public void testCreateDistList() throws Exception {
        String folderId = "500003";
        Contact contact = new Contact();
        contact.setCreatedBy(this.getUserID());
        contact.setSurName("Distributionlist 77");
        contact.setUid(UUID.randomUUID().toString());
        contact.setDistributionList(new DistributionListEntryObject[]{new DistributionListEntryObject("Horst Otto", "horst.otto@example.com", 0), new DistributionListEntryObject("Werner Otto", "werner.otto@example.com", 0), new DistributionListEntryObject("Dieter Otto", "dieter.otto@example.com", 0), new DistributionListEntryObject("Klaus Otto", "klaus.otto@example.com", 0), new DistributionListEntryObject("Kurt Otto", "kurt.otto@example.com", 0)});
        this.getStorage().create(this.getSession(), "500003", contact);
        super.rememberForCleanUp(contact);
        Contact savedContact = super.findContact(contact.getUid(), "500003");
        CreateTest.assertNotNull((String)"contact not found", (Object)savedContact);
        CreateTest.assertTrue((String)"not marked as distribution list", (boolean)savedContact.getMarkAsDistribtuionlist());
        CreateTest.assertNotNull((String)"distribution list not found", (Object)savedContact.getDistributionList());
        CreateTest.assertEquals((String)"number of distribution list members wrong", (int)5, (int)savedContact.getNumberOfDistributionLists());
        CreateTest.assertEquals((String)"number of distribution list members wrong", (int)5, (int)savedContact.getDistributionList().length);
        CreateTest.assertTrue((String)"distribution list wrong", (boolean)Arrays.equals(contact.getDistributionList(), savedContact.getDistributionList()));
    }

    @Test
    public void testCreateSpecialChars() throws Exception {
        String folderId = "500001";
        Contact contact = new Contact();
        contact.setCreatedBy(this.getUserID());
        contact.setDisplayName("Ren\u00e9 M\u00fcller");
        contact.setGivenName("Ren\u00e9");
        contact.setSurName("M\u00fcller");
        contact.setEmail1("rene.mueller@example.com");
        contact.setUid(UUID.randomUUID().toString());
        this.getStorage().create(this.getSession(), "500001", contact);
        super.rememberForCleanUp(contact);
        Contact savedContact = super.findContact(contact.getUid(), "500001");
        CreateTest.assertNotNull((String)"contact not found", (Object)savedContact);
        CreateTest.assertEquals((String)"display name wrong", (String)contact.getDisplayName(), (String)savedContact.getDisplayName());
        CreateTest.assertEquals((String)"surname wrong", (String)contact.getSurName(), (String)savedContact.getSurName());
        CreateTest.assertEquals((String)"givenname wrong", (String)contact.getGivenName(), (String)savedContact.getGivenName());
        CreateTest.assertEquals((String)"email1 wrong", (String)contact.getEmail1(), (String)savedContact.getEmail1());
    }

    @Test
    public void testCreateMany() throws Exception {
        HashMap contactsInFolders = new HashMap();
        for (int i = 500004; i <= 500005; ++i) {
            contactsInFolders.put(Integer.toString(i), new ArrayList());
            for (int j = 1; j <= 33; ++j) {
                Contact contact = new Contact();
                contact.setCreatedBy(this.getUserID());
                contact.setDisplayName("Kontakt_" + i + " Test_" + j);
                contact.setGivenName("Kontakt_" + i);
                contact.setSurName("Test_" + j);
                contact.setEmail1("kontakt" + i + ".test" + j + "@example.com");
                contact.setUid(UUID.randomUUID().toString());
                this.getStorage().create(this.getSession(), Integer.toString(i), contact);
                ((List)contactsInFolders.get(Integer.toString(i))).add(contact);
                super.rememberForCleanUp(contact);
            }
        }
        for (Map.Entry entry : contactsInFolders.entrySet()) {
            String folderId = (String)entry.getKey();
            for (Contact contact : (List)entry.getValue()) {
                Contact savedContact = this.getStorage().get(this.getSession(), folderId, Integer.toString(contact.getObjectID()), ContactField.values());
                CreateTest.assertNotNull((String)"contact not found", (Object)savedContact);
                CreateTest.assertEquals((String)"uid wrong", (String)contact.getUid(), (String)savedContact.getUid());
            }
        }
    }
}

