/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.admin.rmi.OXUserInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.User;
import com.openexchange.admin.rmi.dataobjects.UserProperty;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.GetLinkRequest;
import com.openexchange.ajax.share.actions.GetLinkResponse;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.quota.QuotaExceptionCodes;
import com.openexchange.share.ShareTarget;
import java.rmi.Naming;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuotaTest
extends ShareTest {
    private AJAXClient client2;
    private Map<Integer, FolderObject> foldersToDelete;

    public QuotaTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.foldersToDelete = new HashMap<Integer, FolderObject>();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.setQuota("com.openexchange.quota.share_links", "0");
        this.setQuota("com.openexchange.quota.invite_guests", "0");
    }

    private void setQuota(String property, String value) throws Exception {
        User user = new User(this.client2.getValues().getUserId());
        user.setUserAttribute("config", property, value);
        Credentials credentials = new Credentials(AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getLogin()), AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getPassword()));
        OXUserInterface iface = (OXUserInterface)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + "OXUser_V2");
        iface.change(new Context(Integer.valueOf(this.client2.getValues().getContextId())), user, credentials);
        List userConfigurationSource = iface.getUserConfigurationSource(new Context(Integer.valueOf(this.client2.getValues().getContextId())), user, "quota", credentials);
        System.out.println("User configuration related to 'quota' after changing '" + property + "' to " + value + ".");
        for (UserProperty prop : userConfigurationSource) {
            System.out.println("Property " + prop.getName() + "(" + prop.getScope() + "): " + prop.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            if (null != this.client2) {
                this.setQuota("com.openexchange.quota.share_links", null);
                this.setQuota("com.openexchange.quota.invite_guests", null);
                if (null != this.foldersToDelete && 0 < this.foldersToDelete.size()) {
                    QuotaTest.deleteFoldersSilently(this.client2, this.foldersToDelete);
                }
                this.client2.logout();
            }
        }
        finally {
            super.tearDown();
        }
    }

    public void testShareLinkButQuotaLimitReached() throws Exception {
        FolderObject folder = QuotaTest.insertPrivateFolder(this.client2, EnumAPI.OX_NEW, 8, QuotaTest.getDefaultFolder(this.client2, 8));
        this.foldersToDelete.put(folder.getObjectID(), folder);
        GetLinkRequest getLinkRequest = new GetLinkRequest(new ShareTarget(8, String.valueOf(folder.getObjectID())));
        getLinkRequest.setFailOnError(false);
        GetLinkResponse getLinkResponse = this.client2.execute(getLinkRequest);
        if (getLinkResponse.hasError()) {
            OXException e = getLinkResponse.getException();
            QuotaTest.assertTrue((String)("Unexpected exception: " + (Object)((Object)e)), (boolean)QuotaExceptionCodes.QUOTA_EXCEEDED_SHARES.equals(e));
        } else {
            folder = QuotaTest.insertPrivateFolder(this.client2, EnumAPI.OX_NEW, 8, QuotaTest.getDefaultFolder(this.client2, 8));
            this.foldersToDelete.put(folder.getObjectID(), folder);
            getLinkRequest = new GetLinkRequest(new ShareTarget(8, String.valueOf(folder.getObjectID())));
            getLinkRequest.setFailOnError(false);
            getLinkResponse = this.client2.execute(getLinkRequest);
            QuotaTest.assertTrue((String)"No errors in response", (boolean)getLinkResponse.hasError());
            OXException e = getLinkResponse.getException();
            QuotaTest.assertTrue((String)("Unexpected exception: " + (Object)((Object)e)), (boolean)QuotaExceptionCodes.QUOTA_EXCEEDED_SHARES.equals(e));
        }
    }

    public void testInviteGuestButQuotaLimitReached() throws Exception {
        OXException e;
        FolderObject folder = QuotaTest.insertPrivateFolder(this.client2, EnumAPI.OX_NEW, 8, QuotaTest.getDefaultFolder(this.client2, 8));
        this.foldersToDelete.put(folder.getObjectID(), folder);
        folder.getPermissions().add(QuotaTest.createNamedAuthorPermission(QuotaTest.randomUID() + "@example.com", QuotaTest.randomUID()));
        UpdateRequest request = new UpdateRequest((API)EnumAPI.OX_NEW, folder);
        request.setFailOnError(false);
        User user = new User(this.client2.getValues().getUserId());
        Credentials credentials = new Credentials(AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getLogin()), AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getPassword()));
        OXUserInterface iface = (OXUserInterface)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + "OXUser_V2");
        List userConfigurationSource = iface.getUserConfigurationSource(new Context(Integer.valueOf(this.client2.getValues().getContextId())), user, "quota", credentials);
        System.out.println("User configuration related to 'quota' for the test user at SETUP.");
        for (UserProperty prop : userConfigurationSource) {
            System.out.println("Property " + prop.getName() + "(" + prop.getScope() + "): " + prop.getValue());
        }
        InsertResponse updateResponse = this.client2.execute(request);
        if (updateResponse.hasError()) {
            e = updateResponse.getException();
            QuotaTest.assertTrue((String)("Unexpected exception: " + (Object)((Object)e)), (boolean)QuotaExceptionCodes.QUOTA_EXCEEDED_SHARES.equals(e));
        } else {
            folder = QuotaTest.getFolder(EnumAPI.OX_NEW, folder.getObjectID(), this.client2);
            folder.getPermissions().add(QuotaTest.createNamedAuthorPermission(QuotaTest.randomUID() + "@example.com", QuotaTest.randomUID()));
            request = new UpdateRequest((API)EnumAPI.OX_NEW, folder);
            request.setFailOnError(false);
            updateResponse = this.client2.execute(request);
            QuotaTest.assertTrue((String)"No errors in response", (boolean)updateResponse.hasError());
            e = updateResponse.getException();
            QuotaTest.assertTrue((String)("Unexpected exception: " + (Object)((Object)e)), (boolean)QuotaExceptionCodes.QUOTA_EXCEEDED_SHARES.equals(e));
        }
    }
}

