/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.bugs;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.file.storage.DefaultFileStorageObjectPermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.groupware.container.FolderObject;
import edu.emory.mathcs.backport.java.util.Collections;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;

public class Bug40527Test
extends ShareTest {
    public Bug40527Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInternalFileShareLinkOnSharedCreation() throws Exception {
        AJAXClient shareClient = new AJAXClient(AJAXClient.User.User2);
        try {
            FolderObject folder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.client.getValues().getPrivateInfostoreFolder());
            DefaultFileStorageObjectPermission sharePermission = new DefaultFileStorageObjectPermission(shareClient.getValues().getUserId(), false, 1);
            File file = this.insertSharedFile(folder.getObjectID(), Bug40527Test.randomUID(), (FileStorageObjectPermission)sharePermission);
            String invitationLink = this.discoverInvitationLink(this.client, shareClient.getValues().getDefaultAddress());
            Assert.assertNotNull((String)"Invitation link not found", (Object)invitationLink);
            String fragmentParams = new URI(invitationLink).getRawFragment();
            Matcher folderMatcher = Pattern.compile("folder=([0-9]+)").matcher(fragmentParams);
            Assert.assertTrue((String)"Folder param missing in fragment", (boolean)folderMatcher.find());
            Assert.assertEquals((Object)"10", (Object)folderMatcher.group(1));
            Matcher fileMatcher = Pattern.compile("id=([0-9]+/[0-9]+)").matcher(fragmentParams);
            Assert.assertTrue((String)"ID param missing in fragment", (boolean)fileMatcher.find());
            FileID fileID = new FileID(file.getId());
            fileID.setFolderId("10");
            Assert.assertEquals((Object)fileID.toUniqueID(), (Object)fileMatcher.group(1));
        }
        finally {
            shareClient.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInternalFileShareLinkOnSubsequentShare() throws Exception {
        AJAXClient shareClient = new AJAXClient(AJAXClient.User.User2);
        try {
            FolderObject folder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.client.getValues().getPrivateInfostoreFolder());
            File file = this.insertFile(folder.getObjectID());
            file.setObjectPermissions(Collections.singletonList((Object)new DefaultFileStorageObjectPermission(shareClient.getValues().getUserId(), false, 1)));
            this.updateFile(file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
            String invitationLink = this.discoverInvitationLink(this.client, shareClient.getValues().getDefaultAddress());
            Assert.assertNotNull((String)"Invitation link not found", (Object)invitationLink);
            String fragmentParams = new URI(invitationLink).getRawFragment();
            Matcher folderMatcher = Pattern.compile("folder=([0-9]+)").matcher(fragmentParams);
            Assert.assertTrue((String)"Folder param missing in fragment", (boolean)folderMatcher.find());
            Assert.assertEquals((Object)"10", (Object)folderMatcher.group(1));
            Matcher fileMatcher = Pattern.compile("id=([0-9]+/[0-9]+)").matcher(fragmentParams);
            Assert.assertTrue((String)"ID param missing in fragment", (boolean)fileMatcher.find());
            FileID fileID = new FileID(file.getId());
            fileID.setFolderId("10");
            Assert.assertEquals((Object)fileID.toUniqueID(), (Object)fileMatcher.group(1));
        }
        finally {
            shareClient.logout();
        }
    }
}

